/*
 * Decompiled with CFR 0.152.
 */
package com.atticlabs.zonelayout.swing;

import com.atticlabs.zonelayout.swing.AxisView;
import com.atticlabs.zonelayout.swing.Column;
import com.atticlabs.zonelayout.swing.DisplaySizeView;
import com.atticlabs.zonelayout.swing.MathRoutines;
import com.atticlabs.zonelayout.swing.MinimumSizeView;
import com.atticlabs.zonelayout.swing.Modifier;
import com.atticlabs.zonelayout.swing.PreferredSizeView;
import com.atticlabs.zonelayout.swing.Preset;
import com.atticlabs.zonelayout.swing.Row;
import com.atticlabs.zonelayout.swing.Section;
import com.atticlabs.zonelayout.swing.SizeView;
import com.atticlabs.zonelayout.swing.Template;
import com.atticlabs.zonelayout.swing.Zone;
import com.atticlabs.zonelayout.swing.ZoneContext;
import com.atticlabs.zonelayout.swing.ZoneLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ZoneLayoutImpl
implements ZoneLayout {
    static final Map DEFAULT_PRESETS;
    static final String PREFIX_COMPONENT_PRESET = "ComponentPreset";
    Map componentPresets = new HashMap(DEFAULT_PRESETS);
    List rowDefinitions = new ArrayList();
    int rowDefinitionLength = -1;
    List rows;
    List columns;
    Map zones = new HashMap();
    Map templateNameMap = new HashMap();
    List templates = new ArrayList();
    Map bindings = new HashMap();
    IdentityHashMap allPoints = new IdentityHashMap();
    boolean compiled;
    boolean sectionSizesComputed;

    public Map getZones() {
        return this.zones;
    }

    public ZoneLayout addRow(String string) {
        if (this.compiled) {
            throw new RuntimeException("You cannot change the definition of the layout after adding components.");
        }
        if ("".equals(string)) {
            throw new RuntimeException("Row definition cannot be an empty string.");
        }
        if (this.rowDefinitionLength < 0) {
            this.rowDefinitionLength = string.length();
        } else if (string.length() != this.rowDefinitionLength) {
            throw new RuntimeException("Row #" + (this.rowDefinitions.size() + 1) + " in layout definition does " + "not match the length of previous rows.");
        }
        this.rowDefinitions.add(string);
        this.preProcessRow(string);
        return this;
    }

    public ZoneLayout addRow(String string, String string2) {
        Template template = (Template)this.templateNameMap.get(string2);
        if (template == null) {
            template = new Template(string2, this.rowDefinitions.size());
            this.templateNameMap.put(template.getName(), template);
            this.templates.add(template);
        } else {
            template.incrementEndPoint();
        }
        this.addRow(string);
        return this;
    }

    public void insertTemplate(String string) {
        this.compile();
        Template template = (Template)this.templateNameMap.get(string);
        if (template == null) {
            throw new RuntimeException("Unknown template name '" + string + "'");
        }
        AxisView axisView = template.getView();
        ZoneContext zoneContext = template.getNewZoneContext();
        this.zones.putAll(zoneContext.getZones());
        if (template.getLastContext() != null) {
            template.setLastContextZoneIds();
            this.zones.putAll(template.getLastContext().getZones());
        }
        template.setLastContext(zoneContext);
        int n = axisView.getValue(template.getInsertionPoint());
        int n2 = axisView.getValue(template.getEndPoint()) - n + 1;
        this.adjustAllPoints(axisView, n, n2);
    }

    public void setPresetComponent(int n, Preset preset) {
        if (n < 1 || n > 9) {
            throw new IllegalArgumentException("presetId must be from 1 - 9");
        }
        this.componentPresets.put(String.valueOf(n), preset);
    }

    public Preset getPreset(int n) {
        return (Preset)this.componentPresets.get(String.valueOf(n));
    }

    public Zone getZone(String string) {
        return (Zone)this.zones.get(string);
    }

    void preProcessRow(String string) {
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            if (!Character.isLetter(c) || this.zones.containsKey(string2 = String.valueOf(c))) continue;
            this.zones.put(string2, new Zone(string2));
        }
    }

    public void compile() {
        this.compile(true);
    }

    void compile(boolean bl) {
        Zone zone;
        Object object;
        char c;
        Object object2;
        if (this.compiled) {
            return;
        }
        ArrayList<Modifier> arrayList = new ArrayList<Modifier>();
        int n = 0;
        int n2 = 0;
        Iterator iterator = this.rowDefinitions.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            for (n = 0; n < ((String)object2).length(); ++n) {
                c = ((String)object2).charAt(n);
                if ('.' == c) continue;
                if (Character.isLetter(c)) {
                    object = (Zone)this.zones.get(String.valueOf(c));
                    if (!((Zone)object).isRootSet()) {
                        ((Zone)object).setRoot(n, n2);
                        continue;
                    }
                    if (n < ((Zone)object).getRoot().x) {
                        throw new RuntimeException("The second identifier '" + c + "' must mark the bottom right corner.");
                    }
                    ((Zone)object).setSecondRoot(n, n2);
                    continue;
                }
                if (Character.isDigit(c)) {
                    object = Character.toString(c);
                    if (this.componentPresets.containsKey(object)) {
                        zone = new Zone("ComponentPreset-" + c + "-" + this.zones.keySet().size());
                        this.getPreset(Integer.parseInt((String)object)).setUpZone(zone);
                        zone.setRoot(n, n2);
                        this.zones.put(zone.getId(), zone);
                        continue;
                    }
                    throw new RuntimeException("Unknown component preset '" + c + "' at " + n + "," + n2);
                }
                if ("<>_^-|+~!*".indexOf(c) != -1) {
                    arrayList.add(new Modifier(n, n2, c));
                    continue;
                }
                throw new RuntimeException("Unknown character '" + c + "' at " + n + "," + n2);
            }
            ++n2;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            object2 = (Modifier)arrayList.get(i);
            c = '\u0000';
            object = this.zones.values().iterator();
            while (object.hasNext()) {
                zone = (Zone)object.next();
                if (!zone.contains(((Modifier)object2).getX(), ((Modifier)object2).getY())) continue;
                ((Modifier)object2).modifyZone(zone);
                c = '\u0001';
            }
            if (c != '\u0000') continue;
            if ("~!*".indexOf(((Modifier)object2).getCharacter()) != -1) {
                object = new Zone("ComponentPreset-" + ((Modifier)object2).getCharacter() + "-" + this.zones.keySet().size());
                Preset.getSpecialPreset(((Modifier)object2).getCharacter()).setUpZone((Zone)object);
                ((Zone)object).setRoot(((Modifier)object2).getX(), ((Modifier)object2).getY());
                this.zones.put(((Zone)object).getId(), object);
                continue;
            }
            throw new RuntimeException("Unused modifier " + object2);
        }
        this.checkZoneIntersection();
        this.collectAllPoints();
        if (bl) {
            this.optimizeZones(AxisView.X, this.getRowDefinitionWidth());
            this.optimizeZones(AxisView.Y, this.getRowDefinitionHeight());
        }
        this.removeTemplates();
        this.setDefaultZoneGives();
        this.compiled = true;
    }

    void checkZoneIntersection() {
        ArrayList arrayList = new ArrayList(this.zones.values());
        Iterator iterator = this.zones.values().iterator();
        while (iterator.hasNext()) {
            Zone zone = (Zone)iterator.next();
            arrayList.remove(zone);
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                Zone zone2 = (Zone)iterator2.next();
                if (!zone.intersects(zone2)) continue;
                throw new RuntimeException("Zone '" + zone.getId() + "' intersects zone '" + zone2.getId() + "'.");
            }
            arrayList.add(zone);
        }
    }

    void optimizeZones(AxisView axisView, int n) {
        Point point = new Point();
        Set set = null;
        Set set2 = null;
        for (int i = 0; i < n; ++i) {
            axisView.setValue(point, i);
            set2 = this.getZonesThatIntersectAxisLine(axisView, point);
            if (set2.isEmpty()) {
                this.adjustAllPoints(axisView, i, -1);
                --i;
                --n;
            } else if (set != null && ((Object)set2).equals(set)) {
                this.adjustAllPoints(axisView, i, -1);
                --i;
                --n;
            }
            set = set2;
        }
    }

    Set getZonesThatIntersectAxisLine(AxisView axisView, Point point) {
        HashSet<Zone> hashSet = new HashSet<Zone>();
        Iterator iterator = this.zones.values().iterator();
        while (iterator.hasNext()) {
            Zone zone = (Zone)iterator.next();
            if (!zone.intersectsAxisLine(axisView, point)) continue;
            hashSet.add(zone);
        }
        return hashSet;
    }

    void collectAllPoints() {
        Object object;
        Iterator iterator = this.zones.values().iterator();
        while (iterator.hasNext()) {
            object = (Zone)iterator.next();
            this.allPoints.put(((Zone)object).getRoot(), null);
            this.allPoints.put(((Zone)object).getSecondRoot(), null);
        }
        iterator = this.templateNameMap.values().iterator();
        while (iterator.hasNext()) {
            object = (Template)iterator.next();
            this.allPoints.put(((Template)object).getInsertionPoint(), null);
            this.allPoints.put(((Template)object).getEndPoint(), null);
        }
    }

    void adjustAllPoints(AxisView axisView, int n, int n2) {
        Iterator iterator = this.allPoints.keySet().iterator();
        while (iterator.hasNext()) {
            Point point = (Point)iterator.next();
            if (axisView.getValue(point) < n) continue;
            axisView.adjust(point, n2);
        }
    }

    Set getZonesContainedWithinAxisLines(AxisView axisView, Point point, Point point2) {
        HashSet<Zone> hashSet = new HashSet<Zone>();
        Iterator iterator = this.zones.values().iterator();
        while (iterator.hasNext()) {
            Zone zone = (Zone)iterator.next();
            if (axisView.getValue(zone.getRoot()) < axisView.getValue(point) || axisView.getValue(zone.getSecondRoot()) > axisView.getValue(point2)) continue;
            hashSet.add(zone);
        }
        return hashSet;
    }

    int getRowDefinitionWidth() {
        return ((String)this.rowDefinitions.get(0)).length();
    }

    int getRowDefinitionHeight() {
        return this.rowDefinitions.size();
    }

    void removeTemplates() {
        Template template;
        Iterator iterator = this.templates.iterator();
        while (iterator.hasNext()) {
            template = (Template)iterator.next();
            AxisView axisView = template.getView();
            Set set = this.getZonesContainedWithinAxisLines(axisView, template.getInsertionPoint(), template.getEndPoint());
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Zone zone = (Zone)iterator2.next();
                this.zones.remove(zone.getId());
                this.allPoints.remove(zone.getRoot());
                this.allPoints.remove(zone.getSecondRoot());
                template.addZone(zone);
            }
            int n = axisView.getValue(template.getEndPoint()) + 1;
            int n2 = axisView.getValue(template.getEndPoint()) - axisView.getValue(template.getInsertionPoint()) + 1;
            this.adjustAllPoints(axisView, n, -1 * n2);
            this.allPoints.remove(template.getInsertionPoint());
            this.allPoints.remove(template.getEndPoint());
        }
        iterator = this.templates.iterator();
        while (iterator.hasNext()) {
            template = (Template)iterator.next();
            this.allPoints.put(template.getInsertionPoint(), null);
            this.allPoints.put(template.getEndPoint(), null);
        }
    }

    void setDefaultZoneGives() {
        Iterator iterator = this.zones.values().iterator();
        while (iterator.hasNext()) {
            Zone zone = (Zone)iterator.next();
            if (zone.isGiveUserSet()) continue;
            zone.setGive(zone.getGive().horizontal * zone.getWidth(), zone.getGive().vertical);
            zone.setGive(zone.getGive().horizontal, zone.getGive().vertical * zone.getHeight());
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        this.compile();
        if (!(object instanceof String)) {
            throw new RuntimeException("Illegal constraint (must be a String identifying a zone).");
        }
        String string = (String)object;
        Zone zone = (Zone)this.zones.get(string);
        if (zone == null) {
            throw new RuntimeException("Unknown zone '" + object + "'");
        }
        zone.setComponent(component);
        this.bindings.put(component, zone);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateLayout(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.rows = null;
            this.columns = null;
            this.sectionSizesComputed = false;
            Iterator iterator = this.zones.values().iterator();
            while (iterator.hasNext()) {
                Zone zone = (Zone)iterator.next();
                zone.clearCache();
            }
        }
    }

    public void addLayoutComponent(String string, Component component) {
        throw new UnsupportedOperationException("use addLayoutComponent(Component comp, Object constraints).");
    }

    public void removeLayoutComponent(Component component) {
        Zone zone = (Zone)this.bindings.get(component);
        if (zone == null) {
            throw new RuntimeException("The component is not contained in this layout (perhaps replaced by another?).");
        }
        zone.setComponent(null);
        this.bindings.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(new PreferredSizeView(), container);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(new MinimumSizeView(), container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.createSections();
            this.computeSectionSizes();
            Dimension dimension = container.getSize();
            this.layoutSections(container, this.rows, AxisView.Y, AxisView.Y.getSize(dimension));
            this.layoutSections(container, this.columns, AxisView.X, AxisView.X.getSize(dimension));
            this.layoutZones();
            this.layoutComponents(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dimension getLayoutSize(SizeView sizeView, Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.createSections();
            this.computeSectionSizes();
            int n = this.getCombinedSize(this.columns, sizeView);
            int n2 = this.getCombinedSize(this.rows, sizeView);
            return new Dimension(n += container.getInsets().left + container.getInsets().right, n2 += container.getInsets().top + container.getInsets().bottom);
        }
    }

    boolean sectionsCreated() {
        return this.rows != null && this.columns != null;
    }

    void createSections() {
        if (!this.sectionsCreated()) {
            this.compile();
            this.rows = new ArrayList();
            this.columns = new ArrayList();
            this.createColumnsAndRows();
            this.setSectionWeights(this.rows, AxisView.Y);
            this.setSectionWeights(this.columns, AxisView.X);
        }
    }

    void createColumnsAndRows() {
        int n;
        int n2 = this.getMaxZoneAxisValue(AxisView.X);
        for (n = 0; n <= n2; ++n) {
            this.columns.add(new Column(this, n));
        }
        n2 = this.getMaxZoneAxisValue(AxisView.Y);
        for (n = 0; n <= n2; ++n) {
            this.rows.add(new Row(this, n));
        }
    }

    int getMaxZoneAxisValue(AxisView axisView) {
        int n = -1;
        Iterator iterator = this.zones.values().iterator();
        while (iterator.hasNext()) {
            Zone zone = (Zone)iterator.next();
            n = Math.max(n, axisView.getValue(zone.getSecondRoot()));
        }
        return n;
    }

    void computeSectionSizes() {
        if (!this.sectionSizesComputed) {
            this.clearSizes(this.rows);
            this.clearSizes(this.columns);
            this.setSectionSizes(this.rows, AxisView.Y, new MinimumSizeView());
            this.copyMinSizeToPrefSize(this.rows);
            this.setSectionSizes(this.rows, AxisView.Y, new PreferredSizeView());
            this.setSectionSizes(this.columns, AxisView.X, new MinimumSizeView());
            this.copyMinSizeToPrefSize(this.columns);
            this.setSectionSizes(this.columns, AxisView.X, new PreferredSizeView());
            this.sectionSizesComputed = true;
        }
    }

    void clearSizes(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Section section = (Section)list.get(i);
            section.setMinimumSize(0);
            section.setPreferredSize(0);
        }
    }

    void copyMinSizeToPrefSize(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Section section = (Section)iterator.next();
            section.setPreferredSize(section.getMinimumSize());
        }
    }

    void setSectionWeights(List list, AxisView axisView) {
        Object object;
        Iterator<Object> iterator = this.zones.values().iterator();
        while (iterator.hasNext()) {
            object = (Zone)iterator.next();
            if (axisView.getSize((Zone)object) != 1 || axisView.getTake((Zone)object) <= 0) continue;
            Section section = (Section)list.get(axisView.getStart((Zone)object));
            section.setTake(Math.max(section.getTake(), (double)axisView.getTake((Zone)object)));
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Section)iterator.next();
            boolean bl = true;
            double d = axisView.getValue(Zone.MAX_GIVE_OR_TAKE);
            Iterator iterator2 = ((Section)object).getZones().iterator();
            while (iterator2.hasNext()) {
                Zone zone = (Zone)iterator2.next();
                if (axisView.getSize(zone) == 1) {
                    bl = false;
                    break;
                }
                d = Math.min(d, (double)axisView.getTake(zone) / (double)axisView.getSize(zone));
            }
            if (!bl) continue;
            ((Section)object).setTake(d);
        }
        this.initSectionGives(list, axisView);
        iterator = this.zones.values().iterator();
        while (iterator.hasNext()) {
            object = (Zone)iterator.next();
            if (axisView.getSize((Zone)object) > 1 && axisView.getTake((Zone)object) > 0) {
                double d = axisView.getTake((Zone)object);
                double d2 = 0.0;
                for (int i = axisView.getStart((Zone)object); i <= axisView.getFinish((Zone)object); ++i) {
                    Section section = (Section)list.get(i);
                    d2 += section.getTake();
                }
                if (d2 < d) {
                    this.adjustTakes(list, (Zone)object, axisView, d2, d);
                }
            }
            if (axisView.getSize((Zone)object) <= 1) continue;
            int n = 0;
            for (int i = axisView.getStart((Zone)object); i <= axisView.getFinish((Zone)object); ++i) {
                Section section = (Section)list.get(i);
                n = (int)((double)n + section.getGive());
            }
            if (n <= axisView.getGive((Zone)object)) continue;
            this.adjustGives(list, (Zone)object, axisView, n, axisView.getGive((Zone)object));
        }
    }

    void initSectionGives(List list, AxisView axisView) {
        Object object;
        Object object2;
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (Section)iterator.next();
            ((Section)object2).setGive(2.147483647E9);
        }
        iterator = this.zones.values().iterator();
        while (iterator.hasNext()) {
            object2 = (Zone)iterator.next();
            if (axisView.getSize((Zone)object2) != 1) continue;
            object = (Section)list.get(axisView.getStart((Zone)object2));
            ((Section)object).setGive(Math.min(((Section)object).getGive(), (double)axisView.getGive((Zone)object2)));
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (Section)iterator.next();
            if (((Section)object2).getGive() != 2.147483647E9) continue;
            object = ((Section)object2).getZones();
            double d = ((Section)object2).getGive();
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Zone zone = (Zone)iterator2.next();
                int n = this.getGiveRemainingToBeDistributed(list, zone, axisView);
                if (n == 0) {
                    d = 0.0;
                    break;
                }
                int n2 = this.getUnsetGiveSectionCount(list, zone, axisView);
                int n3 = n / n2;
                int n4 = n % n2 > 0 ? 1 : 0;
                int n5 = n3 + n4;
                if (!((double)n5 < d)) continue;
                d = n5;
            }
            ((Section)object2).setGive(d);
        }
    }

    int getGiveRemainingToBeDistributed(List list, Zone zone, AxisView axisView) {
        int n = axisView.getGive(zone);
        for (int i = axisView.getStart(zone); i <= axisView.getFinish(zone); ++i) {
            Section section = (Section)list.get(i);
            if (section.getGive() == 2.147483647E9) continue;
            n = (int)((double)n - section.getGive());
        }
        return Math.max(0, n);
    }

    int getUnsetGiveSectionCount(List list, Zone zone, AxisView axisView) {
        int n = 0;
        for (int i = axisView.getStart(zone); i <= axisView.getFinish(zone); ++i) {
            Section section = (Section)list.get(i);
            if (section.getGive() != 2.147483647E9) continue;
            ++n;
        }
        return n;
    }

    void adjustGives(List list, Zone zone, AxisView axisView, int n, int n2) {
        if (n2 == 0) {
            for (int i = axisView.getStart(zone); i <= axisView.getFinish(zone); ++i) {
                Section section = (Section)list.get(i);
                section.setGive(0.0);
            }
        } else {
            int n3;
            double[] dArray = new double[axisView.getFinish(zone) - axisView.getStart(zone) + 1];
            for (n3 = axisView.getStart(zone); n3 <= axisView.getFinish(zone); ++n3) {
                dArray[n3 - axisView.getStart((Zone)zone)] = ((Section)list.get(n3)).getGive();
            }
            MathRoutines.proportionallyRedistributeValues(dArray, (double)n, (double)n2);
            for (n3 = axisView.getStart(zone); n3 <= axisView.getFinish(zone); ++n3) {
                ((Section)list.get(n3)).setGive(dArray[n3 - axisView.getStart(zone)]);
            }
        }
    }

    void adjustTakes(List list, Zone zone, AxisView axisView, double d, double d2) {
        int n;
        double[] dArray = new double[axisView.getFinish(zone) - axisView.getStart(zone) + 1];
        if (d == 0.0) {
            Arrays.fill(dArray, 1.0);
            d = dArray.length;
        } else {
            for (n = axisView.getStart(zone); n <= axisView.getFinish(zone); ++n) {
                dArray[n - axisView.getStart((Zone)zone)] = ((Section)list.get(n)).getTake();
            }
        }
        MathRoutines.proportionallyRedistributeValues(dArray, d, d2);
        for (n = axisView.getStart(zone); n <= axisView.getFinish(zone); ++n) {
            ((Section)list.get(n)).setTake(dArray[n - axisView.getStart(zone)]);
        }
    }

    void setSectionSizes(List list, AxisView axisView, SizeView sizeView) {
        int n;
        Zone zone;
        Iterator iterator = this.zones.values().iterator();
        while (iterator.hasNext()) {
            zone = (Zone)iterator.next();
            if (axisView.getSize(zone) != 1 || !zone.hasVisibleComponent()) continue;
            Section section = (Section)list.get(axisView.getStart(zone));
            n = sizeView.getSize(section);
            sizeView.setSize(section, Math.max(n, axisView.getSize(sizeView.getSize(zone.getComponentSizeCache()))));
        }
        iterator = this.zones.values().iterator();
        while (iterator.hasNext()) {
            int n2;
            int n3;
            int n4;
            zone = (Zone)iterator.next();
            if (axisView.getSize(zone) <= 1 || !zone.hasVisibleComponent() || (n4 = this.getCombinedSize(list.subList(n3 = axisView.getStart(zone), (n = axisView.getFinish(zone)) + 1), sizeView)) >= (n2 = axisView.getSize(sizeView.getSize(zone.getComponentSizeCache())))) continue;
            this.allocateAdditionalSpace(list.subList(n3, n + 1), n2 - n4, sizeView, true);
        }
    }

    int getCombinedSize(List list, SizeView sizeView) {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            Section section = (Section)list.get(i);
            n += sizeView.getSize(section);
        }
        return n;
    }

    void layoutSections(Container container, List list, AxisView axisView, int n) {
        int n2;
        int n3 = axisView.getSize(this.preferredLayoutSize(container));
        for (n2 = 0; n2 < list.size(); ++n2) {
            Section section = (Section)list.get(n2);
            section.setSize(section.getPreferredSize());
        }
        if (n3 < n) {
            this.allocateAdditionalSpace(list, n - n3, new DisplaySizeView(), false);
        } else if (n3 > n) {
            this.revokeAdditionalSpace(list, n3 - n, new DisplaySizeView(), new MinimumSizeView());
        }
        n2 = axisView.getAdjustment(container.getInsets());
        for (int i = 0; i < list.size(); ++i) {
            Section section = (Section)list.get(i);
            section.setDisplayCoordinate(n2);
            n2 += section.getSize();
        }
    }

    void layoutZones() {
        Iterator iterator = this.zones.values().iterator();
        while (iterator.hasNext()) {
            Zone zone = (Zone)iterator.next();
            this.setZoneAxisSize(zone, this.rows, AxisView.Y);
            this.setZoneAxisSize(zone, this.columns, AxisView.X);
        }
    }

    void setZoneAxisSize(Zone zone, List list, AxisView axisView) {
        Section section = (Section)list.get(axisView.getValue(zone.getRoot()));
        axisView.setValue(zone.getDisplayRoot(), section.getDisplayCoordinate());
        Section section2 = (Section)list.get(axisView.getValue(zone.getSecondRoot()));
        axisView.setValue(zone.getDisplaySecondRoot(), section2.getDisplayCoordinate() + section2.getSize() - 1);
    }

    void layoutComponents(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Zone zone = (Zone)this.bindings.get(componentArray[i]);
            if (zone == null) {
                throw new RuntimeException("Component " + componentArray[i] + " is not bound to a zone in this layout.");
            }
            if (!zone.hasVisibleComponent()) continue;
            Component component = zone.getComponent();
            int n = zone.getDisplayWidth() - zone.getInsets().left - zone.getInsets().right;
            int n2 = zone.getDisplayHeight() - zone.getInsets().top - zone.getInsets().bottom;
            int n3 = 0;
            int n4 = 0;
            n3 = n < component.getPreferredSize().width ? n : (zone.getHorizontalAlignment() == 5 ? n : component.getPreferredSize().width);
            n4 = n2 < component.getPreferredSize().height ? n2 : (zone.getVerticalAlignment() == 5 ? n2 : component.getPreferredSize().height);
            Rectangle rectangle = new Rectangle(zone.getDisplayRoot().x + zone.getInsets().left, zone.getDisplayRoot().y + zone.getInsets().top, n, n2);
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, n3, n4);
            this.alignComponentWithinZone(rectangle, rectangle2, zone.getHorizontalAlignment(), zone.getVerticalAlignment());
            component.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    void alignComponentWithinZone(Rectangle rectangle, Rectangle rectangle2, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 0: {
                n4 = (rectangle.width - rectangle2.width) / 2;
                rectangle2.x = rectangle.x + n4;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                n4 = rectangle.width - rectangle2.width;
                rectangle2.x = rectangle.x + n4;
            }
        }
        switch (n2) {
            case 0: {
                n3 = (rectangle.height - rectangle2.height) / 2;
                rectangle2.y = rectangle.y + n3;
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                n3 = rectangle.height - rectangle2.height;
                rectangle2.y = rectangle.y + n3;
            }
        }
    }

    void allocateAdditionalSpace(List list, int n, SizeView sizeView, boolean bl) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Section section = (Section)list.get(i);
            dArray[i] = section.getTake();
        }
        if (bl && MathRoutines.sum(dArray) == 0.0) {
            Arrays.fill(dArray, 1.0);
        }
        int[] nArray = MathRoutines.getSpaceToTake(dArray, n);
        boolean bl2 = false;
        for (int i = 0; i < list.size(); ++i) {
            Section section = (Section)list.get(i);
            sizeView.setSize(section, sizeView.getSize(section) + nArray[i]);
        }
    }

    void revokeAdditionalSpace(List list, int n, SizeView sizeView, SizeView sizeView2) {
        double[] dArray = new double[list.size()];
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Section section = (Section)list.get(i);
            dArray[i] = section.getGive();
            nArray[i] = sizeView.getDifference(sizeView2, section);
        }
        int[] nArray2 = MathRoutines.getSpaceToGive(dArray, nArray, n);
        for (int i = 0; i < list.size(); ++i) {
            Section section = (Section)list.get(i);
            sizeView.setSize(section, sizeView.getSize(section) - nArray2[i]);
        }
    }

    static {
        HashMap<String, Preset> hashMap = new HashMap<String, Preset>();
        hashMap.put("0", Preset.createSpacer(0, 0));
        hashMap.put("1", Preset.createSpacer(3, 0));
        hashMap.put("2", Preset.createSpacer(6, 0));
        hashMap.put("3", Preset.createSpacer(12, 0));
        hashMap.put("4", Preset.createSpacer(18, 0));
        hashMap.put("5", Preset.createSpacer(0, 3));
        hashMap.put("6", Preset.createSpacer(0, 6));
        hashMap.put("7", Preset.createSpacer(0, 12));
        hashMap.put("8", Preset.createSpacer(0, 18));
        DEFAULT_PRESETS = hashMap;
    }
}

