/*
 * Decompiled with CFR 0.152.
 */
package com.atticlabs.zonelayout.swing;

import com.atticlabs.zonelayout.swing.Column;
import com.atticlabs.zonelayout.swing.Row;
import com.atticlabs.zonelayout.swing.Section;
import com.atticlabs.zonelayout.swing.Zone;
import com.atticlabs.zonelayout.swing.ZoneLayoutImpl;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Line2D;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class ZoneLayoutDebugPanel
extends JPanel {
    ZoneLayoutImpl layout;
    JPanel targetPanel;
    JLayeredPane layeredPane;
    ZoneLayoutDebugRenderPanel renderPanel;

    public ZoneLayoutDebugPanel(JPanel jPanel) {
        super(new BorderLayout());
        this.targetPanel = jPanel;
        this.layout = (ZoneLayoutImpl)this.targetPanel.getLayout();
        this.renderPanel = new ZoneLayoutDebugRenderPanel(this.layout);
        this.layeredPane = new JLayeredPane();
        this.layeredPane.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                this.setBounds();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                this.setBounds();
            }

            public void componentResized(ComponentEvent componentEvent) {
                this.setBounds();
            }

            public void componentShown(ComponentEvent componentEvent) {
                this.setBounds();
            }

            void setBounds() {
                ZoneLayoutDebugPanel.this.targetPanel.setBounds(ZoneLayoutDebugPanel.this.layeredPane.getBounds());
                ZoneLayoutDebugPanel.this.renderPanel.setBounds(ZoneLayoutDebugPanel.this.layeredPane.getBounds());
                ZoneLayoutDebugPanel.this.targetPanel.revalidate();
                ZoneLayoutDebugPanel.this.renderPanel.revalidate();
            }
        });
        super.add((Component)this.layeredPane, "Center");
        this.layeredPane.add((Component)this.targetPanel, new Integer(0));
        this.layeredPane.add((Component)this.renderPanel, new Integer(1));
    }

    public Dimension getPreferredSize() {
        return this.targetPanel.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.targetPanel.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        return this.targetPanel.getMaximumSize();
    }

    private class ZoneLayoutDebugRenderPanel
    extends JComponent {
        ZoneLayoutImpl layout;

        ZoneLayoutDebugRenderPanel(ZoneLayoutImpl zoneLayoutImpl) {
            this.setOpaque(false);
            this.layout = zoneLayoutImpl;
        }

        protected void paintComponent(Graphics graphics) {
            Line2D.Double double_;
            int n;
            Object object;
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f}, 0.0f));
            graphics2D.setColor(Color.red);
            Iterator<Object> iterator = this.layout.getZones().values().iterator();
            while (iterator.hasNext()) {
                object = (Zone)iterator.next();
                graphics2D.drawRect(((Zone)object).getDisplayRoot().x, ((Zone)object).getDisplayRoot().y, ((Zone)object).getDisplayWidth() - 1, ((Zone)object).getDisplayHeight() - 1);
            }
            graphics2D.setColor(Color.blue);
            iterator = this.layout.rows.iterator();
            while (iterator.hasNext()) {
                object = (Row)iterator.next();
                n = ((Section)object).getDisplayCoordinate();
                double_ = new Line2D.Double(0.0, n, this.getParent().getWidth(), n);
                graphics2D.draw(double_);
            }
            iterator = this.layout.columns.iterator();
            while (iterator.hasNext()) {
                object = (Column)iterator.next();
                n = ((Section)object).getDisplayCoordinate();
                double_ = new Line2D.Double(n, 0.0, n, this.getParent().getHeight());
                graphics2D.draw(double_);
            }
            graphics2D.dispose();
        }
    }
}

