/*
 * Decompiled with CFR 0.152.
 */
package com.atticlabs.zonelayout.swing;

import com.atticlabs.zonelayout.swing.AxisView;
import com.atticlabs.zonelayout.swing.ComponentSizeCache;
import com.atticlabs.zonelayout.swing.Magnitude;
import com.atticlabs.zonelayout.swing.Preset;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;

public final class Zone {
    private static final Magnitude DEFAULT_GIVE = new Magnitude(1, 1);
    private static final Magnitude DEFAULT_TAKE = new Magnitude(0, 0);
    public static final Magnitude MAX_GIVE_OR_TAKE = new Magnitude(100, 100);
    public static final Insets DEFAULT_INSETS = new Insets(0, 0, 0, 0);
    public static final int ALIGN_MIDDLE = 0;
    public static final int ALIGN_BOTTOM = 1;
    public static final int ALIGN_TOP = 2;
    public static final int ALIGN_LEFT = 3;
    public static final int ALIGN_RIGHT = 4;
    public static final int ALIGN_FILL = 5;
    Point root;
    Point secondRoot;
    int horizontalAlignment;
    int verticalAlignment;
    Insets insets = DEFAULT_INSETS;
    String id;
    Magnitude give = DEFAULT_GIVE;
    Magnitude take = DEFAULT_TAKE;
    Component component;
    ComponentSizeCache componentSizeCache = new ComponentSizeCache();
    Point displayRoot = new Point();
    Point displaySecondRoot = new Point();
    Preset preset;

    Zone(String string) {
        this.id = string;
    }

    Zone(Zone zone) {
        this.id = zone.id;
        this.root = zone.root == null ? null : new Point(zone.root);
        this.secondRoot = zone.secondRoot == null ? null : new Point(zone.secondRoot);
        this.horizontalAlignment = zone.horizontalAlignment;
        this.verticalAlignment = zone.verticalAlignment;
        this.insets = (Insets)zone.insets.clone();
        this.give = new Magnitude(zone.give);
        this.take = new Magnitude(zone.take);
        this.displayRoot = new Point(zone.displayRoot);
        this.displaySecondRoot = new Point(zone.displaySecondRoot);
        if (zone.preset != null) {
            zone.preset.setUpZone(this);
        }
    }

    public void setTake(int n, int n2) {
        if (n > Zone.MAX_GIVE_OR_TAKE.horizontal || n2 > Zone.MAX_GIVE_OR_TAKE.vertical) {
            throw new RuntimeException("Maximum 'take' in either direction is 100.");
        }
        this.take = new Magnitude(n, n2);
    }

    public void setTake(Magnitude magnitude) {
        if (magnitude.horizontal > Zone.MAX_GIVE_OR_TAKE.horizontal || magnitude.vertical > Zone.MAX_GIVE_OR_TAKE.vertical) {
            throw new RuntimeException("Maximum 'take' in either direction is 100.");
        }
        this.take = magnitude;
    }

    public Magnitude getTake() {
        return this.take;
    }

    public void setGive(int n, int n2) {
        if (n > Zone.MAX_GIVE_OR_TAKE.horizontal || n2 > Zone.MAX_GIVE_OR_TAKE.vertical) {
            throw new RuntimeException("Maximum 'give' in either direction is 100.");
        }
        this.give = new Magnitude(n, n2);
    }

    public void setGive(Magnitude magnitude) {
        if (magnitude.horizontal > Zone.MAX_GIVE_OR_TAKE.horizontal || magnitude.vertical > Zone.MAX_GIVE_OR_TAKE.vertical) {
            throw new RuntimeException("Maximum 'give' in either direction is 100.");
        }
        this.give = magnitude;
    }

    boolean isGiveUserSet() {
        return this.give != DEFAULT_GIVE;
    }

    public Magnitude getGive() {
        return this.give;
    }

    public Component getComponent() {
        return this.component;
    }

    void setComponent(Component component) {
        this.component = component;
        this.componentSizeCache.setComponent(component);
    }

    ComponentSizeCache getComponentSizeCache() {
        return this.componentSizeCache;
    }

    void clearCache() {
        this.componentSizeCache.clearCache();
    }

    boolean hasVisibleComponent() {
        return this.component != null && this.component.isVisible();
    }

    Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Point getDisplayRoot() {
        return this.displayRoot;
    }

    void setDisplayRoot(Point point) {
        this.displayRoot = point;
    }

    boolean intersectsAxisLine(AxisView axisView, Point point) {
        return axisView.getValue(this.root) <= axisView.getValue(point) && axisView.getValue(this.secondRoot) >= axisView.getValue(point);
    }

    public Point getDisplaySecondRoot() {
        return this.displaySecondRoot;
    }

    void setDisplaySecondRoot(Point point) {
        this.displaySecondRoot = point;
    }

    public int getDisplayWidth() {
        return this.getDisplaySecondRoot().x - this.getDisplayRoot().x + 1;
    }

    public int getDisplayHeight() {
        return this.getDisplaySecondRoot().y - this.getDisplayRoot().y + 1;
    }

    public Dimension getDisplaySize() {
        return new Dimension(this.getDisplayWidth(), this.getDisplayHeight());
    }

    public int getX() {
        return this.getRoot().x;
    }

    public int getY() {
        return this.getRoot().y;
    }

    public int getWidth() {
        return this.secondRoot.x - this.root.x + 1;
    }

    public int getHeight() {
        return this.secondRoot.y - this.root.y + 1;
    }

    public Point getRoot() {
        return this.root;
    }

    public Point getSecondRoot() {
        return this.secondRoot;
    }

    public void setRoot(int n, int n2) {
        this.root = new Point(n, n2);
        if (!this.isSecondRootSet()) {
            this.setSecondRoot(n, n2);
        }
    }

    public boolean isRootSet() {
        return this.root != null;
    }

    public void setSecondRoot(int n, int n2) {
        if (this.isSecondRootSet() && !this.secondRoot.equals(this.root)) {
            throw new RuntimeException("The second root on zone '" + this.id + "' has already been set.");
        }
        this.secondRoot = new Point(n, n2);
    }

    public boolean isSecondRootSet() {
        return this.secondRoot != null;
    }

    public boolean contains(int n, int n2) {
        return n >= this.root.x && n <= this.secondRoot.x && n2 >= this.root.y && n2 <= this.secondRoot.y;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String string) {
        this.id = string;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public String toString() {
        return "Zone " + this.getId();
    }

    public boolean isPresetZone() {
        return this.preset != null;
    }

    public boolean intersects(Zone zone) {
        return this.contains(zone.getRoot().x, zone.getRoot().y) || this.contains(zone.getSecondRoot().x, zone.getSecondRoot().y);
    }
}

