/*
 * Decompiled with CFR 0.152.
 */
package com.atticlabs.zonelayout.swing;

import com.atticlabs.zonelayout.swing.AxisView;
import com.atticlabs.zonelayout.swing.Zone;
import com.atticlabs.zonelayout.swing.ZoneContext;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class Template {
    AxisView view = AxisView.Y;
    String name;
    Point insertionPoint = new Point();
    Point endPoint = new Point();
    Set zones = new HashSet();
    int count;
    ZoneContext lastContext;

    Template(String string, int n) {
        this.name = string;
        this.view.setValue(this.insertionPoint, n);
        this.view.setValue(this.endPoint, n);
    }

    void incrementEndPoint() {
        this.view.adjust(this.endPoint, 1);
    }

    String getName() {
        return this.name;
    }

    Point getInsertionPoint() {
        return this.insertionPoint;
    }

    Point getEndPoint() {
        return this.endPoint;
    }

    AxisView getView() {
        return this.view;
    }

    void addZone(Zone zone) {
        this.view.adjust(zone.getRoot(), -1 * this.view.getValue(this.insertionPoint));
        this.view.adjust(zone.getSecondRoot(), -1 * this.view.getValue(this.insertionPoint));
        this.zones.add(zone);
    }

    Set getZones() {
        return this.zones;
    }

    ZoneContext getNewZoneContext() {
        ZoneContext zoneContext = new ZoneContext();
        Iterator iterator = this.zones.iterator();
        while (iterator.hasNext()) {
            Zone zone = (Zone)iterator.next();
            Zone zone2 = new Zone(zone);
            this.view.adjust(zone2.getRoot(), this.view.getValue(this.insertionPoint));
            this.view.adjust(zone2.getSecondRoot(), this.view.getValue(this.insertionPoint));
            zoneContext.addZone(zone2);
        }
        return zoneContext;
    }

    ZoneContext getLastContext() {
        return this.lastContext;
    }

    void setLastContext(ZoneContext zoneContext) {
        this.lastContext = zoneContext;
    }

    void setLastContextZoneIds() {
        Zone zone;
        int n;
        ArrayList arrayList = new ArrayList(this.lastContext.getZones().values());
        for (n = 0; n < arrayList.size(); ++n) {
            zone = (Zone)arrayList.get(n);
            zone.setId(zone.getId() + "-" + this.count);
        }
        this.lastContext.getZones().clear();
        for (n = 0; n < arrayList.size(); ++n) {
            zone = (Zone)arrayList.get(n);
            this.lastContext.addZone(zone);
        }
        ++this.count;
    }
}

