/*
 * Decompiled with CFR 0.152.
 */
package com.atticlabs.zonelayout.swing;

import com.atticlabs.zonelayout.swing.AxisView;
import com.atticlabs.zonelayout.swing.Zone;
import com.atticlabs.zonelayout.swing.ZoneContext;
import com.atticlabs.zonelayout.swing.ZoneLayoutImpl;
import java.awt.Point;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

abstract class Section {
    ZoneLayoutImpl layout;
    Point root = new Point();
    int preferredSize;
    int minimumSize;
    int size;
    double take;
    double give;
    Point displayRoot = new Point();

    Section(ZoneLayoutImpl zoneLayoutImpl, int n) {
        this.layout = zoneLayoutImpl;
        this.setCoordinate(n);
    }

    Section(Section section, ZoneContext zoneContext) {
        this.layout = section.layout;
        this.root = new Point(section.root);
        this.preferredSize = section.preferredSize;
        this.minimumSize = section.minimumSize;
        this.size = section.size;
        this.take = section.take;
        this.give = section.give;
        this.displayRoot = new Point(section.displayRoot);
    }

    Point getRoot() {
        return this.root;
    }

    Set getZones() {
        HashSet<Zone> hashSet = new HashSet<Zone>();
        Iterator iterator = this.layout.getZones().values().iterator();
        while (iterator.hasNext()) {
            Zone zone = (Zone)iterator.next();
            if (!zone.intersectsAxisLine(this.getView(), this.root)) continue;
            hashSet.add(zone);
        }
        return hashSet;
    }

    public double getTake() {
        return this.take;
    }

    public void setTake(double d) {
        this.take = d;
    }

    public double getGive() {
        return this.give;
    }

    public void setGive(double d) {
        this.give = d;
    }

    boolean intersectsWithZone(Zone zone) {
        return this.getView().contains(zone, this.getCoordinate());
    }

    void setCoordinate(int n) {
        this.getView().setValue(this.root, n);
    }

    int getCoordinate() {
        return this.getView().getValue(this.root);
    }

    int getPreferredSize() {
        return this.preferredSize;
    }

    void setPreferredSize(int n) {
        this.preferredSize = n;
    }

    int getMinimumSize() {
        return this.minimumSize;
    }

    void setMinimumSize(int n) {
        this.minimumSize = n;
    }

    int getSize() {
        return this.size;
    }

    void setSize(int n) {
        this.size = n;
    }

    void setDisplayCoordinate(int n) {
        this.getView().setValue(this.displayRoot, n);
    }

    int getDisplayCoordinate() {
        return this.getView().getValue(this.displayRoot);
    }

    abstract AxisView getView();

    abstract Section duplicate(ZoneContext var1);
}

