/*
 * Decompiled with CFR 0.152.
 */
package com.atticlabs.zonelayout.swing;

import com.atticlabs.zonelayout.swing.Magnitude;
import com.atticlabs.zonelayout.swing.Zone;
import java.awt.Component;
import java.awt.Dimension;

public final class Preset {
    static final String SPECIAL_CHARACTERS = "~!*";
    static final Magnitude DEFAULT_TAKE = new Magnitude(0, 0);
    static final Dimension DIMENSION_ZERO = new Dimension(0, 0);
    static final Preset HORIZONTAL_EXPANDER = Preset.createExpander(1, 0);
    static final Preset VERTICAL_EXPANDER = Preset.createExpander(0, 1);
    static final Preset BOTH_EXPANDER = Preset.createExpander(1, 1);
    final Dimension min;
    final Dimension pref;
    final Magnitude take;

    private Preset(Dimension dimension, Dimension dimension2, Magnitude magnitude) {
        this.min = dimension;
        this.pref = dimension2;
        this.take = magnitude;
    }

    static Preset getSpecialPreset(char c) {
        switch (c) {
            case '~': {
                return HORIZONTAL_EXPANDER;
            }
            case '!': {
                return VERTICAL_EXPANDER;
            }
            case '*': {
                return BOTH_EXPANDER;
            }
        }
        throw new RuntimeException("Unknown special character '" + c + "'");
    }

    public static Preset createSpacer(int n, int n2) {
        return new Preset(new Dimension(n, n2), new Dimension(n, n2), DEFAULT_TAKE);
    }

    public static Preset createExpander(int n, int n2) {
        return new Preset(DIMENSION_ZERO, DIMENSION_ZERO, new Magnitude(n, n2));
    }

    Component createComponent() {
        return new Component(){

            public Dimension getPreferredSize() {
                return Preset.this.pref;
            }

            public Dimension getMinimumSize() {
                return Preset.this.min;
            }
        };
    }

    void setUpZone(Zone zone) {
        zone.preset = this;
        zone.setComponent(this.createComponent());
        zone.take = this.take;
    }
}

