/*
 * Decompiled with CFR 0.152.
 */
package com.atticlabs.zonelayout.swing;

import java.awt.Component;
import java.awt.Dimension;

public class ComponentSizeCache {
    public static final Dimension DEFAULT_MINIMUM = new Dimension(0, 0);
    public static final Dimension DEFAULT_PREFERRED = new Dimension(0, 0);
    public static final Dimension DEFAULT_MAXIMUM = new Dimension(0, 0);
    Dimension minimum = DEFAULT_MINIMUM;
    boolean minimumSet;
    Dimension preferred = DEFAULT_PREFERRED;
    boolean preferredSet;
    Dimension maximum = DEFAULT_MAXIMUM;
    boolean maximumSet;
    Component component;

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public Dimension getMinimumSize() {
        if (!this.minimumSet && this.component != null) {
            this.minimum = this.component.getMinimumSize();
            Dimension dimension = this.getPreferredSize();
            if (this.minimum.width > dimension.width || this.minimum.height > dimension.height) {
                this.minimum = new Dimension(Math.min(this.minimum.width, dimension.width), Math.min(this.minimum.height, dimension.height));
            }
            this.minimumSet = true;
        }
        return this.minimum;
    }

    public Dimension getPreferredSize() {
        if (!this.preferredSet && this.component != null) {
            this.preferred = this.component.getPreferredSize();
            this.preferredSet = true;
        }
        return this.preferred;
    }

    public Dimension getMaximumSize() {
        if (!this.maximumSet && this.component != null) {
            this.maximum = this.component.getMaximumSize();
            this.maximumSet = true;
        }
        return this.maximum;
    }

    public Dimension getSize() {
        return this.component != null ? this.component.getSize() : DEFAULT_MINIMUM;
    }

    public void clearCache() {
        this.minimum = null;
        this.preferred = null;
        this.maximum = null;
        this.minimumSet = false;
        this.preferredSet = false;
        this.maximumSet = false;
    }
}

