/*
 * Decompiled with CFR 0.152.
 */
package com.atticlabs.zonelayout.swing;

import com.atticlabs.zonelayout.swing.Magnitude;
import com.atticlabs.zonelayout.swing.XAxisView;
import com.atticlabs.zonelayout.swing.YAxisView;
import com.atticlabs.zonelayout.swing.Zone;
import com.atticlabs.zonelayout.swing.ZoneLayoutImpl;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.List;

abstract class AxisView {
    static final AxisView Y = new YAxisView();
    static final AxisView X = new XAxisView();

    AxisView() {
    }

    int getStart(Zone zone) {
        return this.getValue(zone.getRoot());
    }

    int getFinish(Zone zone) {
        return this.getValue(zone.getSecondRoot());
    }

    void adjust(Point point, int n) {
        this.setValue(point, this.getValue(point) + n);
    }

    boolean contains(Zone zone, int n) {
        return n >= this.getStart(zone) && n <= this.getFinish(zone);
    }

    abstract int getAdjustment(Insets var1);

    abstract int getValue(Point var1);

    abstract void setValue(Point var1, int var2);

    abstract int getSize(Dimension var1);

    abstract int getSize(Zone var1);

    abstract int getTake(Zone var1);

    abstract int getGive(Zone var1);

    abstract List getSections(ZoneLayoutImpl var1);

    abstract int getValue(Magnitude var1);
}

