/*
 * Decompiled with CFR 0.152.
 */
package lombok.intellij.processor.clazz;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.lombok.psi.LombokLightFieldBuilder;
import de.plushnikov.intellij.lombok.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.lombok.psi.LombokPsiElementFactory;
import de.plushnikov.intellij.lombok.util.PsiMethodUtil;
import de.plushnikov.intellij.lombok.util.PsiPrimitiveTypeFactory;
import griffon.plugins.wslite.WsliteAware;
import java.util.List;
import lombok.core.handlers.WsliteAwareConstants;
import lombok.core.util.MethodDescriptor;
import lombok.intellij.processor.clazz.AbstractGriffonLombokClassProcessor;
import org.jetbrains.annotations.NotNull;

public class WsliteAwareProcessor
extends AbstractGriffonLombokClassProcessor
implements WsliteAwareConstants {
    private static final String WSLITE_PROVIDER_FIELD_INITIALIZER = "griffon.plugins.wslite.DefaultWsliteProvider.getInstance()";

    public WsliteAwareProcessor() {
        super(WsliteAware.class, PsiMethod.class);
    }

    protected <Psi extends PsiElement> void processIntern(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<Psi> target) {
        PsiElementFactory psiElementFactory = this.psiElementFactory(psiClass);
        PsiManager manager = psiClass.getContainingFile().getManager();
        PsiType psiProviderType = psiElementFactory.createTypeFromText("griffon.plugins.wslite.WsliteProvider", (PsiElement)psiClass);
        LombokLightFieldBuilder providerField = LombokPsiElementFactory.getInstance().createLightField(manager, "this$wsliteProvider", psiProviderType).withContainingClass(psiClass).withModifier("private").withNavigationElement((PsiElement)psiAnnotation);
        PsiExpression initializer = psiElementFactory.createExpressionFromText(String.format(WSLITE_PROVIDER_FIELD_INITIALIZER, new Object[0]), (PsiElement)psiClass);
        providerField.setInitializer(initializer);
        LombokLightMethodBuilder method = LombokPsiElementFactory.getInstance().createLightMethod(psiClass.getManager(), "getWsliteProvider").withMethodReturnType(psiProviderType).withContainingClass(psiClass).withModifier("public").withNavigationElement((PsiElement)psiAnnotation);
        target.add(method);
        method = LombokPsiElementFactory.getInstance().createLightMethod(psiClass.getManager(), "setWsliteProvider").withMethodReturnType(PsiPrimitiveTypeFactory.getInstance().getVoidType()).withContainingClass(psiClass).withParameter("provider", psiProviderType).withModifier("public").withNavigationElement((PsiElement)psiAnnotation);
        target.add(method);
        for (MethodDescriptor methodDesc : METHODS) {
            target.add(PsiMethodUtil.createMethod((PsiClass)psiClass, (String)methodDesc.signature, (PsiElement)psiAnnotation));
        }
    }
}

