/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import griffon.plugins.wslite.WsliteAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.WsliteAwareHandler;
import lombok.core.util.ErrorMessages;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseUtil;
import lombok.eclipse.handlers.ast.EclipseType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class HandleWsliteAware
extends EclipseAnnotationHandler<WsliteAware> {
    private final EclipseWsliteAwareHandler handler = new EclipseWsliteAwareHandler();

    public void handle(AnnotationValues<WsliteAware> annotation, Annotation source, EclipseNode annotationNode) {
        EclipseType type = EclipseType.typeOf((EclipseNode)annotationNode, (ASTNode)source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(WsliteAware.class));
            return;
        }
        EclipseUtil.addInterface((TypeDeclaration)type.get(), (String)"griffon.plugins.wslite.WsliteContributionHandler", (Annotation)source);
        this.handler.addWsliteProviderField(type);
        this.handler.addWsliteProviderAccessors(type);
        this.handler.addWsliteContributionMethods(type);
        type.editor().rebuild();
    }

    private static class EclipseWsliteAwareHandler
    extends WsliteAwareHandler<EclipseType> {
        private EclipseWsliteAwareHandler() {
        }
    }
}

