/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.ast;

import griffon.plugins.wsclient.DefaultWsclientProvider;
import griffon.plugins.wsclient.WsclientAware;
import griffon.plugins.wsclient.WsclientContributionHandler;
import griffon.plugins.wsclient.WsclientProvider;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.core.handlers.WsclientAwareConstants;
import org.codehaus.griffon.ast.AbstractASTTransformation;
import org.codehaus.griffon.ast.GriffonASTUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class WsclientAwareASTTransformation
extends AbstractASTTransformation
implements WsclientAwareConstants {
    private static final Logger LOG = LoggerFactory.getLogger(WsclientAwareASTTransformation.class);
    private static final ClassNode WSCLIENT_CONTRIBUTION_HANDLER_CNODE = WsclientAwareASTTransformation.makeClassSafe(WsclientContributionHandler.class);
    private static final ClassNode WSCLIENT_AWARE_CNODE = WsclientAwareASTTransformation.makeClassSafe(WsclientAware.class);
    private static final ClassNode WSCLIENT_PROVIDER_CNODE = WsclientAwareASTTransformation.makeClassSafe(WsclientProvider.class);
    private static final ClassNode DEFAULT_WSCLIENT_PROVIDER_CNODE = WsclientAwareASTTransformation.makeClassSafe(DefaultWsclientProvider.class);
    private static final String[] DELEGATING_METHODS = new String[]{"withWs"};

    public static boolean hasWsclientAwareAnnotation(AnnotatedNode node) {
        for (AnnotationNode annotation : node.getAnnotations()) {
            if (!WSCLIENT_AWARE_CNODE.equals((Object)annotation.getClassNode())) continue;
            return true;
        }
        return false;
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.checkNodesForAnnotationAndType(nodes[0], nodes[1]);
        WsclientAwareASTTransformation.addWsclientContributionIfNeeded(source, (ClassNode)nodes[1]);
    }

    public static void addWsclientContributionIfNeeded(SourceUnit source, ClassNode classNode) {
        if (WsclientAwareASTTransformation.needsWsclientContribution(classNode, source)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Injecting " + WsclientContributionHandler.class.getName() + " into " + classNode.getName());
            }
            WsclientAwareASTTransformation.apply(classNode);
        }
    }

    protected static boolean needsWsclientContribution(ClassNode declaringClass, SourceUnit sourceUnit) {
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        for (ClassNode consideredClass = declaringClass; consideredClass != null; consideredClass = consideredClass.getSuperClass()) {
            for (MethodNode method : consideredClass.getMethods()) {
                found1 = method.getName().equals("withWs") && method.getParameters().length == 2;
                found2 = method.getName().equals("setWsclientProvider") && method.getParameters().length == 1;
                boolean bl = found3 = method.getName().equals("getWsclientProvider") && method.getParameters().length == 0;
                if (!found1 || !found2 || !found3) continue;
                return false;
            }
        }
        if (found1 || found2 || found3) {
            sourceUnit.getErrorCollector().addErrorAndContinue((Message)new SimpleMessage("@WsclientAware cannot be processed on " + declaringClass.getName() + " because some but not all of methods from " + WsclientContributionHandler.class.getName() + " were declared in the current class or super classes.", (ProcessingUnit)sourceUnit));
            return false;
        }
        return true;
    }

    public static void apply(ClassNode declaringClass) {
        GriffonASTUtils.injectInterface((ClassNode)declaringClass, (ClassNode)WSCLIENT_CONTRIBUTION_HANDLER_CNODE);
        FieldNode providerField = declaringClass.addField("this$wsclientProvider", 4098, WSCLIENT_PROVIDER_CNODE, WsclientAwareASTTransformation.defaultWsclientProviderInstance());
        GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)new MethodNode("getWsclientProvider", 1, WSCLIENT_PROVIDER_CNODE, Parameter.EMPTY_ARRAY, GriffonASTUtils.NO_EXCEPTIONS, GriffonASTUtils.returns((Expression)GriffonASTUtils.field((FieldNode)providerField))));
        GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)new MethodNode("setWsclientProvider", 1, ClassHelper.VOID_TYPE, GriffonASTUtils.params((Parameter[])new Parameter[]{GriffonASTUtils.param((ClassNode)WSCLIENT_PROVIDER_CNODE, (String)"provider")}), GriffonASTUtils.NO_EXCEPTIONS, (Statement)GriffonASTUtils.block((Statement[])new Statement[]{GriffonASTUtils.ifs_no_return((Expression)GriffonASTUtils.cmp((Expression)GriffonASTUtils.var((String)"provider"), (Expression)ConstantExpression.NULL), (Statement)GriffonASTUtils.assigns((Expression)GriffonASTUtils.field((FieldNode)providerField), (Expression)WsclientAwareASTTransformation.defaultWsclientProviderInstance()), (Statement)GriffonASTUtils.assigns((Expression)GriffonASTUtils.field((FieldNode)providerField), (Expression)GriffonASTUtils.var((String)"provider")))})));
        for (MethodNode method : WSCLIENT_CONTRIBUTION_HANDLER_CNODE.getMethods()) {
            if (Arrays.binarySearch(DELEGATING_METHODS, method.getName()) < 0) continue;
            ArrayList<VariableExpression> variables = new ArrayList<VariableExpression>();
            Parameter[] parameters = new Parameter[method.getParameters().length];
            for (int i = 0; i < method.getParameters().length; ++i) {
                Parameter p = method.getParameters()[i];
                parameters[i] = new Parameter(WsclientAwareASTTransformation.makeClassSafe((ClassNode)p.getType()), p.getName());
                parameters[i].getType().setGenericsTypes(p.getType().getGenericsTypes());
                variables.add(GriffonASTUtils.var((String)p.getName()));
            }
            ClassNode returnType = WsclientAwareASTTransformation.makeClassSafe((ClassNode)method.getReturnType());
            returnType.setGenericsTypes(method.getReturnType().getGenericsTypes());
            returnType.setGenericsPlaceHolder(method.getReturnType().isGenericsPlaceHolder());
            MethodNode newMethod = new MethodNode(method.getName(), 1, returnType, parameters, GriffonASTUtils.NO_EXCEPTIONS, GriffonASTUtils.returns((Expression)GriffonASTUtils.call((Expression)GriffonASTUtils.field((FieldNode)providerField), (String)method.getName(), (ArgumentListExpression)GriffonASTUtils.args(variables))));
            newMethod.setGenericsTypes(method.getGenericsTypes());
            GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)newMethod);
        }
    }

    private static Expression defaultWsclientProviderInstance() {
        return GriffonASTUtils.call((ClassNode)DEFAULT_WSCLIENT_PROVIDER_CNODE, (String)"getInstance", (ArgumentListExpression)GriffonASTUtils.NO_ARGS);
    }

    static {
        Arrays.sort(DELEGATING_METHODS);
    }
}

