/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.util;

public final class BufferRecycler {
    public static final int DEFAULT_WRITE_CONCAT_BUFFER_LEN = 2000;
    protected final byte[][] mByteBuffers = new byte[ByteBufferType.values().length][];
    protected final char[][] mCharBuffers = new char[CharBufferType.values().length][];

    public byte[] allocByteBuffer(ByteBufferType byteBufferType) {
        int n = byteBufferType.ordinal();
        byte[] byArray = this.mByteBuffers[n];
        if (byArray == null) {
            byArray = this.balloc(byteBufferType.size);
        } else {
            this.mByteBuffers[n] = null;
        }
        return byArray;
    }

    public void releaseByteBuffer(ByteBufferType byteBufferType, byte[] byArray) {
        this.mByteBuffers[byteBufferType.ordinal()] = byArray;
    }

    public char[] allocCharBuffer(CharBufferType charBufferType) {
        return this.allocCharBuffer(charBufferType, 0);
    }

    public char[] allocCharBuffer(CharBufferType charBufferType, int n) {
        int n2;
        char[] cArray;
        if (charBufferType.size > n) {
            n = charBufferType.size;
        }
        if ((cArray = this.mCharBuffers[n2 = charBufferType.ordinal()]) == null || cArray.length < n) {
            cArray = this.calloc(n);
        } else {
            this.mCharBuffers[n2] = null;
        }
        return cArray;
    }

    public void releaseCharBuffer(CharBufferType charBufferType, char[] cArray) {
        this.mCharBuffers[charBufferType.ordinal()] = cArray;
    }

    private byte[] balloc(int n) {
        return new byte[n];
    }

    private char[] calloc(int n) {
        return new char[n];
    }

    public static enum CharBufferType {
        TOKEN_BUFFER(2000),
        CONCAT_BUFFER(2000),
        TEXT_BUFFER(200),
        NAME_COPY_BUFFER(200);

        private final int size;

        private CharBufferType(int n2) {
            this.size = n2;
        }
    }

    public static enum ByteBufferType {
        READ_IO_BUFFER(4000),
        WRITE_ENCODING_BUFFER(4000),
        WRITE_CONCAT_BUFFER(2000);

        private final int size;

        private ByteBufferType(int n2) {
            this.size = n2;
        }
    }
}

