/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.orbit;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;

public class FlatOrbitView
extends BasicOrbitView {
    private static final double MINIMUM_FAR_DISTANCE = 100.0;

    @Override
    protected double computeHorizonDistance() {
        Vec4 vec4 = this.getEyePoint();
        return this.computeHorizonDistance(vec4);
    }

    @Override
    public double computeFarClipDistance() {
        double d = this.computeHorizonDistance(this.getCurrentEyePoint());
        return d < 100.0 ? 100.0 : d;
    }

    protected double computeHorizonDistance(Vec4 vec4) {
        double d = 0.0;
        if (this.globe != null && vec4 != null) {
            double d2 = 0.0;
            Vec4 vec42 = this.globe.computePointFromPosition(Angle.POS90, Angle.NEG180, 0.0);
            d2 = Math.max(d2, vec4.distanceTo3(vec42));
            vec42 = this.globe.computePointFromPosition(Angle.POS90, Angle.POS180, 0.0);
            d2 = Math.max(d2, vec4.distanceTo3(vec42));
            vec42 = this.globe.computePointFromPosition(Angle.NEG90, Angle.NEG180, 0.0);
            d2 = Math.max(d2, vec4.distanceTo3(vec42));
            vec42 = this.globe.computePointFromPosition(Angle.NEG90, Angle.POS180, 0.0);
            d2 = Math.max(d2, vec4.distanceTo3(vec42));
            vec42 = this.globe.computePointFromPosition(Angle.ZERO, Angle.POS180, 0.0);
            d2 = Math.max(d2, vec4.distanceTo3(vec42));
            vec42 = this.globe.computePointFromPosition(Angle.ZERO, Angle.NEG180, 0.0);
            d = d2 = Math.max(d2, vec4.distanceTo3(vec42));
        }
        return d;
    }
}

