/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.webview;

import com.sun.opengl.util.texture.Texture;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.webview.AbstractWebView;
import gov.nasa.worldwind.util.webview.WebResourceResolver;
import gov.nasa.worldwind.util.webview.WebViewTexture;
import gov.nasa.worldwind.util.webview.WindowsWebViewJNI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class WindowsWebView
extends AbstractWebView {
    protected static final Object webViewUILock = new Object();
    protected static Thread webViewUI;
    protected static long webViewMessageLoop;
    protected long webViewWindowPtr;
    protected long observerPtr;
    protected static AtomicInteger instances;
    protected boolean disposed = false;
    protected Color backgroundColor;

    public WindowsWebView(Dimension dimension) {
        if (dimension == null) {
            String string = Logging.getMessage("nullValue.SizeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!Configuration.isWindowsOS()) {
            String string = Logging.getMessage("NativeLib.UnsupportedOperatingSystem", "Windows WebView", System.getProperty("os.name"));
            Logging.logger().severe(string);
            throw new UnsupportedOperationException(string);
        }
        this.frameSize = dimension;
        try {
            instances.incrementAndGet();
            this.ensureMessageLoopRunning();
            this.webViewWindowPtr = WindowsWebViewJNI.newWebViewWindow(webViewMessageLoop);
            if (this.webViewWindowPtr == 0L) {
                String string = Logging.getMessage("WebView.NativeExceptionInitializingWebView");
                Logging.logger().severe(string);
                throw new WWRuntimeException(string);
            }
            WindowsWebViewJNI.setFrameSize(this.webViewWindowPtr, this.frameSize.width, this.frameSize.height);
            this.observerPtr = WindowsWebViewJNI.newNotificationAdapter(this);
            WindowsWebViewJNI.addWindowUpdateObserver(this.webViewWindowPtr, this.observerPtr);
        }
        catch (RuntimeException runtimeException) {
            instances.decrementAndGet();
            this.handleWebViewCreationError();
            throw runtimeException;
        }
        catch (Error error) {
            instances.decrementAndGet();
            this.handleWebViewCreationError();
            throw error;
        }
    }

    protected void handleWebViewCreationError() {
        try {
            this.stopMessageLoopIfNoInstances();
        }
        catch (Throwable throwable) {
            String string = Logging.getMessage("WebView.ExceptionStoppingWebViewThread", throwable);
            Logging.logger().severe(string);
        }
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        try {
            if (this.webViewWindowPtr != 0L && this.observerPtr != 0L) {
                WindowsWebViewJNI.removeWindowUpdateObserver(this.webViewWindowPtr, this.observerPtr);
            }
            if (this.webViewWindowPtr != 0L) {
                WindowsWebViewJNI.releaseWebView(this.webViewWindowPtr);
                instances.decrementAndGet();
            }
            if (this.observerPtr != 0L) {
                WindowsWebViewJNI.releaseComObject(this.observerPtr);
            }
            this.webViewWindowPtr = 0L;
            this.observerPtr = 0L;
            this.stopMessageLoopIfNoInstances();
            this.disposed = true;
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("generic.ExceptionAttemptingToDisposeRenderable"), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureMessageLoopRunning() {
        Object object = webViewUILock;
        synchronized (object) {
            if (webViewUI == null || !webViewUI.isAlive()) {
                webViewMessageLoop = 0L;
                webViewUI = new Thread("WebView UI"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            webViewMessageLoop = WindowsWebViewJNI.newMessageLoop();
                        }
                        catch (Throwable throwable) {
                            webViewMessageLoop = -1L;
                        }
                        finally {
                            Object object = webViewUILock;
                            synchronized (object) {
                                webViewUILock.notify();
                            }
                        }
                        WindowsWebViewJNI.runMessageLoop(webViewMessageLoop);
                    }
                };
                webViewUI.start();
                while (webViewMessageLoop == 0L) {
                    try {
                        webViewUILock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopMessageLoopIfNoInstances() {
        Object object = webViewUILock;
        synchronized (object) {
            if (instances.get() <= 0) {
                WindowsWebViewJNI.releaseMessageLoop(webViewMessageLoop);
                webViewMessageLoop = 0L;
                webViewUI = null;
            }
        }
    }

    @Override
    public void setHTMLString(String string) {
        if (this.webViewWindowPtr != 0L) {
            WindowsWebViewJNI.setHTMLString(this.webViewWindowPtr, string, null);
        }
    }

    @Override
    public void setHTMLString(String string, URL uRL) {
        if (this.webViewWindowPtr != 0L) {
            WindowsWebViewJNI.setHTMLString(this.webViewWindowPtr, string, uRL != null ? uRL.toString() : null);
        }
    }

    @Override
    public void setHTMLString(String string, WebResourceResolver webResourceResolver) {
        if (this.webViewWindowPtr != 0L) {
            WindowsWebViewJNI.setHTMLStringWithResourceResolver(this.webViewWindowPtr, string, webResourceResolver);
        }
    }

    @Override
    public Dimension getContentSize() {
        return WindowsWebViewJNI.getContentSize(this.webViewWindowPtr);
    }

    @Override
    public Dimension getMinContentSize() {
        if (this.webViewWindowPtr != 0L) {
            return WindowsWebViewJNI.getMinContentSize(this.webViewWindowPtr);
        }
        return null;
    }

    @Override
    public void setMinContentSize(Dimension dimension) {
        if (this.webViewWindowPtr != 0L) {
            WindowsWebViewJNI.setMinContentSize(this.webViewWindowPtr, dimension.width, dimension.height);
        }
    }

    @Override
    public URL getContentURL() {
        if (this.webViewWindowPtr != 0L) {
            return WWIO.makeURL(WindowsWebViewJNI.getContentURL(this.webViewWindowPtr));
        }
        return null;
    }

    @Override
    protected void doSetFrameSize(Dimension dimension) {
        if (this.webViewWindowPtr != 0L) {
            WindowsWebViewJNI.setFrameSize(this.webViewWindowPtr, dimension.width, dimension.height);
        }
    }

    @Override
    public void sendEvent(InputEvent inputEvent) {
        if (inputEvent != null) {
            if (inputEvent instanceof MouseEvent) {
                inputEvent = this.convertToWindows((MouseEvent)inputEvent);
            }
            if (this.webViewWindowPtr != 0L) {
                WindowsWebViewJNI.sendEvent(this.webViewWindowPtr, inputEvent);
            }
        }
    }

    @Override
    public void setActive(boolean bl) {
        super.setActive(bl);
        if (this.webViewWindowPtr != 0L) {
            WindowsWebViewJNI.setActive(this.webViewWindowPtr, bl);
        }
    }

    @Override
    public void goBack() {
        if (this.webViewWindowPtr != 0L) {
            WindowsWebViewJNI.goBack(this.webViewWindowPtr);
        }
    }

    @Override
    public void goForward() {
        if (this.webViewWindowPtr != 0L) {
            WindowsWebViewJNI.goForward(this.webViewWindowPtr);
        }
    }

    @Override
    public void setBackgroundColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!color.equals(this.getBackgroundColor())) {
            this.backgroundColor = color;
            int n = (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF;
            String string = String.format("#%06X", n);
            WindowsWebViewJNI.setBackgroundColor(this.webViewWindowPtr, string);
        }
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public Iterable<AVList> getLinks() {
        AVList[] aVListArray;
        if (this.webViewWindowPtr != 0L && (aVListArray = WindowsWebViewJNI.getLinks(this.webViewWindowPtr)) != null) {
            return Arrays.asList(aVListArray);
        }
        return Collections.emptyList();
    }

    protected MouseEvent convertToWindows(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        n2 = this.frameSize.height - n2;
        if (mouseEvent instanceof MouseWheelEvent) {
            return new MouseWheelEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n, n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), ((MouseWheelEvent)mouseEvent).getScrollType(), ((MouseWheelEvent)mouseEvent).getScrollAmount(), ((MouseWheelEvent)mouseEvent).getWheelRotation());
        }
        return new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n, n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    @Override
    protected WWTexture createTextureRepresentation(DrawContext drawContext) {
        WindowsWebViewTexture windowsWebViewTexture = new WindowsWebViewTexture(this.getFrameSize(), false);
        windowsWebViewTexture.setUseAnisotropy(false);
        return windowsWebViewTexture;
    }

    static {
        instances = new AtomicInteger();
    }

    protected class WindowsWebViewTexture
    extends WebViewTexture {
        protected long updateTime;

        public WindowsWebViewTexture(Dimension dimension, boolean bl) {
            super(dimension, bl, true);
            this.updateTime = -1L;
        }

        @Override
        protected void updateIfNeeded(DrawContext drawContext) {
            long l = WindowsWebView.this.webViewWindowPtr;
            if (l == 0L) {
                return;
            }
            Texture texture = this.getTextureFromCache(drawContext);
            if (texture == null) {
                return;
            }
            long l2 = WindowsWebViewJNI.getUpdateTime(l);
            if (l2 != this.updateTime) {
                WindowsWebViewJNI.loadDisplayInGLTexture(l, texture.getTarget());
                this.updateTime = l2;
            }
        }
    }
}

