/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.tree;

import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLUtil;
import java.awt.Color;
import java.awt.Rectangle;
import javax.media.opengl.GL;

public class TreeUtil {
    public static void drawPickableRect(DrawContext drawContext, PickSupport pickSupport, Object object, Rectangle rectangle) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawingContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        Color color = drawContext.getUniquePickColor();
        int n = color.getRGB();
        pickSupport.addPickableObject(n, object);
        gL.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        TreeUtil.drawRect(gL, rectangle);
    }

    public static void drawRect(GL gL, Rectangle rectangle) {
        if (gL == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.BoundingBoxIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gL.glRecti(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public static void drawRectWithGradient(GL gL, Rectangle rectangle, Color color, Color color2, double d, String string) {
        if (gL == null) {
            String string2 = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (rectangle == null) {
            String string3 = Logging.getMessage("nullValue.BoundingBoxIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        gL.glBegin(7);
        if ("gov.nasa.worldwind.avkey.Horizontal".equals(string)) {
            OGLUtil.applyColor(gL, color, d, false);
            gL.glVertex2d(rectangle.getMinX(), rectangle.getMaxY());
            gL.glVertex2d(rectangle.getMinX(), rectangle.getMinY());
            OGLUtil.applyColor(gL, color2, d, false);
            gL.glVertex2d(rectangle.getMaxX(), rectangle.getMinY());
            gL.glVertex2d(rectangle.getMaxX(), rectangle.getMaxY());
        } else {
            OGLUtil.applyColor(gL, color, d, false);
            gL.glVertex2d(rectangle.getMaxX(), rectangle.getMaxY());
            gL.glVertex2d(rectangle.getMinX(), rectangle.getMaxY());
            OGLUtil.applyColor(gL, color2, d, false);
            gL.glVertex2d(rectangle.getMinX(), rectangle.getMinY());
            gL.glVertex2d(rectangle.getMaxX(), rectangle.getMinY());
        }
        gL.glEnd();
    }
}

