/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.CompoundVecBuffer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.VecBuffer;
import javax.media.opengl.GL;

public class VecBufferSequence
extends CompoundVecBuffer {
    protected int vecCount;
    protected VecBuffer buffer;

    public VecBufferSequence(VecBuffer vecBuffer, int n) {
        super(n);
        if (vecBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.buffer = vecBuffer;
    }

    public VecBufferSequence(VecBuffer vecBuffer) {
        this(vecBuffer, 16);
    }

    protected VecBufferSequence(VecBufferSequence vecBufferSequence, int n, int n2) {
        super(vecBufferSequence, n, n2);
        this.vecCount = vecBufferSequence.vecCount;
        this.buffer = vecBufferSequence.buffer;
    }

    protected VecBufferSequence(VecBufferSequence vecBufferSequence, int[] nArray, int n, int n2) {
        super(vecBufferSequence, nArray, n, n2);
        this.vecCount = vecBufferSequence.vecCount;
        this.buffer = vecBufferSequence.buffer;
    }

    public static VecBufferSequence emptyVecBufferSequence(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new VecBufferSequence(VecBuffer.emptyVecBuffer(n));
    }

    @Override
    public int subBufferSize(int n) {
        if (n < 0 || n >= this.count) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.lengths.get(n);
    }

    @Override
    public void clear() {
        super.clear();
        this.vecCount = 0;
    }

    @Override
    public int getCoordsPerVec() {
        return this.buffer.getCoordsPerVec();
    }

    public VecBuffer getVecBuffer() {
        return this.buffer;
    }

    public int append(VecBuffer vecBuffer) {
        if (vecBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = vecBuffer.getSize() + this.vecCount;
        if (n > this.buffer.getSize()) {
            this.expandBufferCapacity(n);
        }
        int n2 = this.vecCount;
        this.buffer.putSubBuffer(n2, vecBuffer);
        this.vecCount += vecBuffer.getSize();
        return this.addSubBuffer(n2, vecBuffer.getSize());
    }

    @Override
    protected VecBuffer createSubBuffer(int n, int n2) {
        return this.buffer.getSubBuffer(n, n2);
    }

    @Override
    protected CompoundVecBuffer createSlice(int[] nArray, int n, int n2) {
        return new VecBufferSequence(this, nArray, n, n2);
    }

    @Override
    protected CompoundVecBuffer createSlice(int n, int n2) {
        return new VecBufferSequence(this, n, n2);
    }

    protected void expandBufferCapacity(int n) {
        int n2 = 2 * this.buffer.getSize();
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        } else if (n2 < n) {
            n2 = n;
        }
        this.buffer = this.buffer.copyOf(n2);
    }

    public void bindAsNormalBuffer(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.buffer.bindAsNormalBuffer(drawContext);
    }

    public void bindAsVertexBuffer(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.buffer.bindAsVertexBuffer(drawContext);
    }

    public void bindAsTexCoordBuffer(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.buffer.bindAsTexCoordBuffer(drawContext);
    }

    public void drawArrays(DrawContext drawContext, int n) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.buffer.drawArrays(drawContext, n);
    }

    public void multiDrawArrays(DrawContext drawContext, int n) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        if (this.haveMultiDrawArrays(drawContext)) {
            gL.glMultiDrawArrays(n, this.offsets, this.lengths, this.count);
        } else {
            for (int i = 0; i < this.count; ++i) {
                gL.glDrawArrays(n, this.offsets.get(i), this.lengths.get(i));
            }
        }
    }

    protected boolean haveMultiDrawArrays(DrawContext drawContext) {
        return drawContext.getGL().isFunctionAvailable("glMultiDrawArrays");
    }
}

