/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.sun.opengl.util.texture.TextureCoords;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.TextureAtlas;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class TextureAtlasElement
implements Disposable {
    protected TextureAtlas atlas;
    protected Object imageSource;
    protected volatile BufferedImage image;
    protected boolean imageInitializationFailed;
    protected PropertyChangeListener listener;

    public TextureAtlasElement(TextureAtlas textureAtlas, Object object) {
        if (textureAtlas == null) {
            String string = Logging.getMessage("nullValue.AtlasIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.atlas = textureAtlas;
        this.imageSource = object;
    }

    public TextureAtlas getTextureAtlas() {
        return this.atlas;
    }

    public Object getImageSource() {
        return this.imageSource;
    }

    protected boolean isBufferedImageSource() {
        return this.getImageSource() instanceof BufferedImage;
    }

    protected BufferedImage getImage() {
        return this.image;
    }

    protected void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public Dimension getSize() {
        return this.getTextureAtlas().getSize(this.getImageSource());
    }

    public TextureCoords getTexCoords() {
        return this.getTextureAtlas().getTexCoords(this.getImageSource());
    }

    public boolean isImageInitializationFailed() {
        return this.imageInitializationFailed;
    }

    public boolean load(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.isImageInitializationFailed()) {
            return false;
        }
        if (this.getTextureAtlas().contains(this.getImageSource())) {
            return true;
        }
        return this.requestImage(drawContext);
    }

    @Override
    public void dispose() {
        if (this.getTextureAtlas().contains(this.getImageSource())) {
            this.getTextureAtlas().remove(this.getImageSource());
        }
        this.setImage(null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TextureAtlasElement textureAtlasElement = (TextureAtlasElement)object;
        return this.imageSource != null ? this.imageSource.equals(textureAtlasElement.imageSource) : textureAtlasElement.imageSource == null;
    }

    public int hashCode() {
        return this.imageSource != null ? this.imageSource.hashCode() : 0;
    }

    public String toString() {
        return this.imageSource != null ? this.imageSource.toString() : null;
    }

    protected boolean requestImage(DrawContext drawContext) {
        if (this.isBufferedImageSource()) {
            this.setImage((BufferedImage)this.getImageSource());
        }
        if (this.getImage() != null && !this.getTextureAtlas().contains(this.getImageSource())) {
            return this.addAtlasImage();
        }
        if (WorldWind.getTaskService().isFull()) {
            return false;
        }
        Runnable runnable = this.createRequestTask();
        if (WorldWind.getTaskService().contains(runnable)) {
            return false;
        }
        this.listener = drawContext.getCurrentLayer() != null ? drawContext.getCurrentLayer() : drawContext.getLayers();
        WorldWind.getTaskService().addTask(runnable);
        return false;
    }

    protected boolean addAtlasImage() {
        if (this.getImage() == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        try {
            this.getTextureAtlas().add(this.getImageSource(), this.getImage());
            this.setImage(null);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("TextureAtlas.ExceptionAddingImage", this.getImageSource().toString());
            Logging.logger().log(Level.SEVERE, string, exception);
            this.imageInitializationFailed = true;
            return false;
        }
        return true;
    }

    protected Runnable createRequestTask() {
        return new RequestTask(this);
    }

    protected boolean loadImage() {
        BufferedImage bufferedImage;
        URL uRL = WorldWind.getDataFileStore().requestFile(this.getImageSource().toString());
        if (uRL != null && (bufferedImage = this.readImage(uRL)) != null) {
            this.setImage(bufferedImage);
        }
        return this.getImage() != null;
    }

    protected BufferedImage readImage(URL uRL) {
        try {
            return ImageIO.read(uRL);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToReadImageFile", this.getImageSource().toString());
            Logging.logger().log(Level.SEVERE, string, exception);
            this.imageInitializationFailed = true;
            return null;
        }
    }

    protected void notifyImageLoaded() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "gov.nasa.worldwind.avkey.Image", null, this));
            this.listener = null;
        }
    }

    protected static class RequestTask
    implements Runnable {
        protected TextureAtlasElement elem;

        protected RequestTask(TextureAtlasElement textureAtlasElement) {
            if (textureAtlasElement == null) {
                String string = Logging.getMessage("nullValue.ElementIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.elem = textureAtlasElement;
        }

        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (this.elem.loadImage()) {
                this.elem.notifyImageLoaded();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            return this.elem.equals(requestTask.elem);
        }

        public int hashCode() {
            return this.elem.hashCode();
        }

        public String toString() {
            return this.elem.toString();
        }
    }
}

