/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.DecisionTree;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SectorVisibilityTree {
    protected double sectorSize;
    protected Object globeStateKey;
    protected HashMap<Sector, Extent> prevExtents = new HashMap();
    protected HashMap<Sector, Extent> newExtents = new HashMap();
    protected ArrayList<Sector> sectors = new ArrayList();
    protected long timeStamp;
    protected DecisionTree<Sector, Context> tree = new DecisionTree<Sector, Context>(new DecisionTree.Controller<Sector, Context>(){

        @Override
        public boolean isTerminal(Sector sector, Context context) {
            if (sector.getDeltaLat().degrees > context.sectorSize) {
                return false;
            }
            context.sectors.add(sector);
            return true;
        }

        public Sector[] split(Sector sector, Context context) {
            return sector.subdivide();
        }

        @Override
        public boolean isVisible(Sector sector, Context context) {
            Extent extent = SectorVisibilityTree.this.prevExtents.get(sector);
            if (extent == null) {
                extent = Sector.computeBoundingBox(context.dc.getGlobe(), context.dc.getVerticalExaggeration(), sector);
            }
            if (extent.intersects(context.dc.getView().getFrustumInModelCoordinates())) {
                SectorVisibilityTree.this.newExtents.put(sector, extent);
                return true;
            }
            return false;
        }
    });

    public double getSectorSize() {
        return this.sectorSize;
    }

    public List<Sector> getSectors() {
        return this.sectors;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long l) {
        this.timeStamp = l;
    }

    public void clearSectors() {
        this.sectors.clear();
    }

    public List<Sector> refresh(DrawContext drawContext, double d) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < Angle.SECOND.degrees || d > 180.0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return Collections.emptyList();
        }
        this.sectors = new ArrayList();
        this.sectorSize = d;
        this.swapCylinderLists(drawContext);
        this.tree.traverse(drawContext.getVisibleSector(), new Context(drawContext, d, this.sectors));
        Collections.sort(this.sectors);
        return this.sectors;
    }

    public List<Sector> refresh(DrawContext drawContext, double d, Sector sector) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < Angle.SECOND.degrees || d > 180.0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sectors = new ArrayList();
        this.sectorSize = d;
        this.swapCylinderLists(drawContext);
        this.tree.traverse(sector, new Context(drawContext, d, this.sectors));
        Collections.sort(this.sectors);
        return this.sectors;
    }

    public List<Sector> refresh(DrawContext drawContext, double d, List<Sector> list) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < Angle.SECOND.degrees || d > 180.0) {
            String string = Logging.getMessage("generic.SizeOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.SectorListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.swapCylinderLists(drawContext);
        this.sectors = new ArrayList();
        this.sectorSize = d;
        for (Sector sector : list) {
            this.tree.traverse(sector, new Context(drawContext, d, this.sectors));
        }
        Collections.sort(this.sectors);
        return this.sectors;
    }

    protected void swapCylinderLists(DrawContext drawContext) {
        if (this.globeStateKey != null && !drawContext.getGlobe().getStateKey(drawContext).equals(this.globeStateKey)) {
            this.newExtents.clear();
        }
        this.prevExtents.clear();
        HashMap<Sector, Extent> hashMap = this.prevExtents;
        this.prevExtents = this.newExtents;
        this.newExtents = hashMap;
        this.globeStateKey = drawContext.getGlobe().getStateKey(drawContext);
    }

    protected static class Context {
        private final DrawContext dc;
        private final double sectorSize;
        private final List<Sector> sectors;

        public Context(DrawContext drawContext, double d, List<Sector> list) {
            this.dc = drawContext;
            this.sectorSize = d;
            this.sectors = list;
        }
    }
}

