/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.sun.opengl.util.j2d.TextRenderer;
import gov.nasa.worldwind.render.TextRendererCache;
import gov.nasa.worldwind.util.Logging;
import java.awt.Font;

public class OGLTextRenderer
extends TextRenderer {
    protected static final Font DEFAULT_FONT = Font.decode("Arial-PLAIN-12");
    protected static final boolean DEFAULT_ANTIALIAS = true;
    protected static final boolean DEFAULT_USE_FRACTIONAL_METRICS = false;
    protected static final boolean DEFAULT_MIPMAP = true;
    protected static final boolean DEFAULT_SMOOTHING = true;
    protected static final boolean DEFAULT_USE_VERTEX_ARRAYS = false;

    public OGLTextRenderer(Font font, boolean bl, boolean bl2, TextRenderer.RenderDelegate renderDelegate, boolean bl3) {
        super(font, bl, bl2, renderDelegate, bl3);
        this.initialize();
    }

    public OGLTextRenderer(Font font, boolean bl, boolean bl2, TextRenderer.RenderDelegate renderDelegate) {
        this(font, bl, bl2, renderDelegate, true);
    }

    public OGLTextRenderer(Font font, boolean bl, boolean bl2) {
        this(font, bl, bl2, null, true);
    }

    public OGLTextRenderer(Font font, boolean bl) {
        this(font, true, false, null, bl);
    }

    public OGLTextRenderer(Font font) {
        this(font, true, false, null, true);
    }

    public OGLTextRenderer() {
        this(DEFAULT_FONT, true, false, null, true);
    }

    protected void initialize() {
        this.setSmoothing(true);
        this.setUseVertexArrays(false);
    }

    public static TextRenderer getOrCreateTextRenderer(TextRendererCache textRendererCache, Font font, boolean bl, boolean bl2, boolean bl3) {
        if (textRendererCache == null) {
            String string = Logging.getMessage("nullValue.CacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TextRendererCache.CacheKey cacheKey = new TextRendererCache.CacheKey(font, bl, bl2, bl3);
        TextRenderer textRenderer = textRendererCache.get(cacheKey);
        if (textRenderer == null) {
            textRenderer = new OGLTextRenderer(font, bl, bl2, null, bl3);
            textRendererCache.put(cacheKey, textRenderer);
        }
        return textRenderer;
    }

    public static TextRenderer getOrCreateTextRenderer(TextRendererCache textRendererCache, Font font) {
        if (textRendererCache == null) {
            String string = Logging.getMessage("nullValue.CacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return OGLTextRenderer.getOrCreateTextRenderer(textRendererCache, font, true, false, true);
    }
}

