/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.render.Declutterable;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.ClutterFilter;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class BasicClutterFilter
implements ClutterFilter {
    protected List<Rectangle2D> rectList = new ArrayList<Rectangle2D>();

    @Override
    public void apply(DrawContext drawContext, List<Declutterable> list) {
        for (Declutterable declutterable : list) {
            Rectangle2D rectangle2D;
            Rectangle2D rectangle2D2 = declutterable.getBounds(drawContext);
            if (rectangle2D2 == null || (rectangle2D = this.intersects(rectangle2D2)) != null) continue;
            drawContext.addOrderedRenderable(declutterable);
            this.rectList.add(rectangle2D2);
        }
        this.clear();
    }

    protected void clear() {
        this.rectList.clear();
    }

    protected Rectangle2D intersects(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return null;
        }
        for (Rectangle2D rectangle2D2 : this.rectList) {
            if (!rectangle2D.intersects(rectangle2D2)) continue;
            return rectangle2D2;
        }
        return null;
    }
}

