/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.symbology.TacticalGraphicAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.TacticalGraphicUtil;
import gov.nasa.worldwind.symbology.TacticalPoint;
import gov.nasa.worldwind.symbology.TacticalRoute;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Route
extends AbstractMilStd2525TacticalGraphic
implements TacticalRoute,
PreRenderable {
    public static final double DEFAULT_WIDTH = 2000.0;
    protected static final Offset DEFAULT_OFFSET = Offset.fromFraction(-0.5, -0.5);
    protected List<Path> paths;
    protected Iterable<? extends Position> positions;
    protected Iterable<? extends TacticalPoint> children;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-ALC--------", "G-G-ALM--------", "G-G-ALS--------", "G-G-ALU--------", "G-G-ALL--------");
    }

    public Route(String string) {
        super(string);
    }

    @Override
    public void setHighlighted(boolean bl) {
        super.setHighlighted(bl);
        if (this.children != null) {
            for (TacticalPoint tacticalPoint : this.children) {
                tacticalPoint.setHighlighted(bl);
            }
        }
    }

    @Override
    public Iterable<? extends TacticalPoint> getControlPoints() {
        return this.children;
    }

    @Override
    public void setControlPoints(Iterable<? extends TacticalPoint> iterable) {
        this.children = iterable;
        ArrayList<? extends Position> arrayList = new ArrayList<Position>();
        double d = this.getWidth() / 2.0;
        for (TacticalPoint tacticalPoint : iterable) {
            tacticalPoint.setModifier("AM", d);
            tacticalPoint.setDelegateOwner(this);
            arrayList.add(tacticalPoint.getPosition());
        }
        this.positions = arrayList;
    }

    public double getWidth() {
        Object object = this.getModifier("AM");
        if (object instanceof Double) {
            return (Double)object;
        }
        return 2000.0;
    }

    public void setWidth(double d) {
        this.setModifier("AM", d);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.positions = iterable;
        Iterator<? extends Position> iterator = iterable.iterator();
        Iterator<? extends TacticalPoint> iterator2 = this.getControlPoints().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            iterator2.next().setPosition(iterator.next());
        }
        this.paths = null;
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return this.positions;
    }

    @Override
    public Position getReferencePosition() {
        if (this.positions != null) {
            return this.positions.iterator().next();
        }
        return null;
    }

    @Override
    public void setAttributes(TacticalGraphicAttributes tacticalGraphicAttributes) {
        super.setAttributes(tacticalGraphicAttributes);
        if (this.children != null) {
            for (TacticalPoint tacticalPoint : this.children) {
                tacticalPoint.setAttributes(tacticalGraphicAttributes);
            }
        }
    }

    @Override
    public void setHighlightAttributes(TacticalGraphicAttributes tacticalGraphicAttributes) {
        super.setHighlightAttributes(tacticalGraphicAttributes);
        if (this.children != null) {
            for (TacticalPoint tacticalPoint : this.children) {
                tacticalPoint.setHighlightAttributes(tacticalGraphicAttributes);
            }
        }
    }

    @Override
    public void setStatus(String string) {
        super.setStatus(string);
        if (this.children != null) {
            for (TacticalPoint tacticalPoint : this.children) {
                if (!(tacticalPoint instanceof MilStd2525TacticalGraphic)) continue;
                ((MilStd2525TacticalGraphic)((Object)tacticalPoint)).setStatus(string);
            }
        }
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (!this.isVisible()) {
            return;
        }
        this.determineActiveAttributes();
        if (this.children != null) {
            for (TacticalPoint tacticalPoint : this.children) {
                if (!(tacticalPoint instanceof PreRenderable)) continue;
                ((PreRenderable)((Object)tacticalPoint)).preRender(drawContext);
            }
        }
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        if (this.paths == null) {
            this.createPaths(drawContext);
        }
        for (Path movable : this.paths) {
            movable.render(drawContext);
        }
        if (this.children != null) {
            for (TacticalPoint tacticalPoint : this.children) {
                tacticalPoint.render(drawContext);
            }
        }
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        if (this.paths != null) {
            for (Path path : this.paths) {
                path.setDelegateOwner(object);
            }
        }
        if (this.children != null) {
            boolean bl = this.isShowTextModifiers();
            boolean bl2 = this.isShowGraphicModifiers();
            boolean bl3 = this.isShowHostileIndicator();
            for (TacticalPoint tacticalPoint : this.children) {
                tacticalPoint.setDelegateOwner(object);
                tacticalPoint.setShowTextModifiers(bl);
                tacticalPoint.setShowGraphicModifiers(bl2);
                tacticalPoint.setShowHostileIndicator(bl3);
            }
        }
    }

    protected void createPaths(DrawContext drawContext) {
        Globe globe = drawContext.getGlobe();
        this.paths = new ArrayList<Path>();
        double d = this.getWidth() / 2.0;
        Iterator<? extends Position> iterator = this.getPositions().iterator();
        Position position = iterator.next();
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = globe.computeSurfaceNormalAtPoint(vec4);
        while (iterator.hasNext()) {
            Position position2 = iterator.next();
            Vec4 vec43 = globe.computePointFromPosition(position2);
            Vec4 vec44 = vec43.subtract3(vec4);
            Object object = vec44.cross3(vec42);
            object = ((Vec4)object).normalize3().multiply3(d);
            Vec4 vec45 = vec4.add3((Vec4)object);
            Vec4 vec46 = vec43.add3((Vec4)object);
            Position position3 = globe.computePositionFromPoint(vec45);
            Position position4 = globe.computePositionFromPoint(vec46);
            Path path = this.createPath(position3, position4);
            this.paths.add(path);
            Vec4 object2 = vec4.subtract3((Vec4)object);
            vec46 = vec43.subtract3((Vec4)object);
            position3 = globe.computePositionFromPoint(object2);
            position4 = globe.computePositionFromPoint(vec46);
            path = this.createPath(position3, position4);
            this.paths.add(path);
            vec4 = vec43;
        }
        double d2 = this.getWidth() / 2.0;
        for (TacticalPoint tacticalPoint : this.getControlPoints()) {
            tacticalPoint.setModifier("AM", d2);
        }
    }

    protected String createLabelText() {
        Object[] objectArray;
        Object[] objectArray2;
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.getModifier("T");
        if (object != null) {
            stringBuilder.append("Name: ");
            stringBuilder.append(object);
            stringBuilder.append("\n");
        }
        if ((object = this.getModifier("AM")) != null) {
            stringBuilder.append("Width: ");
            stringBuilder.append(object);
            stringBuilder.append(" m");
            stringBuilder.append("\n");
        }
        if ((objectArray2 = TacticalGraphicUtil.getAltitudeRange(this))[0] != null) {
            stringBuilder.append("Min Alt: ");
            stringBuilder.append(objectArray2[0]);
            stringBuilder.append("\n");
        }
        if (objectArray2[1] != null) {
            stringBuilder.append("Max Alt: ");
            stringBuilder.append(objectArray2[1]);
            stringBuilder.append("\n");
        }
        if ((objectArray = TacticalGraphicUtil.getDateRange(this))[0] != null) {
            stringBuilder.append("DTG Start: ");
            stringBuilder.append(objectArray[0]);
            stringBuilder.append("\n");
        }
        if (objectArray[1] != null) {
            stringBuilder.append("DTG End: ");
            stringBuilder.append(objectArray[1]);
        }
        return stringBuilder.toString();
    }

    @Override
    protected void createLabels() {
        String string = this.createLabelText();
        if (string == null) {
            return;
        }
        TacticalGraphicLabel tacticalGraphicLabel = this.addLabel(string);
        tacticalGraphicLabel.setTextAlign("gov.nasa.worldwind.avkey.Left");
        tacticalGraphicLabel.setOffset(DEFAULT_OFFSET);
        Iterator<? extends Position> iterator = this.getPositions().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            if (!iterator.hasNext()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getGraphicLabel());
            String string2 = this.getText();
            if (!WWUtil.isEmpty(string2)) {
                stringBuilder.append(" ");
                stringBuilder.append(string2);
            }
            this.addLabel(stringBuilder.toString());
        }
    }

    protected String getGraphicLabel() {
        String string = this.maskedSymbolCode;
        if ("G-G-ALC--------".equalsIgnoreCase(string)) {
            return "AC";
        }
        if ("G-G-ALM--------".equalsIgnoreCase(string)) {
            return "MRR";
        }
        if ("G-G-ALS--------".equalsIgnoreCase(string)) {
            return "SAAFR";
        }
        if ("G-G-ALL--------".equalsIgnoreCase(string)) {
            return "LLTR";
        }
        if ("G-G-ALU--------".equalsIgnoreCase(string)) {
            return "UA";
        }
        return "";
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        Iterator<? extends Position> iterator = this.getPositions().iterator();
        Position position = iterator.next();
        int n = 0;
        while (iterator.hasNext()) {
            Position position2 = iterator.next();
            Position position3 = Position.interpolate(0.5, position, position2);
            TacticalGraphicLabel tacticalGraphicLabel = (TacticalGraphicLabel)this.labels.get(n);
            if (n == 0) {
                tacticalGraphicLabel.setPosition(this.getReferencePosition());
                tacticalGraphicLabel.setPosition(this.computeMainLabelPosition(drawContext, tacticalGraphicLabel, position3, position2));
                tacticalGraphicLabel = (TacticalGraphicLabel)this.labels.get(++n);
            }
            tacticalGraphicLabel.setPosition(position3);
            tacticalGraphicLabel.setOrientationPosition(position2);
            ++n;
            position = position2;
        }
    }

    @Override
    protected Offset getDefaultLabelOffset() {
        return DEFAULT_OFFSET;
    }

    protected Position computeMainLabelPosition(DrawContext drawContext, TacticalGraphicLabel tacticalGraphicLabel, Position position, Position position2) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = globe.computePointFromPosition(position2);
        Vec4 vec43 = globe.computeSurfaceNormalAtPoint(vec4);
        Vec4 vec44 = vec42.subtract3(vec4);
        Vec4 vec45 = drawContext.getView().getEyePoint();
        double d = drawContext.getView().computePixelSizeAtDistance(vec45.distanceTo3(vec4));
        Rectangle rectangle = tacticalGraphicLabel.getBounds(drawContext);
        double d2 = rectangle != null ? Math.hypot(rectangle.width, rectangle.height) : 0.0;
        double d3 = d2 / 2.0;
        Vec4 vec46 = vec44.cross3(vec43);
        vec46 = vec46.normalize3().multiply3(this.getWidth() / 2.0 + d3 * d);
        Vec4 vec47 = vec4.add3(vec46);
        return globe.computePositionFromPoint(vec47);
    }

    protected Path createPath(Position position, Position position2) {
        Path path = new Path(position, position2);
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(1);
        path.setDelegateOwner(this.getActiveDelegateOwner());
        path.setAttributes(this.getActiveShapeAttributes());
        return path;
    }
}

