/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.symbology.TacticalGraphicUtil;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DirectionOfAttack
extends AbstractMilStd2525TacticalGraphic {
    public static final double DEFAULT_ARROWHEAD_LENGTH = 0.1;
    public static final Angle DEFAULT_ARROWHEAD_ANGLE = Angle.fromDegrees(60.0);
    public static final double DEFAULT_ARROWHEAD_OUTLINE_WIDTH = 0.3;
    protected Angle arrowAngle = DEFAULT_ARROWHEAD_ANGLE;
    protected double arrowLength = 0.1;
    protected double outlineWidth = 0.3;
    protected Position startPosition;
    protected Position endPosition;
    protected Path[] paths;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-OLKGM------", "G-G-OLKGS------");
    }

    public DirectionOfAttack(String string) {
        super(string);
    }

    public Angle getArrowAngle() {
        return this.arrowAngle;
    }

    public void setArrowAngle(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees <= 0.0) {
            String string = Logging.getMessage("generic.AngleOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.arrowAngle = angle;
    }

    public double getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.arrowLength = d;
    }

    public double getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineWidth = d;
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            Iterator<? extends Position> iterator = iterable.iterator();
            this.endPosition = iterator.next();
            this.startPosition = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.paths = null;
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return Arrays.asList(this.endPosition, this.startPosition);
    }

    @Override
    public Position getReferencePosition() {
        return this.startPosition;
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        for (Path path : this.paths) {
            path.render(drawContext);
        }
    }

    @Override
    protected void computeGeometry(DrawContext drawContext) {
        if (this.paths == null) {
            this.createShapes(drawContext);
        }
        super.computeGeometry(drawContext);
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        if (this.paths == null) {
            return;
        }
        for (Path path : this.paths) {
            path.setDelegateOwner(object);
        }
    }

    protected boolean isDrawOutlined() {
        return "G-G-OLKGM------".equalsIgnoreCase(this.maskedSymbolCode);
    }

    protected void createShapes(DrawContext drawContext) {
        this.paths = new Path[2];
        this.paths[0] = this.createPath(Arrays.asList(this.startPosition, this.endPosition));
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(this.startPosition);
        Vec4 vec42 = globe.computePointFromPosition(this.endPosition);
        Vec4 vec43 = vec4.subtract3(vec42);
        double d = vec43.getLength3() * this.getArrowLength();
        List<Position> list = this.computeArrowheadPositions(drawContext, vec42, vec43, d);
        this.paths[1] = this.createPath(list);
    }

    protected List<Position> computeArrowheadPositions(DrawContext drawContext, Vec4 vec4, Vec4 vec42, double d) {
        List<Position> list;
        Globe globe = drawContext.getGlobe();
        Vec4 vec43 = vec4;
        double d2 = d * this.getArrowAngle().tanHalfAngle();
        vec42 = vec42.normalize3();
        Vec4 vec44 = vec43.add3(vec42.multiply3(d));
        Vec4 vec45 = globe.computeSurfaceNormalAtPoint(vec44);
        Vec4 vec46 = vec42.cross3(vec45);
        vec46 = vec46.normalize3().multiply3(d2);
        Vec4 vec47 = vec44.add3(vec46);
        Vec4 vec48 = vec44.subtract3(vec46);
        if (this.isDrawOutlined()) {
            double d3 = this.getOutlineWidth();
            vec46 = vec46.multiply3(1.0 + d3);
            Vec4 vec49 = vec44.add3(vec46);
            Vec4 vec410 = vec44.subtract3(vec46);
            Vec4 vec411 = vec43.subtract3(vec42.multiply3(d * d3));
            list = TacticalGraphicUtil.asPositionList(globe, vec47, vec43, vec48, vec410, vec411, vec49, vec47);
        } else {
            list = TacticalGraphicUtil.asPositionList(globe, vec47, vec43, vec48);
        }
        return list;
    }

    protected Path createPath(List<Position> list) {
        Path path = new Path(list);
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(1);
        path.setDelegateOwner(this.getActiveDelegateOwner());
        path.setAttributes(this.getActiveShapeAttributes());
        return path;
    }
}

