/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.AbstractCircularGraphic;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.FireSupportTextBuilder;
import gov.nasa.worldwind.util.WWUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CircularFireSupportArea
extends AbstractCircularGraphic {
    protected static final String DIAGONAL_FILL_PATH = "images/diagonal-fill-16x16.png";
    protected static final Offset LEFT_ALIGN_OFFSET = new Offset(-0.5, -0.5, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction");

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-F-ATC--------", "G-F-ACSC-------", "G-F-ACFC-------", "G-F-ACRC-------", "G-F-ACAC-------", "G-F-ACEC-------", "G-F-ACDC-------", "G-F-ACZC-------", "G-F-ACBC-------", "G-F-ACVC-------", "G-F-ACNC-------", "G-F-AKBC-------", "G-F-AKPC-------");
    }

    public CircularFireSupportArea(String string) {
        super(string);
    }

    public static Set<String> getGraphicsWithTimeLabel() {
        return new HashSet<String>(Arrays.asList("G-F-ACSC-------", "G-F-ACEC-------", "G-F-ACDC-------", "G-F-ACZC-------", "G-F-ACBC-------", "G-F-ACVC-------"));
    }

    @Override
    protected void createLabels() {
        Object object;
        FireSupportTextBuilder fireSupportTextBuilder = this.createTextBuilder();
        String[] stringArray = fireSupportTextBuilder.createText(this);
        String string = stringArray[0];
        if (!WWUtil.isEmpty(string)) {
            object = this.addLabel(string);
            ((TacticalGraphicLabel)object).setTextAlign(this.getMainLabelTextAlign());
            if (this.isFilled()) {
                ((TacticalGraphicLabel)object).setEffect("gov.nasa.worldwind.avkey.TextEffectNone");
                ((TacticalGraphicLabel)object).setDrawInterior(true);
            }
        }
        if (stringArray.length > 1 && !WWUtil.isEmpty(object = stringArray[1])) {
            TacticalGraphicLabel tacticalGraphicLabel = this.addLabel((String)object);
            tacticalGraphicLabel.setTextAlign("gov.nasa.worldwind.avkey.Right");
        }
    }

    protected FireSupportTextBuilder createTextBuilder() {
        return new FireSupportTextBuilder();
    }

    protected String getMainLabelTextAlign() {
        boolean bl = "G-F-ACAC-------".equalsIgnoreCase(this.maskedSymbolCode);
        if (bl) {
            return "gov.nasa.worldwind.avkey.Left";
        }
        return "gov.nasa.worldwind.avkey.Center";
    }

    @Override
    protected Offset getDefaultLabelOffset() {
        boolean bl = "G-F-ACAC-------".equalsIgnoreCase(this.maskedSymbolCode);
        if (bl) {
            return LEFT_ALIGN_OFFSET;
        }
        return super.getDefaultLabelOffset();
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        if (WWUtil.isEmpty(this.labels)) {
            return;
        }
        ((TacticalGraphicLabel)this.labels.get(0)).setPosition(new Position(this.circle.getCenter(), 0.0));
        Position position = new Position(this.circle.getCenter(), 0.0);
        double d = this.circle.getRadius() / drawContext.getGlobe().getRadius();
        if (this.labels.size() > 1) {
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, Angle.NEG90, Angle.fromRadians(d));
            ((TacticalGraphicLabel)this.labels.get(1)).setPosition(new Position(latLon, 0.0));
        }
    }

    @Override
    protected void applyDefaultAttributes(ShapeAttributes shapeAttributes) {
        super.applyDefaultAttributes(shapeAttributes);
        if (this.isFilled()) {
            shapeAttributes.setDrawInterior(true);
            shapeAttributes.setImageSource(this.getImageSource());
        }
    }

    protected boolean isFilled() {
        return "G-F-ACNC-------".equalsIgnoreCase(this.maskedSymbolCode) || "G-F-AKBC-------".equalsIgnoreCase(this.maskedSymbolCode) || "G-F-AKPC-------".equalsIgnoreCase(this.maskedSymbolCode);
    }

    protected Object getImageSource() {
        return DIAGONAL_FILL_PATH;
    }
}

