/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.symbology.AbstractTacticalGraphic;
import gov.nasa.worldwind.symbology.SymbologyConstants;
import gov.nasa.worldwind.symbology.TacticalSymbol;
import gov.nasa.worldwind.symbology.TacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525TacticalGraphic;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525TacticalSymbol;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525Util;
import gov.nasa.worldwind.symbology.milstd2525.SymbolCode;
import gov.nasa.worldwind.util.Logging;

public abstract class AbstractMilStd2525TacticalGraphic
extends AbstractTacticalGraphic
implements MilStd2525TacticalGraphic,
Renderable {
    protected static final int OUTLINE_STIPPLE_FACTOR_PRESENT = 0;
    protected static final int OUTLINE_STIPPLE_FACTOR_ANTICIPATED = 6;
    protected static final short OUTLINE_STIPPLE_PATTERN = -21846;
    protected SymbolCode symbolCode;
    protected String maskedSymbolCode;

    protected AbstractMilStd2525TacticalGraphic(String string) {
        this.symbolCode = new SymbolCode(string);
        this.maskedSymbolCode = this.symbolCode.toMaskedString();
        this.setUnitsFormat(MilStd2525TacticalSymbol.DEFAULT_UNITS_FORMAT);
    }

    @Override
    public String getIdentifier() {
        return this.symbolCode.toString();
    }

    @Override
    public Object getModifier(String string) {
        if ("T".equals(string) && this.text != null) {
            return this.text;
        }
        return super.getModifier(string);
    }

    @Override
    public void setModifier(String string, Object object) {
        if ("T".equals(string) && object instanceof String) {
            this.setText((String)object);
        } else {
            super.setModifier(string, object);
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getStatus() {
        return this.symbolCode.getStatus();
    }

    @Override
    public void setStatus(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (!SymbologyConstants.STATUS_ALL.contains(string.toUpperCase())) {
            String string3 = Logging.getMessage("Symbology.InvalidStatus", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.symbolCode.setStatus(string);
    }

    protected boolean mustShowHostileIndicator() {
        String string = this.symbolCode.getStandardIdentity();
        boolean bl = "H".equalsIgnoreCase(string) || "S".equalsIgnoreCase(string) || "K".equalsIgnoreCase(string) || "J".equalsIgnoreCase(string);
        return this.isShowHostileIndicator() && bl;
    }

    @Override
    protected void applyDefaultAttributes(ShapeAttributes shapeAttributes) {
        Material material = this.getDefaultMaterial();
        shapeAttributes.setOutlineMaterial(material);
        shapeAttributes.setInteriorMaterial(material);
        String string = this.getStatus();
        if (!"P".equalsIgnoreCase(string)) {
            shapeAttributes.setOutlineStippleFactor(this.getOutlineStippleFactor());
            shapeAttributes.setOutlineStipplePattern(this.getOutlineStipplePattern());
        } else {
            shapeAttributes.setOutlineStippleFactor(0);
        }
        shapeAttributes.setDrawInterior(false);
    }

    protected int getOutlineStippleFactor() {
        return 6;
    }

    protected short getOutlineStipplePattern() {
        return -21846;
    }

    protected Material getDefaultMaterial() {
        return MilStd2525Util.getDefaultGraphicMaterial(this.symbolCode);
    }

    protected TacticalSymbol createSymbol(String string, Position position, TacticalSymbolAttributes tacticalSymbolAttributes) {
        MilStd2525TacticalSymbol milStd2525TacticalSymbol = new MilStd2525TacticalSymbol(string, position != null ? position : Position.ZERO);
        milStd2525TacticalSymbol.setDelegateOwner(this);
        milStd2525TacticalSymbol.setAttributes(tacticalSymbolAttributes);
        milStd2525TacticalSymbol.setShowTextModifiers(false);
        return milStd2525TacticalSymbol;
    }
}

