/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.texture.TextureCoords;
import gov.nasa.worldwind.Exportable;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.ogc.kml.impl.KMLExportUtil;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.Size;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.media.opengl.GL;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ScreenImage
extends WWObjectImpl
implements Renderable,
Exportable {
    protected Object imageSource;
    protected BasicWWTexture texture;
    protected OrderedImage orderedImage = new OrderedImage();
    protected PickSupport pickSupport = new PickSupport();
    protected double opacity = 1.0;
    protected Double rotation;
    protected Color color = Color.WHITE;
    protected Object delegateOwner;
    protected Size size = new Size();
    protected Offset screenOffset;
    protected Offset imageOffset;
    protected Offset rotationOffset;
    protected long frameNumber = -1L;
    protected int width;
    protected int height;
    protected int originalImageWidth;
    protected int originalImageHeight;
    protected Point rotationPoint;
    protected Point screenLocation;
    protected Point awtScreenLocation;
    protected double dx;
    protected double dy;
    protected Layer pickLayer;

    public Point getScreenLocation() {
        return this.awtScreenLocation;
    }

    public Point getScreenLocation(DrawContext drawContext) {
        this.computeOffsets(drawContext);
        return this.awtScreenLocation;
    }

    public void setScreenLocation(Point point) {
        this.screenOffset = new Offset(point.getX(), point.getY(), "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.InsetPixels");
        this.imageOffset = new Offset(0.5, 0.5, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction");
        this.awtScreenLocation = new Point(point);
    }

    public Offset getScreenOffset() {
        return this.screenOffset;
    }

    public void setScreenOffset(Offset offset) {
        this.screenOffset = offset;
    }

    public Offset getImageOffset() {
        return this.imageOffset;
    }

    public void setImageOffset(Offset offset) {
        this.imageOffset = offset;
    }

    public Double getRotation() {
        return this.rotation;
    }

    public void setRotation(Double d) {
        this.rotation = d;
    }

    public Offset getRotationOffset() {
        return this.rotationOffset;
    }

    public void setRotationOffset(Offset offset) {
        this.rotationOffset = offset;
    }

    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        if (size == null) {
            String string = Logging.getMessage("nullValue.SizeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.size = size;
    }

    public Object getImageSource() {
        return this.imageSource;
    }

    public void setImageSource(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.imageSource = object;
        this.texture = null;
    }

    protected BasicWWTexture initializeTexture() {
        Object object = this.getImageSource();
        if (object instanceof String || object instanceof URL) {
            URL uRL = WorldWind.getDataFileStore().requestFile(object.toString());
            if (uRL != null) {
                this.texture = new BasicWWTexture(uRL, true);
                this.texture.setUseAnisotropy(false);
            }
        } else if (object != null) {
            this.texture = new BasicWWTexture(object, true);
            return this.texture;
        }
        return null;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setOpacity(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.opacity = d;
    }

    public int getImageWidth(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.computeOffsets(drawContext);
        return this.width;
    }

    public int getImageHeight(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.computeOffsets(drawContext);
        return this.height;
    }

    public Object getDelegateOwner() {
        return this.delegateOwner;
    }

    public void setDelegateOwner(Object object) {
        this.delegateOwner = object;
    }

    protected void computeOffsets(DrawContext drawContext) {
        if (drawContext.getFrameTimeStamp() != this.frameNumber) {
            Point2D.Double double_;
            Object object;
            BasicWWTexture basicWWTexture = this.getTexture();
            int n = drawContext.getView().getViewport().width;
            int n2 = drawContext.getView().getViewport().height;
            if (basicWWTexture != null) {
                this.originalImageWidth = basicWWTexture.getWidth(drawContext);
                this.originalImageHeight = basicWWTexture.getHeight(drawContext);
            } else if (this.getImageSource() == null) {
                this.originalImageWidth = 1;
                this.originalImageHeight = 1;
            } else {
                this.frameNumber = drawContext.getFrameTimeStamp();
                return;
            }
            if (this.size != null) {
                object = this.size.compute(this.originalImageWidth, this.originalImageHeight, n, n2);
                this.width = ((Dimension)object).width;
                this.height = ((Dimension)object).height;
            } else {
                this.width = this.originalImageWidth;
                this.height = this.originalImageHeight;
            }
            object = this.getRotationOffset();
            if (object != null) {
                double_ = ((Offset)object).computeOffset(this.width, this.height, null, null);
                this.rotationPoint = new Point((int)double_.x, (int)double_.y);
            } else {
                this.rotationPoint = new Point(this.width, this.height);
            }
            if (this.screenOffset != null) {
                double_ = this.screenOffset.computeOffset(n, n2, null, null);
                this.screenLocation = new Point((int)double_.x, (int)double_.y);
            } else {
                this.screenLocation = new Point(n / 2, n2 / 2);
            }
            this.awtScreenLocation = new Point(this.screenLocation.x, n2 - this.screenLocation.y);
            double_ = this.imageOffset != null ? this.imageOffset.computeOffset(this.width, this.height, null, null) : new Point2D.Double((double)this.originalImageWidth / 2.0, (double)this.originalImageHeight / 2.0);
            this.dx = -double_.x;
            this.dy = -double_.y;
            this.frameNumber = drawContext.getFrameTimeStamp();
        }
    }

    protected BasicWWTexture getTexture() {
        if (this.texture != null) {
            return this.texture;
        }
        return this.initializeTexture();
    }

    @Override
    public void render(DrawContext drawContext) {
        this.computeOffsets(drawContext);
        this.doRender(drawContext);
    }

    public void pick(DrawContext drawContext, Point point) {
        this.doRender(drawContext);
    }

    protected void doRender(DrawContext drawContext) {
        if (drawContext.isPickingMode()) {
            this.pickLayer = drawContext.getCurrentLayer();
        }
        drawContext.addOrderedRenderable(this.orderedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(DrawContext drawContext) {
        if (this.screenLocation == null) {
            return;
        }
        GL gL = drawContext.getGL();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            gL.glPushAttrib(30977);
            bl = true;
            gL.glDisable(2929);
            gL.glEnable(3008);
            gL.glAlphaFunc(516, 0.001f);
            Rectangle rectangle = drawContext.getView().getViewport();
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            bl3 = true;
            gL.glLoadIdentity();
            gL.glOrtho(0.0, (double)rectangle.width, 0.0, (double)rectangle.height, -1.0, 1.0);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            bl2 = true;
            gL.glLoadIdentity();
            gL.glTranslated((double)this.screenLocation.x + this.dx, (double)this.screenLocation.y + this.dy, 0.0);
            Double d = this.getRotation();
            if (d != null) {
                gL.glTranslated((double)this.rotationPoint.x, (double)this.rotationPoint.y, 0.0);
                gL.glRotated(d.doubleValue(), 0.0, 0.0, 1.0);
                gL.glTranslated((double)(-this.rotationPoint.x), (double)(-this.rotationPoint.y), 0.0);
            }
            double d2 = (double)this.getImageWidth(drawContext) / (double)this.originalImageWidth;
            double d3 = (double)this.getImageHeight(drawContext) / (double)this.originalImageHeight;
            if (!drawContext.isPickingMode()) {
                boolean bl4 = this.getTexture() != null;
                gL.glEnable(3553);
                if (bl4) {
                    if (this.getTexture().bind(drawContext)) {
                        gL.glColor4d(1.0, 1.0, 1.0, this.opacity);
                    } else {
                        bl4 = false;
                    }
                }
                gL.glEnable(3042);
                gL.glBlendFunc(770, 771);
                if (bl4) {
                    TextureCoords textureCoords = this.getTexture().getTexCoords();
                    gL.glScaled(d2 * (double)this.originalImageWidth, d3 * (double)this.originalImageHeight, 1.0);
                    drawContext.drawUnitQuad(textureCoords);
                    gL.glBindTexture(3553, 0);
                } else {
                    Color color = this.getColor();
                    float[] fArray = color.getRGBColorComponents(null);
                    gL.glColor4d((double)fArray[0], (double)fArray[1], (double)fArray[2], (double)color.getAlpha() / 255.0);
                    gL.glScaled(d2, d3, 1.0);
                    drawContext.drawUnitQuad();
                }
            } else {
                this.pickSupport.clearPickList();
                this.pickSupport.beginPicking(drawContext);
                Color color = drawContext.getUniquePickColor();
                int n = color.getRGB();
                this.pickSupport.addPickableObject(n, this.delegateOwner != null ? this.delegateOwner : this, null, false);
                gL.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                gL.glScaled(d2 * (double)this.originalImageWidth, d3 * (double)this.originalImageHeight, 1.0);
                drawContext.drawUnitQuad();
                this.pickSupport.endPicking(drawContext);
                this.pickSupport.resolvePick(drawContext, drawContext.getPickPoint(), this.pickLayer);
            }
        }
        finally {
            if (bl3) {
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
            }
            if (bl2) {
                gL.glMatrixMode(5888);
                gL.glPopMatrix();
            }
            if (bl) {
                gL.glPopAttrib();
            }
        }
    }

    @Override
    public String isExportFormatSupported(String string) {
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            return "Export.FormatSupported";
        }
        return "Export.FormatNotSupported";
    }

    @Override
    public void export(String string, Object object) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage("nullValue.OutputBufferIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            try {
                this.exportAsKML(object);
            }
            catch (XMLStreamException xMLStreamException) {
                Logging.logger().throwing(this.getClass().getName(), "export", xMLStreamException);
                throw new IOException(xMLStreamException);
            }
        } else {
            String string4 = Logging.getMessage("Export.UnsupportedFormat", string);
            Logging.logger().warning(string4);
            throw new UnsupportedOperationException(string4);
        }
    }

    protected void exportAsKML(Object object) throws IOException, XMLStreamException {
        Serializable serializable;
        XMLStreamWriter xMLStreamWriter = null;
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        boolean bl = true;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
            bl = false;
        } else if (object instanceof Writer) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((Writer)object);
        } else if (object instanceof OutputStream) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((OutputStream)object);
        }
        if (xMLStreamWriter == null) {
            String string = Logging.getMessage("Export.UnsupportedOutputObject");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        xMLStreamWriter.writeStartElement("ScreenOverlay");
        xMLStreamWriter.writeStartElement("visibility");
        xMLStreamWriter.writeCharacters("1");
        xMLStreamWriter.writeEndElement();
        String string = null;
        Object object2 = this.getImageSource();
        if (object2 instanceof String) {
            string = (String)object2;
        } else if (object2 instanceof URL) {
            string = object2.toString();
        }
        if (string != null) {
            xMLStreamWriter.writeStartElement("Icon");
            xMLStreamWriter.writeStartElement("href");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        } else {
            serializable = this.getColor();
            if (serializable != null) {
                xMLStreamWriter.writeStartElement("color");
                xMLStreamWriter.writeCharacters(KMLExportUtil.stripHexPrefix(WWUtil.encodeColorABGR((Color)serializable)));
                xMLStreamWriter.writeEndElement();
            }
        }
        KMLExportUtil.exportOffset(xMLStreamWriter, this.getImageOffset(), "overlayXY");
        KMLExportUtil.exportOffset(xMLStreamWriter, this.getScreenOffset(), "screenXY");
        serializable = this.getRotation();
        if (serializable != null) {
            xMLStreamWriter.writeStartElement("rotation");
            xMLStreamWriter.writeCharacters(((Double)serializable).toString());
            xMLStreamWriter.writeEndElement();
        }
        KMLExportUtil.exportOffset(xMLStreamWriter, this.getRotationOffset(), "rotationXY");
        KMLExportUtil.exportDimension(xMLStreamWriter, this.getSize(), "size");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }

    protected class OrderedImage
    implements OrderedRenderable {
        protected OrderedImage() {
        }

        @Override
        public double getDistanceFromEye() {
            return 0.0;
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
            ScreenImage.this.draw(drawContext);
        }

        @Override
        public void render(DrawContext drawContext) {
            ScreenImage.this.draw(drawContext);
        }
    }
}

