/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.texture.TextureCoords;
import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.Pedestal;
import gov.nasa.worldwind.render.ToolTipRenderer;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.logging.Level;
import javax.media.opengl.GL;

public class IconRenderer {
    protected Pedestal pedestal;
    protected boolean horizonClippingEnabled = false;
    protected boolean viewClippingEnabled = true;
    protected boolean pickFrustumClippingEnabled = true;
    protected boolean alwaysUseAbsoluteElevation = false;
    protected OGLStackHandler oglStackHandler = new OGLStackHandler();
    protected boolean allowBatchPicking = true;
    protected PickSupport pickSupport = new PickSupport();

    public Pedestal getPedestal() {
        return this.pedestal;
    }

    public void setPedestal(Pedestal pedestal) {
        this.pedestal = pedestal;
    }

    public boolean isHorizonClippingEnabled() {
        return this.horizonClippingEnabled;
    }

    public void setHorizonClippingEnabled(boolean bl) {
        this.horizonClippingEnabled = bl;
    }

    public boolean isViewClippingEnabled() {
        return this.viewClippingEnabled;
    }

    public void setViewClippingEnabled(boolean bl) {
        this.viewClippingEnabled = bl;
    }

    public boolean isPickFrustumClippingEnabled() {
        return this.pickFrustumClippingEnabled;
    }

    public void setPickFrustumClippingEnabled(boolean bl) {
        this.pickFrustumClippingEnabled = bl;
    }

    protected static boolean isIconValid(WWIcon wWIcon, boolean bl) {
        if (wWIcon == null || wWIcon.getImageTexture() == null) {
            return false;
        }
        return !bl || wWIcon.getPosition() != null;
    }

    public boolean isAlwaysUseAbsoluteElevation() {
        return this.alwaysUseAbsoluteElevation;
    }

    public void setAlwaysUseAbsoluteElevation(boolean bl) {
        this.alwaysUseAbsoluteElevation = bl;
    }

    public boolean isAllowBatchPicking() {
        return this.allowBatchPicking;
    }

    public void setAllowBatchPicking(boolean bl) {
        this.allowBatchPicking = bl;
    }

    public void pick(DrawContext drawContext, Iterable<? extends WWIcon> iterable, Point point, Layer layer) {
        this.drawMany(drawContext, iterable, layer);
    }

    public void render(DrawContext drawContext, Iterable<? extends WWIcon> iterable) {
        this.drawMany(drawContext, iterable, null);
    }

    protected void drawMany(DrawContext drawContext, Iterable<? extends WWIcon> iterable, Layer layer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IconIterator");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends WWIcon> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        double d = drawContext.getView().getHorizonDistance();
        while (iterator.hasNext()) {
            double d2;
            WWIcon wWIcon = iterator.next();
            if (!IconRenderer.isIconValid(wWIcon, true)) {
                if (wWIcon == null) continue;
                this.recordFeedback(drawContext, wWIcon, null, null);
                continue;
            }
            if (!wWIcon.isVisible()) {
                this.recordFeedback(drawContext, wWIcon, null, null);
                continue;
            }
            Position position = wWIcon.getPosition();
            Vec4 vec4 = null;
            if (position.getElevation() < drawContext.getGlobe().getMaxElevation() && !this.isAlwaysUseAbsoluteElevation()) {
                vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(wWIcon.getPosition());
            }
            if (vec4 == null) {
                Angle angle = position.getLatitude();
                Angle angle2 = position.getLongitude();
                double d3 = position.getElevation();
                if (!this.isAlwaysUseAbsoluteElevation()) {
                    d3 += drawContext.getGlobe().getElevation(angle, angle2);
                }
                vec4 = drawContext.getGlobe().computePointFromPosition(angle, angle2, d3);
            }
            double d4 = d2 = wWIcon.isAlwaysOnTop() ? 0.0 : drawContext.getView().getEyePoint().distanceTo3(vec4);
            if (this.isHorizonClippingEnabled() && d2 > d) {
                this.recordFeedback(drawContext, wWIcon, vec4, null);
                continue;
            }
            if (this.isViewClippingEnabled() && !drawContext.getView().getFrustumInModelCoordinates().contains(vec4)) {
                this.recordFeedback(drawContext, wWIcon, vec4, null);
                continue;
            }
            drawContext.addOrderedRenderable(new OrderedIcon(wWIcon, vec4, layer, d2, d));
            if (!wWIcon.isShowToolTip()) continue;
            this.addToolTip(drawContext, wWIcon, vec4);
        }
    }

    protected void addToolTip(DrawContext drawContext, WWIcon wWIcon, Vec4 vec4) {
        if (wWIcon.getToolTipFont() == null && wWIcon.getToolTipText() == null) {
            return;
        }
        Vec4 vec42 = drawContext.getView().project(vec4);
        if (vec42 == null) {
            return;
        }
        if (wWIcon.getToolTipOffset() != null) {
            vec42 = vec42.add3(wWIcon.getToolTipOffset());
        }
        OrderedText orderedText = new OrderedText(wWIcon.getToolTipText(), wWIcon.getToolTipFont(), vec42, wWIcon.getToolTipTextColor(), 0.0);
        drawContext.addOrderedRenderable(orderedText);
    }

    protected void beginDrawIcons(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        this.oglStackHandler.clear();
        int n = 30977;
        this.oglStackHandler.pushAttrib(gL, n);
        if (!drawContext.isDeepPickingEnabled()) {
            gL.glEnable(2929);
        }
        gL.glDepthMask(false);
        gL.glEnable(3008);
        gL.glAlphaFunc(516, 0.001f);
        this.oglStackHandler.pushProjectionIdentity(gL);
        gL.glOrtho(0.0, (double)drawContext.getView().getViewport().width, 0.0, (double)drawContext.getView().getViewport().height, -1.0, 1.0);
        this.oglStackHandler.pushModelview(gL);
        this.oglStackHandler.pushTexture(gL);
        if (drawContext.isPickingMode()) {
            this.pickSupport.beginPicking(drawContext);
            gL.glEnable(3553);
            gL.glTexEnvf(8960, 8704, 34160.0f);
            gL.glTexEnvf(8960, 34176, 34168.0f);
            gL.glTexEnvf(8960, 34161, 7681.0f);
        } else {
            gL.glEnable(3553);
            gL.glEnable(3042);
            gL.glBlendFunc(1, 771);
        }
    }

    protected void endDrawIcons(DrawContext drawContext) {
        if (drawContext.isPickingMode()) {
            this.pickSupport.endPicking(drawContext);
        }
        GL gL = drawContext.getGL();
        if (drawContext.isPickingMode()) {
            gL.glTexEnvf(8960, 8704, 8448.0f);
            gL.glTexEnvf(8960, 34176, 5890.0f);
            gL.glTexEnvf(8960, 34161, 8448.0f);
        }
        gL.glBindTexture(3553, 0);
        this.oglStackHandler.pop(drawContext.getGL());
    }

    protected void drawIconsInBatch(DrawContext drawContext, OrderedIcon orderedIcon) {
        this.drawIcon(drawContext, orderedIcon);
        OrderedRenderable orderedRenderable = drawContext.peekOrderedRenderables();
        while (orderedRenderable != null && orderedRenderable instanceof OrderedIcon) {
            OrderedIcon orderedIcon2 = (OrderedIcon)orderedRenderable;
            if (orderedIcon2.getRenderer() != this) {
                return;
            }
            drawContext.pollOrderedRenderables();
            this.drawIcon(drawContext, orderedIcon2);
            orderedRenderable = drawContext.peekOrderedRenderables();
        }
    }

    protected void pickIconsInBatch(DrawContext drawContext, OrderedIcon orderedIcon) {
        this.drawIcon(drawContext, orderedIcon);
        OrderedRenderable orderedRenderable = drawContext.peekOrderedRenderables();
        while (orderedRenderable != null && orderedRenderable instanceof OrderedIcon && ((OrderedIcon)orderedRenderable).layer == orderedIcon.layer) {
            OrderedIcon orderedIcon2 = (OrderedIcon)orderedRenderable;
            if (orderedIcon2.getRenderer() != this) {
                return;
            }
            drawContext.pollOrderedRenderables();
            this.drawIcon(drawContext, orderedIcon2);
            orderedRenderable = drawContext.peekOrderedRenderables();
        }
    }

    protected Vec4 drawIcon(DrawContext drawContext, OrderedIcon orderedIcon) {
        Color color;
        double d;
        double d2;
        if (orderedIcon.point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            if (orderedIcon.icon != null) {
                this.recordFeedback(drawContext, orderedIcon.icon, null, null);
            }
            return null;
        }
        WWIcon wWIcon = orderedIcon.icon;
        if (drawContext.getView().getFrustumInModelCoordinates().getNear().distanceTo(orderedIcon.point) < 0.0) {
            this.recordFeedback(drawContext, wWIcon, orderedIcon.point, null);
            return null;
        }
        Vec4 vec4 = drawContext.getView().project(orderedIcon.point);
        if (vec4 == null) {
            this.recordFeedback(drawContext, wWIcon, orderedIcon.point, null);
            return null;
        }
        if (this.pedestal != null) {
            d2 = this.pedestal.getScale();
            d = this.pedestal.getSpacingPixels();
        } else {
            d2 = 0.0;
            d = 0.0;
        }
        GL gL = drawContext.getGL();
        this.setDepthFunc(drawContext, orderedIcon, vec4);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        Dimension dimension = wWIcon.getSize();
        double d3 = dimension != null ? dimension.getWidth() : (double)wWIcon.getImageTexture().getWidth(drawContext);
        double d4 = dimension != null ? dimension.getHeight() : (double)wWIcon.getImageTexture().getHeight(drawContext);
        gL.glTranslated(vec4.x - d3 / 2.0, vec4.y + d2 * d4 + d, 0.0);
        if (wWIcon.isHighlighted()) {
            double d5 = this.pedestal != null ? 0.0 : d4 / 2.0;
            gL.glTranslated(d3 / 2.0, d5, 0.0);
            gL.glScaled(wWIcon.getHighlightScale(), wWIcon.getHighlightScale(), wWIcon.getHighlightScale());
            gL.glTranslated(-d3 / 2.0, -d5, 0.0);
        }
        Rectangle rectangle = new Rectangle((int)(vec4.x - d3 / 2.0), (int)vec4.y, (int)d3, (int)(d4 + d2 * d4 + d));
        if (drawContext.isPickingMode()) {
            if (this.isPickFrustumClippingEnabled() && !drawContext.getPickFrustums().intersectsAny(rectangle)) {
                this.recordFeedback(drawContext, wWIcon, orderedIcon.point, rectangle);
                return vec4;
            }
            color = drawContext.getUniquePickColor();
            int n = color.getRGB();
            this.pickSupport.addPickableObject(n, wWIcon, orderedIcon.getPosition(), false);
            gL.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        }
        if (wWIcon.getBackgroundTexture() != null) {
            this.applyBackground(drawContext, wWIcon, vec4, d3, d4, d, d2);
        }
        if (wWIcon.getImageTexture().bind(drawContext)) {
            color = wWIcon.getImageTexture().getTexCoords();
            gL.glScaled(d3, d4, 1.0);
            drawContext.drawUnitQuad((TextureCoords)color);
        }
        if (this.pedestal != null && this.pedestal.getImageTexture() != null) {
            gL.glLoadIdentity();
            gL.glTranslated(vec4.x - d2 * (d3 / 2.0), vec4.y, 0.0);
            gL.glScaled(d3 * d2, d4 * d2, 1.0);
            if (this.pedestal.getImageTexture().bind(drawContext)) {
                color = this.pedestal.getImageTexture().getTexCoords();
                drawContext.drawUnitQuad((TextureCoords)color);
            }
        }
        this.recordFeedback(drawContext, wWIcon, orderedIcon.point, rectangle);
        return vec4;
    }

    protected void applyBackground(DrawContext drawContext, WWIcon wWIcon, Vec4 vec4, double d, double d2, double d3, double d4) {
        GL gL = drawContext.getGL();
        double d5 = wWIcon.getBackgroundScale();
        if (wWIcon.getBackgroundTexture() != null && wWIcon.getBackgroundTexture().bind(drawContext)) {
            TextureCoords textureCoords = wWIcon.getBackgroundTexture().getTexCoords();
            gL.glPushMatrix();
            gL.glLoadIdentity();
            double d6 = d5 * d;
            double d7 = d5 * d2;
            gL.glTranslated(0.0, d4 * d2 + d3, 0.0);
            gL.glTranslated(vec4.x - d6 / 2.0, vec4.y - (d7 - d2) / 2.0, 0.0);
            gL.glScaled(d6, d7, 1.0);
            drawContext.drawUnitQuad(textureCoords);
            gL.glPopMatrix();
        }
    }

    protected void setDepthFunc(DrawContext drawContext, OrderedIcon orderedIcon, Vec4 vec4) {
        GL gL = drawContext.getGL();
        if (orderedIcon.icon.isAlwaysOnTop()) {
            gL.glDepthFunc(519);
            return;
        }
        Position position = drawContext.getView().getEyePosition();
        if (position == null) {
            gL.glDepthFunc(519);
            return;
        }
        double d = position.getElevation();
        if (d < drawContext.getGlobe().getMaxElevation() * drawContext.getVerticalExaggeration()) {
            double d2 = vec4.z - 0.00391006472;
            d2 = d2 < 0.0 ? 0.0 : (d2 > 1.0 ? 1.0 : d2);
            gL.glDepthFunc(513);
            gL.glDepthRange(d2, d2);
        } else if (orderedIcon.eyeDistance > orderedIcon.horizonDistance) {
            gL.glDepthFunc(514);
            gL.glDepthRange(1.0, 1.0);
        } else {
            gL.glDepthFunc(519);
        }
    }

    public String toString() {
        return Logging.getMessage("layers.IconLayer.Name");
    }

    protected boolean isFeedbackEnabled(DrawContext drawContext, WWIcon wWIcon) {
        if (drawContext.isPickingMode()) {
            return false;
        }
        Boolean bl = (Boolean)wWIcon.getValue("gov.nasa.worldwind.avkey.FeedbackEnabled");
        return bl != null && bl != false;
    }

    protected void recordFeedback(DrawContext drawContext, WWIcon wWIcon, Vec4 vec4, Rectangle rectangle) {
        if (!this.isFeedbackEnabled(drawContext, wWIcon)) {
            return;
        }
        this.doRecordFeedback(drawContext, wWIcon, vec4, rectangle);
    }

    protected void doRecordFeedback(DrawContext drawContext, WWIcon wWIcon, Vec4 vec4, Rectangle rectangle) {
        wWIcon.setValue("gov.nasa.worldwind.avkey.FeedbackReferencePoint", vec4);
        wWIcon.setValue("gov.nasa.worldwind.avkey.FeedbackScreenBounds", rectangle);
    }

    protected class OrderedIcon
    implements OrderedRenderable,
    Locatable {
        protected WWIcon icon;
        protected Vec4 point;
        protected double eyeDistance;
        protected double horizonDistance;
        protected Layer layer;

        public OrderedIcon(WWIcon wWIcon, Vec4 vec4, Layer layer, double d, double d2) {
            this.icon = wWIcon;
            this.point = vec4;
            this.eyeDistance = d;
            this.horizonDistance = d2;
            this.layer = layer;
        }

        @Override
        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        @Override
        public Position getPosition() {
            return this.icon.getPosition();
        }

        public IconRenderer getRenderer() {
            return IconRenderer.this;
        }

        public Vec4 getPoint() {
            return this.point;
        }

        public WWIcon getIcon() {
            return this.icon;
        }

        public double getHorizonDistance() {
            return this.horizonDistance;
        }

        public Layer getLayer() {
            return this.layer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void render(DrawContext drawContext) {
            IconRenderer.this.beginDrawIcons(drawContext);
            try {
                IconRenderer.this.drawIconsInBatch(drawContext, this);
            }
            catch (WWRuntimeException wWRuntimeException) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingIcon", wWRuntimeException);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingIcon", exception);
            }
            finally {
                IconRenderer.this.endDrawIcons(drawContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pick(DrawContext drawContext, Point point) {
            IconRenderer.this.pickSupport.clearPickList();
            IconRenderer.this.beginDrawIcons(drawContext);
            try {
                if (IconRenderer.this.isAllowBatchPicking()) {
                    IconRenderer.this.pickIconsInBatch(drawContext, this);
                } else {
                    IconRenderer.this.drawIcon(drawContext, this);
                }
            }
            catch (WWRuntimeException wWRuntimeException) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingIcon", wWRuntimeException);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhilePickingIcon", exception);
            }
            finally {
                IconRenderer.this.endDrawIcons(drawContext);
                IconRenderer.this.pickSupport.resolvePick(drawContext, point, this.layer);
                IconRenderer.this.pickSupport.clearPickList();
            }
        }
    }

    protected class OrderedText
    implements OrderedRenderable {
        protected Font font;
        protected String text;
        protected Vec4 point;
        protected double eyeDistance;
        protected Point pickPoint;
        protected Layer layer;
        protected Color color;

        public OrderedText(String string, Font font, Vec4 vec4, Color color, double d) {
            this.text = string;
            this.font = font;
            this.point = vec4;
            this.eyeDistance = d;
            this.color = color;
        }

        public OrderedText(String string, Font font, Vec4 vec4, Point point, Layer layer, double d) {
            this.text = string;
            this.font = font;
            this.point = vec4;
            this.eyeDistance = d;
            this.pickPoint = point;
            this.layer = layer;
        }

        @Override
        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        @Override
        public void render(DrawContext drawContext) {
            ToolTipRenderer toolTipRenderer = this.getToolTipRenderer(drawContext);
            toolTipRenderer.render(drawContext, this.text, (int)this.point.x, (int)this.point.y);
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
        }

        protected ToolTipRenderer getToolTipRenderer(DrawContext drawContext) {
            ToolTipRenderer toolTipRenderer;
            ToolTipRenderer toolTipRenderer2 = toolTipRenderer = this.font != null ? new ToolTipRenderer(this.font) : new ToolTipRenderer();
            if (this.color != null) {
                toolTipRenderer.setTextColor(this.color);
                toolTipRenderer.setOutlineColor(this.color);
                toolTipRenderer.setInteriorColor(ToolTipRenderer.getContrastingColor(this.color));
            } else {
                toolTipRenderer.setUseSystemLookAndFeel(true);
            }
            return toolTipRenderer;
        }
    }
}

