/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.FramebufferTexture;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import java.nio.Buffer;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class FBOTexture
extends FramebufferTexture {
    public FBOTexture(WWTexture wWTexture, Sector sector, List<LatLon> list) {
        super(wWTexture, sector, list);
        this.width = 1024;
        this.height = 1024;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Texture initializeTexture(DrawContext drawContext) {
        if (this.sourceTexture == null || !this.sourceTexture.bind(drawContext)) {
            return null;
        }
        if (this.sourceTexture.getWidth(drawContext) < 1 || this.sourceTexture.getHeight(drawContext) < 1) {
            return null;
        }
        int n = Math.min(drawContext.getGLRuntimeCapabilities().getMaxTextureSize(), 4096);
        this.width = Math.min(n, this.sourceTexture.getWidth(drawContext));
        this.height = Math.min(n, this.sourceTexture.getHeight(drawContext));
        GL gL = GLContext.getCurrent().getGL();
        int[] nArray = new int[1];
        gL.glGetIntegerv(36006, nArray, 0);
        int[] nArray2 = new int[1];
        gL.glGenFramebuffersEXT(1, nArray2, 0);
        try {
            gL.glBindFramebufferEXT(36160, nArray2[0]);
            TextureData textureData = new TextureData(6408, this.width, this.height, 0, 6408, 5121, false, false, true, (Buffer)BufferUtil.newByteBuffer((int)(this.width * this.height * 4)), null);
            Texture texture = TextureIO.newTexture((TextureData)textureData);
            texture.bind();
            gL.glTexParameteri(3553, 10241, 9729);
            gL.glTexParameteri(3553, 10240, 9729);
            gL.glTexParameteri(3553, 10242, 33071);
            gL.glTexParameteri(3553, 10243, 33071);
            gL.glFramebufferTexture2DEXT(36160, 36064, 3553, texture.getTextureObject(), 0);
            int n2 = gL.glCheckFramebufferStatusEXT(36160);
            if (n2 != 36053) {
                String string = Logging.getMessage("FBOTexture.TextureNotCreated");
                throw new IllegalStateException(string);
            }
            this.generateTexture(drawContext, this.width, this.height);
            drawContext.getTextureCache().put(this, texture);
            Texture texture2 = texture;
            return texture2;
        }
        finally {
            gL.glBindFramebufferEXT(36160, nArray[0]);
            gL.glDeleteFramebuffersEXT(1, nArray2, 0);
        }
    }
}

