/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.j2d.TextRenderer;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DeclutterableText;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLTextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class DeclutteringTextRenderer {
    protected static final Font DEFAULT_FONT = Font.decode("Arial-PLAIN-12");
    protected static final Color DEFAULT_COLOR = Color.white;
    protected final GLU glu = new GLU();
    protected boolean hasJOGLv111Bug = false;

    public Font getDefaultFont() {
        return DEFAULT_FONT;
    }

    public TextRenderer getTextRenderer(DrawContext drawContext, Font font) {
        return OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
    }

    public void render(DrawContext drawContext, Iterable<? extends GeographicText> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        Iterator<? extends GeographicText> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        Frustum frustum = drawContext.getView().getFrustumInModelCoordinates();
        double d = drawContext.getView().getHorizonDistance();
        while (iterator.hasNext()) {
            double d2;
            Vec4 vec4;
            GeographicText geographicText = iterator.next();
            if (!DeclutteringTextRenderer.isTextValid(geographicText, true) || !geographicText.isVisible()) continue;
            Angle angle = geographicText.getPosition().getLatitude();
            Angle angle2 = geographicText.getPosition().getLongitude();
            if (!drawContext.getVisibleSector().contains(angle, angle2) || (vec4 = sectorGeometryList.getSurfacePoint(angle, angle2, geographicText.getPosition().getElevation() * drawContext.getVerticalExaggeration())) == null || (d2 = drawContext.getView().getEyePoint().distanceTo3(vec4)) > d || !frustum.contains(vec4)) continue;
            drawContext.addOrderedRenderable(new DeclutterableText(geographicText, vec4, d2, this));
        }
    }

    protected void beginRendering(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        int n = 30977;
        gL.glPushAttrib(n);
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        this.glu.gluOrtho2D(0.0, (double)drawContext.getView().getViewport().width, 0.0, (double)drawContext.getView().getViewport().height);
        gL.glMatrixMode(5890);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glEnable(2929);
        gL.glDepthMask(false);
        gL.glDisable(2884);
        gL.glEnable(3008);
        gL.glAlphaFunc(516, 0.001f);
    }

    protected void endRendering(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glMatrixMode(5890);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vec4 drawText(DrawContext drawContext, DeclutterableText declutterableText, double d, double d2) throws Exception {
        if (declutterableText.getPoint() == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().fine(string);
            return null;
        }
        GeographicText geographicText = declutterableText.getText();
        GL gL = drawContext.getGL();
        CharSequence charSequence = geographicText.getText();
        if (charSequence == null) {
            return null;
        }
        Vec4 vec4 = drawContext.getView().project(declutterableText.getPoint());
        if (vec4 == null) {
            return null;
        }
        Font font = geographicText.getFont();
        if (font == null) {
            font = DEFAULT_FONT;
        }
        TextRenderer textRenderer = this.getTextRenderer(drawContext, font);
        this.beginRendering(drawContext);
        try {
            textRenderer.begin3DRendering();
            this.setDepthFunc(drawContext, vec4);
            Rectangle2D rectangle2D = declutterableText.getBounds(drawContext);
            if (rectangle2D == null) {
                Vec4 vec42 = null;
                return vec42;
            }
            Point2D.Float float_ = this.computeDrawPoint(rectangle2D, vec4);
            if (float_ != null) {
                Color color;
                if (d != 1.0) {
                    gL.glScaled(d, d, 1.0);
                    float_.setLocation(float_.x / (float)d, float_.y / (float)d);
                }
                if ((color = geographicText.getColor()) == null) {
                    color = DEFAULT_COLOR;
                }
                color = this.applyOpacity(color, d2);
                Color color2 = geographicText.getBackgroundColor();
                if (color2 != null) {
                    color2 = this.applyOpacity(color2, d2);
                    textRenderer.setColor(color2);
                    textRenderer.draw3D(charSequence, float_.x + 1.0f, float_.y - 1.0f, 0.0f, 1.0f);
                }
                textRenderer.setColor(color);
                textRenderer.draw3D(charSequence, float_.x, float_.y, 0.0f, 1.0f);
                textRenderer.flush();
                if (d != 1.0) {
                    gL.glLoadIdentity();
                }
            }
        }
        catch (Exception exception) {
            this.handleTextRendererExceptions(exception);
        }
        finally {
            textRenderer.end3DRendering();
            this.endRendering(drawContext);
        }
        return vec4;
    }

    protected void setDepthFunc(DrawContext drawContext, Vec4 vec4) {
        GL gL = drawContext.getGL();
        Position position = drawContext.getView().getEyePosition();
        if (position == null) {
            gL.glDepthFunc(519);
            return;
        }
        double d = position.getElevation();
        if (d < drawContext.getGlobe().getMaxElevation() * drawContext.getVerticalExaggeration()) {
            double d2 = vec4.z - 0.00391006472;
            d2 = d2 < 0.0 ? 0.0 : (d2 > 1.0 ? 1.0 : d2);
            gL.glDepthFunc(513);
            gL.glDepthRange(d2, d2);
        } else {
            gL.glDepthFunc(519);
        }
    }

    protected Point2D.Float computeDrawPoint(Rectangle2D rectangle2D, Vec4 vec4) {
        return new Point2D.Float((float)(vec4.x - rectangle2D.getWidth() / 2.0), (float)vec4.y);
    }

    protected static boolean isTextValid(GeographicText geographicText, boolean bl) {
        if (geographicText == null || geographicText.getText() == null) {
            return false;
        }
        return !bl || geographicText.getPosition() != null;
    }

    protected Color applyOpacity(Color color, double d) {
        if (d >= 1.0) {
            return color;
        }
        float[] fArray = color.getRGBComponents(null);
        return new Color(fArray[0], fArray[1], fArray[2], fArray[3] * (float)d);
    }

    protected Rectangle2D computeTextBounds(DrawContext drawContext, DeclutterableText declutterableText) throws Exception {
        GeographicText geographicText = declutterableText.getText();
        CharSequence charSequence = geographicText.getText();
        if (charSequence == null) {
            return null;
        }
        Vec4 vec4 = drawContext.getView().project(declutterableText.getPoint());
        if (vec4 == null) {
            return null;
        }
        Font font = geographicText.getFont();
        if (font == null) {
            font = this.getDefaultFont();
        }
        try {
            TextRenderer textRenderer = this.getTextRenderer(drawContext, font);
            Rectangle2D rectangle2D = textRenderer.getBounds(charSequence);
            double d = vec4.x - rectangle2D.getWidth() / 2.0;
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            ((Rectangle2D)float_).setRect(d, vec4.y, rectangle2D.getWidth(), rectangle2D.getHeight());
            return float_;
        }
        catch (Exception exception) {
            this.handleTextRendererExceptions(exception);
            return null;
        }
    }

    protected void handleTextRendererExceptions(Exception exception) throws Exception {
        if (exception instanceof IOException) {
            if (!this.hasJOGLv111Bug) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingText", exception);
                this.hasJOGLv111Bug = true;
            }
        } else {
            throw exception;
        }
    }
}

