/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OffsetsList;
import gov.nasa.worldwind.render.RigidShape;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.List;
import javax.media.opengl.GL;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Cylinder
extends RigidShape {
    protected static final int DEFAULT_SUBDIVISIONS = 2;
    protected int faceCount = 3;
    protected int subdivisions = 2;

    public Cylinder() {
        this.setUpGeometryCache();
    }

    public Cylinder(Position position, double d, double d2) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "height <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centerPosition = position;
        this.northSouthRadius = d2;
        this.verticalRadius = d / 2.0;
        this.eastWestRadius = d2;
        this.setUpGeometryCache();
    }

    public Cylinder(Position position, double d, double d2, double d3) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0 || d3 <= 0.0 || d2 <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centerPosition = position;
        this.northSouthRadius = d;
        this.verticalRadius = d2;
        this.eastWestRadius = d3;
        this.setUpGeometryCache();
    }

    public Cylinder(Position position, double d, double d2, double d3, Angle angle, Angle angle2, Angle angle3) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0 || d3 <= 0.0 || d2 <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centerPosition = position;
        this.northSouthRadius = d;
        this.verticalRadius = d2;
        this.eastWestRadius = d3;
        this.heading = angle;
        this.tilt = angle2;
        this.roll = angle3;
        this.setUpGeometryCache();
    }

    @Override
    public int getFaceCount() {
        return this.faceCount;
    }

    @Override
    public int getSubdivisions() {
        return this.subdivisions;
    }

    protected double computeDetailThreshold() {
        double d = 20.0;
        double d2 = 40.0;
        return d += this.getDetailHint() * d2;
    }

    @Override
    protected void computeSubdivisions(DrawContext drawContext, RigidShape.ShapeData shapeData) {
        int n = 0;
        int n2 = 6;
        if (shapeData.getExtent() != null) {
            for (int i = n; i <= n2; ++i) {
                this.subdivisions = i;
                if (this.sufficientDetail(drawContext, i, shapeData)) break;
            }
        }
    }

    protected boolean sufficientDetail(DrawContext drawContext, int n, RigidShape.ShapeData shapeData) {
        if (drawContext.getView() == null) {
            String string = "nullValue.DrawingContextViewIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "subdivisions < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (shapeData == null) {
            return false;
        }
        Extent extent = shapeData.getExtent();
        if (extent == null) {
            return true;
        }
        double d = this.computeDetailThreshold();
        double d2 = drawContext.getView().getEyePoint().distanceTo3(extent.getCenter());
        double d3 = extent.getDiameter() / d2;
        double d4 = Math.pow(n, 3.0) / d3;
        return d4 > d;
    }

    @Override
    protected boolean mustRegenerateGeometry(DrawContext drawContext) {
        int n = this.subdivisions;
        this.computeSubdivisions(drawContext, this.getCurrentShapeData());
        if (n != this.subdivisions) {
            return true;
        }
        return super.mustRegenerateGeometry(drawContext);
    }

    @Override
    protected void makeGeometry(RigidShape.ShapeData shapeData) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "Cylinder0", this.subdivisions);
        Geometry geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry == null) {
            this.makeUnitCylinder(this.subdivisions, shapeData.getMeshes());
            for (int i = 0; i < this.getFaceCount(); ++i) {
                if (this.offsets.get(i) == null) {
                    this.offsets.put(i, new OffsetsList());
                }
                cacheKey = new Geometry.CacheKey(this.getClass(), "Cylinder" + i, this.subdivisions);
                this.getGeometryCache().add(cacheKey, shapeData.getMesh(i));
            }
        } else {
            for (int i = 0; i < this.getFaceCount(); ++i) {
                if (this.offsets.get(i) == null) {
                    this.offsets.put(i, new OffsetsList());
                }
                cacheKey = new Geometry.CacheKey(this.getClass(), "Cylinder" + i, this.subdivisions);
                geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
                shapeData.addMesh(i, geometry);
            }
        }
    }

    protected void makeUnitCylinder(int n, List<Geometry> list) {
        float f = 1.0f;
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(0);
        for (int i = 0; i < this.getFaceCount(); ++i) {
            GeometryBuilder.IndexedTriangleBuffer indexedTriangleBuffer = geometryBuilder.tessellateCylinderBuffer(i, f, n);
            FloatBuffer floatBuffer = BufferUtil.newFloatBuffer((int)(3 * indexedTriangleBuffer.getVertexCount()));
            if (i == 0 || i == 1) {
                geometryBuilder.makeIndexedTriangleBufferNormals(indexedTriangleBuffer, floatBuffer);
            } else {
                geometryBuilder.makeCylinderNormals(indexedTriangleBuffer, floatBuffer);
            }
            FloatBuffer floatBuffer2 = BufferUtil.newFloatBuffer((int)(2 * indexedTriangleBuffer.getVertexCount()));
            geometryBuilder.makeUnitCylinderTextureCoordinates(i, floatBuffer2, n);
            Geometry geometry = new Geometry();
            geometry.setElementData(4, indexedTriangleBuffer.getIndexCount(), indexedTriangleBuffer.getIndices());
            geometry.setVertexData(indexedTriangleBuffer.getVertexCount(), indexedTriangleBuffer.getVertices());
            geometry.setNormalData(floatBuffer.limit(), floatBuffer);
            geometry.setTextureCoordData(floatBuffer2.limit(), floatBuffer2);
            list.add(i, geometry);
        }
    }

    @Override
    protected void drawGeometry(DrawContext drawContext, int n, int n2, int n3, Buffer buffer, RigidShape.ShapeData shapeData, int n4) {
        if (buffer == null) {
            String string = "nullValue.ElementBufferIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Geometry geometry = shapeData.getMesh(n4);
        if (geometry.getBuffer(2) == null) {
            String string = "nullValue.VertexBufferIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        int n5 = geometry.getSize(2);
        int n6 = geometry.getGLType(2);
        int n7 = geometry.getStride(2);
        Buffer buffer2 = geometry.getBuffer(2);
        Buffer buffer3 = null;
        if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, null)) {
            buffer3 = geometry.getBuffer(3);
            if (buffer3 == null) {
                gL.glDisableClientState(32885);
            } else {
                n6 = geometry.getGLType(3);
                n7 = geometry.getStride(3);
                gL.glNormalPointer(n6, n7, buffer3);
            }
        }
        boolean bl = drawContext.getGLRuntimeCapabilities().isVertexBufferObjectEnabled();
        if (this.shouldUseVBOs(drawContext) && this.getVboIds(this.getSubdivisions(), drawContext) != null) {
            gL.glBindBuffer(34962, this.getVboIds(this.getSubdivisions(), drawContext)[2 * n4]);
            gL.glBindBuffer(34963, this.getVboIds(this.getSubdivisions(), drawContext)[2 * n4 + 1]);
            gL.glVertexPointer(n5, n6, n7, 0L);
            gL.glDrawElements(n, n2, n3, 0L);
            gL.glBindBuffer(34962, 0);
            gL.glBindBuffer(34963, 0);
        } else {
            gL.glVertexPointer(n5, n6, n7, buffer2.rewind());
            gL.glDrawElements(n, n2, n3, buffer);
        }
        gL.glDisable(32826);
        drawContext.getGLRuntimeCapabilities().setVertexBufferObjectEnabled(bl);
        if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, null) && buffer3 == null) {
            gL.glEnableClientState(32885);
        }
    }

    @Override
    protected RigidShape.ShapeData createIntersectionGeometry(Terrain terrain) {
        RigidShape.ShapeData shapeData = new RigidShape.ShapeData(null, this);
        shapeData.setGlobeStateKey(terrain.getGlobe().getGlobeStateKey());
        this.makeUnitCylinder(6, shapeData.getMeshes());
        Matrix matrix = this.computeRenderMatrix(terrain.getGlobe(), terrain.getVerticalExaggeration());
        for (int i = 0; i < this.getFaceCount(); ++i) {
            Geometry geometry = shapeData.getMesh(i);
            FloatBuffer floatBuffer = this.computeTransformedVertices((FloatBuffer)geometry.getBuffer(2), geometry.getCount(2), matrix);
            geometry.setVertexData(geometry.getCount(2), floatBuffer);
        }
        shapeData.setReferencePoint(this.computeReferencePoint(terrain.getGlobe(), terrain.getVerticalExaggeration()));
        shapeData.setExtent(this.getExtent(terrain.getGlobe(), terrain.getVerticalExaggeration()));
        return shapeData;
    }

    @Override
    public String isExportFormatSupported(String string) {
        return "Export.FormatNotSupported";
    }

    @Override
    protected void doExportAsKML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        String string = Logging.getMessage("generic.UnsupportedOperation", "doExportAsKML");
        Logging.logger().severe(string);
        throw new UnsupportedOperationException(string);
    }
}

