/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.ogc.ows.OWSCodeType;
import gov.nasa.worldwind.ogc.ows.OWSDescription;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OWSServiceIdentification
extends OWSDescription {
    protected QName SERVICE_TYPE_VERSION;
    protected QName PROFILE;
    protected QName ACCESS_CONSTRAINTS;
    protected List<String> serviceTypeVersions = new ArrayList<String>();
    protected List<String> profiles = new ArrayList<String>();
    protected List<String> accessConstraints = new ArrayList<String>();

    public OWSServiceIdentification(String string) {
        super(string);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.SERVICE_TYPE_VERSION = new QName(this.getNamespaceURI(), "ServiceTypeVersion");
        this.PROFILE = new QName(this.getNamespaceURI(), "Profile");
        this.ACCESS_CONSTRAINTS = new QName(this.getNamespaceURI(), "AccessConstraints");
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.SERVICE_TYPE_VERSION)) {
            this.addServiceTypeVersion((String)object);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.PROFILE)) {
            this.addProfile((String)object);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.ACCESS_CONSTRAINTS)) {
            this.addAccessConstraints((String)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void addServiceTypeVersion(String string) {
        this.serviceTypeVersions.add(string);
    }

    protected void addProfile(String string) {
        this.profiles.add(string);
    }

    protected void addAccessConstraints(String string) {
        this.accessConstraints.add(string);
    }

    public OWSCodeType getServiceType() {
        return (OWSCodeType)this.getField("ServiceType");
    }

    public List<String> getServiceTypeVersions() {
        return this.serviceTypeVersions;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public String getFees() {
        return (String)this.getField("Fees");
    }

    public List<String> getAccessConstraints() {
        return this.accessConstraints;
    }
}

