/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.ogc.ows.OWSDomain;
import gov.nasa.worldwind.ogc.ows.OWSOperation;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OWSOperationsMetadata
extends AbstractXMLEventParser {
    protected QName PARAMETER;
    protected QName CONSTRAINT;
    protected List<OWSOperation> operations = new ArrayList<OWSOperation>();
    protected List<OWSDomain> parameters = new ArrayList<OWSDomain>();
    protected List<OWSDomain> constraints = new ArrayList<OWSDomain>();

    public OWSOperationsMetadata(String string) {
        super(string);
        this.initialize();
    }

    protected void initialize() {
        this.PARAMETER = new QName(this.getNamespaceURI(), "Parameter");
        this.CONSTRAINT = new QName(this.getNamespaceURI(), "Constraint");
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.PARAMETER)) {
            this.addParameter((OWSDomain)object);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.CONSTRAINT)) {
            this.addConstraint((OWSDomain)object);
        } else if (object instanceof OWSOperation) {
            this.addOperation((OWSOperation)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void addOperation(OWSOperation oWSOperation) {
        this.operations.add(oWSOperation);
    }

    protected void addParameter(OWSDomain oWSDomain) {
        this.parameters.add(oWSDomain);
    }

    protected void addConstraint(OWSDomain oWSDomain) {
        this.constraints.add(oWSDomain);
    }

    public List<OWSOperation> getOperations() {
        return this.operations;
    }

    public List<OWSDomain> getParameters() {
        return this.parameters;
    }

    public List<OWSDomain> getConstraints() {
        return this.constraints;
    }

    public Object getExtendedCapabilities() {
        return this.getField("ExtendedCapabilities");
    }
}

