/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.ogc.ows.OWSDCPType;
import gov.nasa.worldwind.ogc.ows.OWSDomain;
import gov.nasa.worldwind.ogc.ows.OWSMetadata;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OWSOperation
extends AbstractXMLEventParser {
    protected QName PARAMETER;
    protected QName CONSTRAINT;
    protected List<OWSDCPType> dcpTypes = new ArrayList<OWSDCPType>();
    protected List<OWSDomain> parameters = new ArrayList<OWSDomain>();
    protected List<OWSDomain> constraints = new ArrayList<OWSDomain>();
    protected List<OWSMetadata> metadata = new ArrayList<OWSMetadata>();

    public OWSOperation(String string) {
        super(string);
        this.initialize();
    }

    protected void initialize() {
        this.PARAMETER = new QName(this.getNamespaceURI(), "Parameter");
        this.CONSTRAINT = new QName(this.getNamespaceURI(), "Constraint");
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.PARAMETER)) {
            this.addParameter((OWSDomain)object);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.CONSTRAINT)) {
            this.addConstraint((OWSDomain)object);
        } else if (object instanceof OWSDCPType) {
            this.addDCPType((OWSDCPType)object);
        } else if (object instanceof OWSMetadata) {
            this.addMetadata((OWSMetadata)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void addDCPType(OWSDCPType oWSDCPType) {
        this.dcpTypes.add(oWSDCPType);
    }

    protected void addParameter(OWSDomain oWSDomain) {
        this.parameters.add(oWSDomain);
    }

    protected void addConstraint(OWSDomain oWSDomain) {
        this.constraints.add(oWSDomain);
    }

    protected void addMetadata(OWSMetadata oWSMetadata) {
        this.metadata.add(oWSMetadata);
    }

    public List<OWSDCPType> getDCPTypes() {
        return this.dcpTypes;
    }

    public List<OWSDomain> getParameters() {
        return this.parameters;
    }

    public List<OWSDomain> getConstraints() {
        return this.constraints;
    }

    public List<OWSMetadata> getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return (String)this.getField("name");
    }
}

