/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;

public class OWSException
extends AbstractXMLEventParser {
    protected QName EXCEPTION_TEXT;
    protected List<String> exceptionText = new ArrayList<String>();

    public OWSException() {
        super("http://www.opengis.net/ows/1.1");
        this.initialize();
    }

    public OWSException(String string) {
        super(string);
        this.initialize();
    }

    protected void initialize() {
        this.EXCEPTION_TEXT = new QName(this.getNamespaceURI(), "ExceptionText");
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.EXCEPTION_TEXT)) {
            this.addExceptionText((String)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    public String getExceptionCode() {
        return (String)this.getField("exceptionCode");
    }

    public void setExceptionCode(String string) {
        this.setField("exceptionCode", (Object)string);
    }

    public String getLocator() {
        return (String)this.getField("locator");
    }

    public void setLocator(String string) {
        this.setField("locator", (Object)string);
    }

    public List<String> getExceptionText() {
        return this.exceptionText;
    }

    public void setExceptionText(List<String> list) {
        this.exceptionText = list;
    }

    public void addExceptionText(String string) {
        if (this.getExceptionText() != null && !WWUtil.isEmpty(string)) {
            this.getExceptionText().add(string);
        }
    }

    public void export(Object object) throws XMLStreamException {
        XMLStreamWriter xMLStreamWriter;
        if (object == null) {
            String string = Logging.getMessage("nullValue.OutputIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
        } else {
            xMLStreamWriter = WWXML.openStreamWriter(object);
            bl = true;
        }
        if (xMLStreamWriter == null) {
            String string = Logging.getMessage("Export.UnsupportedOutputObject", object);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        xMLStreamWriter.setDefaultNamespace(this.getNamespaceURI());
        xMLStreamWriter.writeStartElement("Exception");
        if (!WWUtil.isEmpty(this.getExceptionCode())) {
            xMLStreamWriter.writeAttribute("exceptionCode", this.getExceptionCode());
        }
        if (!WWUtil.isEmpty(this.getLocator())) {
            xMLStreamWriter.writeAttribute("locator", this.getLocator());
        }
        if (this.getExceptionText() != null) {
            for (String string : this.getExceptionText()) {
                try {
                    xMLStreamWriter.writeStartElement("ExceptionText");
                    xMLStreamWriter.writeCharacters(string);
                    xMLStreamWriter.writeEndElement();
                }
                catch (Exception exception) {
                    Logging.logger().log(Level.WARNING, Logging.getMessage("Export.UnableToExportObject", string), exception);
                }
            }
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }
}

