/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OWSAddress
extends AbstractXMLEventParser {
    protected QName DELIVERY_POINT;
    protected QName ELECTRONIC_MAIL_ADDRESS;
    protected List<String> deliveryPoints = new ArrayList<String>();
    protected List<String> emailAddresses = new ArrayList<String>();

    public OWSAddress(String string) {
        super(string);
        this.initialize();
    }

    protected void initialize() {
        this.DELIVERY_POINT = new QName(this.getNamespaceURI(), "DeliveryPoint");
        this.ELECTRONIC_MAIL_ADDRESS = new QName(this.getNamespaceURI(), "ElectronicMailAddress");
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.DELIVERY_POINT)) {
            this.addDeliveryPoint((String)object);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.ELECTRONIC_MAIL_ADDRESS)) {
            this.addElectronicMailAddress((String)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void addDeliveryPoint(String string) {
        this.deliveryPoints.add(string);
    }

    protected void addElectronicMailAddress(String string) {
        this.emailAddresses.add(string);
    }

    public List<String> getDeliveryPoints() {
        return this.deliveryPoints;
    }

    public String getCity() {
        return (String)this.getField("City");
    }

    public String getAdministrativeArea() {
        return (String)this.getField("AdministrativeArea");
    }

    public String getPostalCode() {
        return (String)this.getField("PostalCode");
    }

    public String getCountry() {
        return (String)this.getField("Country");
    }

    public List<String> getElectronicMailAddresses() {
        return this.emailAddresses;
    }
}

