/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.impl;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.ogc.collada.ColladaResourceResolver;
import gov.nasa.worldwind.ogc.collada.ColladaRoot;
import gov.nasa.worldwind.ogc.collada.impl.ColladaTraversalContext;
import gov.nasa.worldwind.ogc.kml.KMLAbstractGeometry;
import gov.nasa.worldwind.ogc.kml.KMLAlias;
import gov.nasa.worldwind.ogc.kml.KMLLink;
import gov.nasa.worldwind.ogc.kml.KMLModel;
import gov.nasa.worldwind.ogc.kml.KMLOrientation;
import gov.nasa.worldwind.ogc.kml.KMLPlacemark;
import gov.nasa.worldwind.ogc.kml.KMLResourceMap;
import gov.nasa.worldwind.ogc.kml.KMLScale;
import gov.nasa.worldwind.ogc.kml.impl.KMLRenderable;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.ogc.kml.impl.KMLUtil;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.stream.XMLStreamException;

public class KMLModelPlacemarkImpl
extends WWObjectImpl
implements KMLRenderable,
ColladaResourceResolver {
    protected KMLModel model;
    protected KMLPlacemark parent;
    protected AtomicReference<ColladaRoot> colladaRoot = new AtomicReference();
    protected AtomicLong resourceRetrievalTime = new AtomicLong(-1L);
    protected Map<String, String> resourceMap;
    protected ColladaTraversalContext colladaTraversalContext = new ColladaTraversalContext();

    public KMLModelPlacemarkImpl(KMLTraversalContext kMLTraversalContext, KMLPlacemark kMLPlacemark, KMLAbstractGeometry kMLAbstractGeometry) {
        if (kMLTraversalContext == null) {
            String string = Logging.getMessage("nullValue.TraversalContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (kMLPlacemark == null) {
            String string = Logging.getMessage("nullValue.ParentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (kMLAbstractGeometry == null) {
            String string = Logging.getMessage("nullValue.GeometryIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.model = (KMLModel)kMLAbstractGeometry;
        this.parent = kMLPlacemark;
        this.resourceMap = this.createResourceMap(this.model);
    }

    protected Map<String, String> createResourceMap(KMLModel kMLModel) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        KMLResourceMap kMLResourceMap = kMLModel.getResourceMap();
        if (kMLResourceMap == null) {
            return Collections.emptyMap();
        }
        for (KMLAlias kMLAlias : kMLResourceMap.getAliases()) {
            if (kMLAlias == null || WWUtil.isEmpty(kMLAlias.getSourceRef()) || WWUtil.isEmpty(kMLAlias.getTargetHref())) continue;
            hashMap.put(kMLAlias.getSourceRef(), kMLAlias.getTargetHref());
        }
        return hashMap.size() > 0 ? hashMap : Collections.emptyMap();
    }

    protected void setColladaRoot(ColladaRoot colladaRoot) {
        if (colladaRoot != null) {
            this.configureColladaRoot(colladaRoot);
        }
        this.colladaRoot.set(colladaRoot);
    }

    protected ColladaRoot getColladaRoot() {
        return this.colladaRoot.get();
    }

    protected void configureColladaRoot(ColladaRoot colladaRoot) {
        Object object;
        colladaRoot.setResourceResolver(this);
        Position position = this.model.getLocation().getPosition();
        colladaRoot.setPosition(position);
        colladaRoot.setAltitudeMode(KMLUtil.convertAltitudeMode(this.model.getAltitudeMode()));
        KMLOrientation kMLOrientation = this.model.getOrientation();
        if (kMLOrientation != null) {
            object = kMLOrientation.getHeading();
            if (object != null) {
                colladaRoot.setHeading(Angle.fromDegrees((Double)object));
            }
            if ((object = kMLOrientation.getTilt()) != null) {
                colladaRoot.setPitch(Angle.fromDegrees(-((Double)object).doubleValue()));
            }
            if ((object = kMLOrientation.getRoll()) != null) {
                colladaRoot.setRoll(Angle.fromDegrees(-((Double)object).doubleValue()));
            }
        }
        if ((object = this.model.getScale()) != null) {
            Double d = ((KMLScale)object).getX();
            Double d2 = ((KMLScale)object).getY();
            Double d3 = ((KMLScale)object).getZ();
            Vec4 vec4 = new Vec4(d != null ? d : 1.0, d2 != null ? d2 : 1.0, d3 != null ? d3 : 1.0);
            colladaRoot.setModelScale(vec4);
        }
    }

    @Override
    public void preRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        ColladaRoot colladaRoot;
        if (this.mustRetrieveResource()) {
            this.requestResource(drawContext);
        }
        if ((colladaRoot = this.getColladaRoot()) != null) {
            this.colladaTraversalContext.initialize();
            colladaRoot.preRender(this.colladaTraversalContext, drawContext);
        }
    }

    @Override
    public void render(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        ColladaRoot colladaRoot = this.getColladaRoot();
        if (colladaRoot != null) {
            this.colladaTraversalContext.initialize();
            colladaRoot.render(this.colladaTraversalContext, drawContext);
        }
    }

    @Override
    public String resolveFilePath(String string) throws IOException {
        Object object;
        File file;
        KMLLink kMLLink = this.model.getLink();
        String string2 = this.resourceMap.get(string);
        if (string2 != null) {
            string = string2;
        }
        if (!(file = new File(string)).isAbsolute() && kMLLink != null && kMLLink.getHref() != null) {
            try {
                object = new URI(null, kMLLink.getHref(), null);
                URI uRI = new URI(null, string, null);
                string = ((URI)object).resolve(uRI).getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if ((object = this.parent.getRoot().resolveReference(string)) instanceof URL || object instanceof String) {
            return object.toString();
        }
        return null;
    }

    protected boolean mustRetrieveResource() {
        KMLLink kMLLink = this.model.getLink();
        if (kMLLink == null) {
            return false;
        }
        return this.getColladaRoot() == null || kMLLink.getUpdateTime() > this.resourceRetrievalTime.get();
    }

    protected void requestResource(DrawContext drawContext) {
        if (WorldWind.getTaskService().isFull()) {
            return;
        }
        KMLLink kMLLink = this.model.getLink();
        if (kMLLink == null) {
            return;
        }
        String string = kMLLink.getAddress(drawContext);
        if (string != null) {
            string = string.trim();
        }
        if (WWUtil.isEmpty(string)) {
            return;
        }
        WorldWind.getTaskService().addTask(new RequestTask(this, string));
    }

    protected void retrieveModel(String string) throws IOException, XMLStreamException {
        Object object = this.parent.getRoot().resolveReference(string);
        if (object == null) {
            return;
        }
        ColladaRoot colladaRoot = ColladaRoot.createAndParse(object);
        if (colladaRoot == null) {
            return;
        }
        this.setColladaRoot(colladaRoot);
        this.resourceRetrievalTime.set(System.currentTimeMillis());
        this.parent.getRoot().requestRedraw();
    }

    protected static class RequestTask
    implements Runnable {
        protected final KMLModelPlacemarkImpl placemark;
        protected final String address;

        protected RequestTask(KMLModelPlacemarkImpl kMLModelPlacemarkImpl, String string) {
            if (kMLModelPlacemarkImpl == null) {
                String string2 = Logging.getMessage("nullValue.ObjectIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            if (string == null) {
                String string3 = Logging.getMessage("nullValue.PathIsNull");
                Logging.logger().severe(string3);
                throw new IllegalArgumentException(string3);
            }
            this.placemark = kMLModelPlacemarkImpl;
            this.address = string;
        }

        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            try {
                this.placemark.retrieveModel(this.address);
            }
            catch (IOException iOException) {
                String string = Logging.getMessage("generic.ExceptionWhileReading", iOException.getMessage());
                Logging.logger().warning(string);
            }
            catch (XMLStreamException xMLStreamException) {
                String string = Logging.getMessage("generic.ExceptionAttemptingToParseXml", xMLStreamException.getMessage());
                Logging.logger().warning(string);
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            if (!this.address.equals(requestTask.address)) {
                return false;
            }
            return this.placemark.equals(requestTask.placemark);
        }

        public int hashCode() {
            int n = this.placemark.hashCode();
            n = 31 * n + this.address.hashCode();
            return n;
        }

        public String toString() {
            return this.address;
        }
    }
}

