/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.impl;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLBalloonStyle;
import gov.nasa.worldwind.ogc.kml.KMLData;
import gov.nasa.worldwind.ogc.kml.KMLExtendedData;
import gov.nasa.worldwind.ogc.kml.KMLSchema;
import gov.nasa.worldwind.ogc.kml.KMLSchemaData;
import gov.nasa.worldwind.ogc.kml.KMLSimpleData;
import gov.nasa.worldwind.ogc.kml.impl.KMLBalloonTextDecoder;
import gov.nasa.worldwind.render.AbstractBrowserBalloon;
import gov.nasa.worldwind.render.Balloon;
import gov.nasa.worldwind.render.BalloonAttributes;
import gov.nasa.worldwind.render.BasicBalloonAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.TextDecoder;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.webview.WebResourceResolver;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public abstract class KMLAbstractBalloon
implements Balloon,
WebResourceResolver,
PropertyChangeListener {
    public static final String DISPLAY_MODE_HIDE = "hide";
    public static final String DISPLAY_MODE_DEFAULT = "default";
    protected KMLAbstractFeature parent;
    protected String displayMode = "default";
    protected boolean usingDefaultText;
    protected boolean normalAttributesResolved;
    protected boolean highlightAttributesResolved;
    protected String normalText;
    protected String highlightText;

    public KMLAbstractBalloon(KMLAbstractFeature kMLAbstractFeature) {
        if (kMLAbstractFeature == null) {
            String string = Logging.getMessage("nullValue.FeatureIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.parent = kMLAbstractFeature;
    }

    protected void initialize(Balloon balloon) {
        balloon.setTextDecoder(this.createTextDecoder(this.parent));
        balloon.setValue("gov.nasa.worldwind.avkey.Context", this.parent);
        if (balloon instanceof AbstractBrowserBalloon) {
            ((AbstractBrowserBalloon)balloon).setResourceResolver(this);
        }
        balloon.addPropertyChangeListener(this);
    }

    protected abstract Balloon getBalloon();

    @Override
    public void render(DrawContext drawContext) {
        Balloon balloon = this.getBalloon();
        if (balloon.isHighlighted() && !this.highlightAttributesResolved) {
            this.makeAttributesCurrent("highlight");
        } else if (!this.normalAttributesResolved) {
            this.makeAttributesCurrent("normal");
        }
        this.determineActiveText();
        if (!WWUtil.isEmpty(this.getText()) && !DISPLAY_MODE_HIDE.equals(this.getDisplayMode())) {
            balloon.render(drawContext);
        }
    }

    protected void determineActiveText() {
        String string = null;
        if (this.isHighlighted()) {
            string = this.highlightText;
        }
        if (string == null) {
            string = this.normalText;
        }
        if (string != null && !string.equals(this.getText())) {
            this.setText(string);
        }
    }

    protected void makeAttributesCurrent(String string) {
        BalloonAttributes balloonAttributes = this.getInitialBalloonAttributes();
        KMLBalloonStyle kMLBalloonStyle = (KMLBalloonStyle)this.parent.getSubStyle(new KMLBalloonStyle(null), string);
        String string2 = kMLBalloonStyle.getDisplayMode();
        if (string2 != null) {
            this.setDisplayMode(string2);
        }
        this.assembleBalloonAttributes(kMLBalloonStyle, balloonAttributes);
        if (kMLBalloonStyle.hasField("gov.nasa.worldwind.avkey.Unresolved")) {
            balloonAttributes.setUnresolved(true);
        } else {
            balloonAttributes.setUnresolved(false);
        }
        if ("normal".equals(string)) {
            this.getBalloon().setAttributes(balloonAttributes);
            String string3 = kMLBalloonStyle.getText();
            if (string3 != null) {
                this.getBalloon().setText(string3);
                this.normalText = string3;
            } else if (!this.usingDefaultText) {
                string3 = this.createDefaultBalloonText();
                this.getBalloon().setText(string3);
                this.usingDefaultText = true;
                this.normalText = string3;
            }
            if (!balloonAttributes.isUnresolved() || !kMLBalloonStyle.hasFields()) {
                this.normalAttributesResolved = true;
            }
        } else {
            this.getBalloon().setHighlightAttributes(balloonAttributes);
            this.highlightText = kMLBalloonStyle.getText();
            if (!balloonAttributes.isUnresolved() || !kMLBalloonStyle.hasFields()) {
                this.highlightAttributesResolved = true;
            }
        }
    }

    protected String createDefaultBalloonText() {
        KMLExtendedData kMLExtendedData;
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.parent.getName();
        String string2 = this.parent.getDescription();
        if (!WWUtil.isEmpty(string)) {
            stringBuilder.append("<b>").append(string).append("</b>");
        }
        if (!WWUtil.isEmpty(string2)) {
            stringBuilder.append("<br/>").append(string2);
        }
        if ((kMLExtendedData = this.parent.getExtendedData()) != null) {
            List<KMLSchemaData> list;
            List<KMLData> list2 = kMLExtendedData.getData();
            if (list2 != null && !list2.isEmpty()) {
                this.createDefaultExtendedDataText(stringBuilder, list2);
            }
            if ((list = kMLExtendedData.getSchemaData()) != null && !list.isEmpty()) {
                this.createDefaultSchemaDataText(stringBuilder, list);
            }
        }
        return stringBuilder.toString();
    }

    protected void createDefaultExtendedDataText(StringBuilder stringBuilder, List<KMLData> list) {
        stringBuilder.append("<p/><table border=\"1\">");
        for (KMLData kMLData : list) {
            String string = kMLData.getValue();
            if (WWUtil.isEmpty(string)) continue;
            String string2 = kMLData.getName() != null ? kMLData.getName() : "";
            stringBuilder.append("<tr><td>$[").append(string2).append("/displayName]</td><td>").append(string).append("</td></tr>");
        }
        stringBuilder.append("</table>");
    }

    protected void createDefaultSchemaDataText(StringBuilder stringBuilder, List<KMLSchemaData> list) {
        stringBuilder.append("<p/><table border=\"1\">");
        for (KMLSchemaData kMLSchemaData : list) {
            KMLSchema kMLSchema = (KMLSchema)this.parent.getRoot().resolveReference(kMLSchemaData.getSchemaUrl());
            for (KMLSimpleData kMLSimpleData : kMLSchemaData.getSimpleData()) {
                String string = kMLSimpleData.getCharacters();
                if (WWUtil.isEmpty(string)) continue;
                String string2 = kMLSimpleData.getName() != null ? kMLSimpleData.getName() : "";
                stringBuilder.append("<tr><td>");
                if (kMLSchema != null && !WWUtil.isEmpty(kMLSchema.getName()) && !WWUtil.isEmpty(string2)) {
                    stringBuilder.append("$[").append(kMLSchema.getName()).append("/").append(string2).append("/displayName]");
                } else {
                    stringBuilder.append(string2);
                }
                stringBuilder.append("</td><td>").append(string).append("</td><td>");
            }
        }
        stringBuilder.append("</table>");
    }

    protected BalloonAttributes getInitialBalloonAttributes() {
        BalloonAttributes balloonAttributes;
        if (this.isHighlighted()) {
            balloonAttributes = this.getHighlightAttributes();
            if (balloonAttributes == null && this.getAttributes() != null) {
                balloonAttributes = new BasicBalloonAttributes(this.getAttributes());
            }
        } else {
            balloonAttributes = this.getAttributes();
        }
        if (balloonAttributes == null) {
            balloonAttributes = new BasicBalloonAttributes();
        }
        return balloonAttributes;
    }

    protected void assembleBalloonAttributes(KMLBalloonStyle kMLBalloonStyle, BalloonAttributes balloonAttributes) {
        String string;
        String string2 = kMLBalloonStyle.getBgColor();
        if (string2 == null) {
            string2 = kMLBalloonStyle.getColor();
        }
        if (string2 != null) {
            balloonAttributes.setInteriorMaterial(new Material(WWUtil.decodeColorABGR(string2)));
        }
        if ((string = kMLBalloonStyle.getTextColor()) != null) {
            balloonAttributes.setTextColor(WWUtil.decodeColorABGR(string));
        }
    }

    protected TextDecoder createTextDecoder(KMLAbstractFeature kMLAbstractFeature) {
        return new KMLBalloonTextDecoder(kMLAbstractFeature);
    }

    public String getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.displayMode = string;
    }

    @Override
    public URL resolve(String string) {
        if (string == null) {
            return null;
        }
        try {
            String string2 = this.parent.getRoot().getKMLDoc().getSupportFilePath(string);
            if (!WWUtil.isEmpty(string2)) {
                File file = new File(string2);
                return file.toURI().toURL();
            }
        }
        catch (IOException iOException) {
            Logging.logger().log(Level.WARNING, Logging.getMessage("KML.UnableToResolvePath", string), iOException.getMessage());
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.parent.getRoot().firePropertyChange(propertyChangeEvent);
    }

    @Override
    public boolean isHighlighted() {
        return this.getBalloon().isHighlighted();
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.getBalloon().setHighlighted(bl);
    }

    @Override
    public boolean isAlwaysOnTop() {
        return this.getBalloon().isAlwaysOnTop();
    }

    @Override
    public void setAlwaysOnTop(boolean bl) {
        this.getBalloon().setAlwaysOnTop(bl);
    }

    @Override
    public boolean isPickEnabled() {
        return this.getBalloon().isPickEnabled();
    }

    @Override
    public void setPickEnabled(boolean bl) {
        this.getBalloon().setPickEnabled(bl);
    }

    @Override
    public String getText() {
        return this.getBalloon().getText();
    }

    @Override
    public void setText(String string) {
        this.getBalloon().setText(string);
    }

    @Override
    public BalloonAttributes getAttributes() {
        return this.getBalloon().getAttributes();
    }

    @Override
    public void setAttributes(BalloonAttributes balloonAttributes) {
        this.getBalloon().setAttributes(balloonAttributes);
    }

    @Override
    public BalloonAttributes getHighlightAttributes() {
        return this.getBalloon().getHighlightAttributes();
    }

    @Override
    public void setHighlightAttributes(BalloonAttributes balloonAttributes) {
        this.getBalloon().setHighlightAttributes(balloonAttributes);
    }

    @Override
    public TextDecoder getTextDecoder() {
        return this.getBalloon().getTextDecoder();
    }

    @Override
    public void setTextDecoder(TextDecoder textDecoder) {
        this.getBalloon().setTextDecoder(textDecoder);
    }

    @Override
    public Object getDelegateOwner() {
        return this.getBalloon().getDelegateOwner();
    }

    @Override
    public void setDelegateOwner(Object object) {
        this.getBalloon().setDelegateOwner(object);
    }

    @Override
    public boolean isVisible() {
        return this.getBalloon().isVisible();
    }

    @Override
    public void setVisible(boolean bl) {
        this.getBalloon().setVisible(bl);
    }

    @Override
    public Rectangle getBounds(DrawContext drawContext) {
        return this.getBalloon().getBounds(drawContext);
    }

    @Override
    public double getMinActiveAltitude() {
        return this.getBalloon().getMinActiveAltitude();
    }

    @Override
    public void setMinActiveAltitude(double d) {
        this.getBalloon().setMinActiveAltitude(d);
    }

    @Override
    public double getMaxActiveAltitude() {
        return this.getBalloon().getMaxActiveAltitude();
    }

    @Override
    public void setMaxActiveAltitude(double d) {
        this.getBalloon().setMaxActiveAltitude(d);
    }

    @Override
    public Object setValue(String string, Object object) {
        return this.getBalloon().setValue(string, object);
    }

    @Override
    public AVList setValues(AVList aVList) {
        return this.getBalloon().setValues(aVList);
    }

    @Override
    public Object getValue(String string) {
        return this.getBalloon().getValue(string);
    }

    @Override
    public Collection<Object> getValues() {
        return this.getBalloon().getValues();
    }

    @Override
    public String getStringValue(String string) {
        return this.getBalloon().getStringValue(string);
    }

    @Override
    public Set<Map.Entry<String, Object>> getEntries() {
        return this.getBalloon().getEntries();
    }

    @Override
    public boolean hasKey(String string) {
        return this.getBalloon().hasKey(string);
    }

    @Override
    public Object removeKey(String string) {
        return this.getBalloon().removeKey(string);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getBalloon().addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getBalloon().removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getBalloon().addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getBalloon().removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        this.getBalloon().firePropertyChange(string, object, object2);
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.getBalloon().firePropertyChange(propertyChangeEvent);
    }

    @Override
    public AVList copy() {
        return this.getBalloon().copy();
    }

    @Override
    public AVList clearList() {
        return this.getBalloon().clearList();
    }
}

