/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada.io;

import gov.nasa.worldwind.ogc.collada.io.ColladaDoc;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ColladaFile
implements ColladaDoc {
    protected File colladaFile;

    public ColladaFile(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.colladaFile = file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.colladaFile);
    }

    @Override
    public String getSupportFilePath(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            return null;
        }
        file = new File(this.colladaFile.getParentFile(), string);
        return file.exists() ? file.getPath() : null;
    }
}

