/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada.impl;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.ogc.collada.ColladaAbstractGeometry;
import gov.nasa.worldwind.ogc.collada.ColladaAbstractInstance;
import gov.nasa.worldwind.ogc.collada.ColladaBindMaterial;
import gov.nasa.worldwind.ogc.collada.ColladaBindVertexInput;
import gov.nasa.worldwind.ogc.collada.ColladaEffect;
import gov.nasa.worldwind.ogc.collada.ColladaExtra;
import gov.nasa.worldwind.ogc.collada.ColladaImage;
import gov.nasa.worldwind.ogc.collada.ColladaInstanceEffect;
import gov.nasa.worldwind.ogc.collada.ColladaInstanceMaterial;
import gov.nasa.worldwind.ogc.collada.ColladaLines;
import gov.nasa.worldwind.ogc.collada.ColladaMaterial;
import gov.nasa.worldwind.ogc.collada.ColladaNewParam;
import gov.nasa.worldwind.ogc.collada.ColladaProfileCommon;
import gov.nasa.worldwind.ogc.collada.ColladaSampler2D;
import gov.nasa.worldwind.ogc.collada.ColladaSource;
import gov.nasa.worldwind.ogc.collada.ColladaSurface;
import gov.nasa.worldwind.ogc.collada.ColladaTechnique;
import gov.nasa.worldwind.ogc.collada.ColladaTechniqueCommon;
import gov.nasa.worldwind.ogc.collada.ColladaTexture;
import gov.nasa.worldwind.ogc.collada.ColladaTriangles;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.AbstractGeneralShape;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.LazilyLoadedTexture;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.awt.Point;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;

public class ColladaMeshShape
extends AbstractGeneralShape {
    protected int elementType;
    protected int vertsPerShape;
    protected int shapeCount;
    protected ColladaBindMaterial bindMaterial;
    protected List<Geometry> geometries;
    protected Map<Matrix, Extent> extentCache = new HashMap<Matrix, Extent>();
    protected FloatBuffer coordBuffer;
    protected FloatBuffer normalBuffer;
    protected int normalBufferPosition;
    protected FloatBuffer textureCoordsBuffer;
    protected int texCoordBufferPosition;

    public static ColladaMeshShape createTriangleMesh(List<ColladaTriangles> list, ColladaBindMaterial colladaBindMaterial) {
        ColladaMeshShape colladaMeshShape = new ColladaMeshShape(list);
        colladaMeshShape.bindMaterial = colladaBindMaterial;
        colladaMeshShape.elementType = 4;
        colladaMeshShape.vertsPerShape = 3;
        return colladaMeshShape;
    }

    public static ColladaMeshShape createLineMesh(List<ColladaLines> list, ColladaBindMaterial colladaBindMaterial) {
        ColladaMeshShape colladaMeshShape = new ColladaMeshShape(list);
        colladaMeshShape.bindMaterial = colladaBindMaterial;
        colladaMeshShape.elementType = 1;
        colladaMeshShape.vertsPerShape = 2;
        return colladaMeshShape;
    }

    protected ColladaMeshShape(List<? extends ColladaAbstractGeometry> list) {
        if (WWUtil.isEmpty(list)) {
            String string = Logging.getMessage("generic.ListIsEmpty");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.geometries = new ArrayList<Geometry>(list.size());
        for (ColladaAbstractGeometry colladaAbstractGeometry : list) {
            this.geometries.add(new Geometry(colladaAbstractGeometry));
            this.shapeCount += colladaAbstractGeometry.getCount();
        }
    }

    @Override
    public List<Intersection> intersect(Line line, Terrain terrain) throws InterruptedException {
        return null;
    }

    @Override
    public void setModelPosition(Position position) {
        if (position != this.modelPosition) {
            this.modelPosition = position;
            this.reset();
        }
    }

    @Override
    protected OGLStackHandler beginDrawing(DrawContext drawContext, int n) {
        OGLStackHandler oGLStackHandler = super.beginDrawing(drawContext, n);
        if (!drawContext.isPickingMode()) {
            oGLStackHandler.pushTextureIdentity(drawContext.getGL());
            if (this.mustApplyLighting(drawContext, null)) {
                drawContext.getGL().glEnable(2977);
            }
        }
        return oGLStackHandler;
    }

    public void render(DrawContext drawContext, Matrix matrix) {
        this.currentData = (AbstractShape.AbstractShapeData)this.shapeDataCache.getEntry(drawContext.getGlobe());
        if (this.currentData == null) {
            this.currentData = this.createCacheEntry(drawContext);
            this.shapeDataCache.addEntry(this.currentData);
        }
        ShapeData shapeData = (ShapeData)this.currentData;
        shapeData.renderMatrix = matrix;
        if (this.extentCache.size() > 1) {
            Extent extent = this.extentCache.get(matrix);
            if (extent == null) {
                extent = this.computeExtent(drawContext);
                this.extentCache.put(matrix, extent);
            }
            shapeData.setExtent(extent);
        }
        this.render(drawContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pick(DrawContext drawContext, Point point, Matrix matrix) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pickSupport.clearPickList();
        try {
            this.pickSupport.beginPicking(drawContext);
            this.render(drawContext, matrix);
        }
        finally {
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, point, this.pickLayer);
        }
    }

    @Override
    protected void drawBatched(DrawContext drawContext) {
        block4: {
            OrderedRenderable orderedRenderable;
            block5: {
                orderedRenderable = drawContext.peekOrderedRenderables();
                if (drawContext.isPickingMode()) break block5;
                while (orderedRenderable != null && orderedRenderable.getClass() == OrderedMeshShape.class) {
                    OrderedMeshShape orderedMeshShape = (OrderedMeshShape)orderedRenderable;
                    ColladaMeshShape colladaMeshShape = orderedMeshShape.mesh;
                    if (colladaMeshShape.isEnableBatchRendering()) {
                        drawContext.pollOrderedRenderables();
                        colladaMeshShape.doDrawOrderedRenderable(drawContext, this.pickSupport, orderedMeshShape.renderMatrix);
                        orderedRenderable = drawContext.peekOrderedRenderables();
                        continue;
                    }
                    break block4;
                }
                break block4;
            }
            if (!this.isEnableBatchPicking()) break block4;
            super.drawBatched(drawContext);
            while (orderedRenderable != null && orderedRenderable.getClass() == this.getClass()) {
                OrderedMeshShape orderedMeshShape = (OrderedMeshShape)orderedRenderable;
                ColladaMeshShape colladaMeshShape = orderedMeshShape.mesh;
                if (colladaMeshShape.isEnableBatchRendering() && colladaMeshShape.isEnableBatchPicking() && colladaMeshShape.pickLayer == this.pickLayer) {
                    drawContext.pollOrderedRenderables();
                    colladaMeshShape.doDrawOrderedRenderable(drawContext, this.pickSupport, orderedMeshShape.renderMatrix);
                    orderedRenderable = drawContext.peekOrderedRenderables();
                    continue;
                }
                break;
            }
        }
    }

    @Override
    protected boolean doMakeOrderedRenderable(DrawContext drawContext) {
        this.extentCache.clear();
        this.createMinimalGeometry(drawContext, (ShapeData)this.getCurrent());
        if (this.getCurrent().getExtent() == null || drawContext.isSmall(this.getExtent(), 1)) {
            return false;
        }
        if (!this.intersectsFrustum(drawContext)) {
            return false;
        }
        this.createFullGeometry(drawContext);
        return true;
    }

    @Override
    protected void addOrderedRenderable(DrawContext drawContext) {
        ShapeData shapeData = (ShapeData)this.getCurrent();
        double d = this.computeEyeDistance(drawContext);
        OrderedMeshShape orderedMeshShape = new OrderedMeshShape(this, shapeData.renderMatrix, d);
        drawContext.addOrderedRenderable(orderedMeshShape);
    }

    protected void doDrawOrderedRenderable(DrawContext drawContext, PickSupport pickSupport, Matrix matrix) {
        ShapeData shapeData = (ShapeData)this.getCurrent();
        shapeData.renderMatrix = matrix;
        super.doDrawOrderedRenderable(drawContext, pickSupport);
    }

    @Override
    protected void doDrawOutline(DrawContext drawContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDrawInterior(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        boolean bl = false;
        boolean bl2 = false;
        try {
            Material material;
            oGLStackHandler.pushModelview(gL);
            this.setModelViewMatrix(drawContext);
            Material material2 = material = this.activeAttributes.getInteriorMaterial();
            if (!this.shouldUseVBOs(drawContext)) {
                FloatBuffer floatBuffer = this.coordBuffer;
                gL.glVertexPointer(3, 5126, 0, floatBuffer.rewind());
            }
            for (Geometry geometry : this.geometries) {
                Material material3;
                Material material4 = material3 = geometry.material != null ? geometry.material : material;
                if (!drawContext.isPickingMode() && !material3.equals(material2)) {
                    this.applyMaterial(drawContext, material3);
                    material2 = material3;
                }
                if (!drawContext.isPickingMode() && this.mustApplyTexture(geometry) && this.getTexture(geometry).bind(drawContext)) {
                    this.getTexture(geometry).applyInternalTransform(drawContext);
                    if (!bl) {
                        gL.glEnable(3553);
                        gL.glEnableClientState(32888);
                        bl = true;
                    }
                    gL.glTexParameteri(3553, 10242, 10497);
                    gL.glTexParameteri(3553, 10243, 10497);
                    gL.glTexCoordPointer(2, 5126, 0, this.textureCoordsBuffer.rewind());
                } else if (bl) {
                    gL.glDisable(3553);
                    gL.glDisableClientState(32888);
                    bl = false;
                }
                if (geometry.doubleSided && bl2) {
                    gL.glDisable(2884);
                    bl2 = false;
                } else if (!geometry.doubleSided && !bl2) {
                    gL.glEnable(2884);
                    bl2 = true;
                }
                int[] nArray = null;
                if (this.shouldUseVBOs(drawContext) && (nArray = this.getVboIds(drawContext)) == null) {
                    FloatBuffer floatBuffer = this.coordBuffer;
                    gL.glVertexPointer(3, 5126, 0, floatBuffer.rewind());
                }
                if (nArray != null) {
                    this.doDrawInteriorVBO(drawContext, geometry, nArray);
                    continue;
                }
                this.doDrawInteriorVA(drawContext, geometry);
            }
        }
        finally {
            oGLStackHandler.pop(gL);
            if (bl) {
                gL.glDisable(3553);
                gL.glDisableClientState(32888);
            }
            if (bl2) {
                gL.glDisable(2884);
            }
        }
    }

    protected void doDrawInteriorVA(DrawContext drawContext, Geometry geometry) {
        GL gL = drawContext.getGL();
        if (geometry.offset == -1) {
            return;
        }
        if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, null) && this.normalBuffer != null) {
            gL.glNormalPointer(5126, 0, this.normalBuffer.rewind());
        }
        gL.glDrawArrays(this.elementType, geometry.offset, geometry.colladaGeometry.getCount() * this.vertsPerShape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDrawInteriorVBO(DrawContext drawContext, Geometry geometry, int[] nArray) {
        GL gL = drawContext.getGL();
        if (geometry.offset == -1) {
            return;
        }
        try {
            gL.glBindBuffer(34962, nArray[0]);
            gL.glVertexPointer(3, 5126, 0, 0L);
            if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, null) && this.normalBuffer != null) {
                gL.glNormalPointer(5126, 0, (long)(this.normalBufferPosition * 4));
            }
            gL.glDrawArrays(this.elementType, geometry.offset, geometry.colladaGeometry.getCount() * this.vertsPerShape);
        }
        finally {
            gL.glBindBuffer(34962, 0);
        }
    }

    protected void setModelViewMatrix(DrawContext drawContext) {
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Matrix matrix = drawContext.getView().getModelviewMatrix();
        matrix = matrix.multiply(this.computeRenderMatrix(drawContext));
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5888);
        double[] dArray = new double[16];
        matrix.toArray(dArray, 0, false);
        gL.glLoadMatrixd(dArray, 0);
    }

    @Override
    protected boolean isOrderedRenderableValid(DrawContext drawContext) {
        return this.coordBuffer != null;
    }

    @Override
    protected AbstractShape.AbstractShapeData createCacheEntry(DrawContext drawContext) {
        return new ShapeData(drawContext, this);
    }

    protected void createMinimalGeometry(DrawContext drawContext, ShapeData shapeData) {
        Vec4 vec4 = this.computeReferencePoint(drawContext.getTerrain());
        if (vec4 == null) {
            return;
        }
        shapeData.setReferencePoint(vec4);
        shapeData.setEyeDistance(this.computeEyeDistance(drawContext, shapeData));
        shapeData.setGlobeStateKey(drawContext.getGlobe().getGlobeStateKey(drawContext));
        shapeData.setVerticalExaggeration(drawContext.getVerticalExaggeration());
        if (this.coordBuffer == null) {
            this.createVertexCoords(drawContext);
        }
        if (shapeData.getExtent() == null) {
            Extent extent = this.computeExtent(drawContext);
            this.extentCache.put(shapeData.renderMatrix, extent);
            shapeData.setExtent(extent);
        }
    }

    protected void createFullGeometry(DrawContext drawContext) {
        if (this.normalBuffer == null && this.mustApplyLighting(drawContext, null)) {
            this.createNormals();
        }
        if (this.textureCoordsBuffer == null && this.mustApplyTexture(drawContext)) {
            this.createTexCoords();
        }
        for (Geometry geometry : this.geometries) {
            if (geometry.material == null) {
                geometry.material = this.getMaterial(geometry);
            }
            geometry.doubleSided = this.isDoubleSided(geometry.colladaGeometry);
        }
    }

    protected Extent computeExtent(DrawContext drawContext) {
        Vec4[] vec4Array;
        if (this.coordBuffer == null) {
            return null;
        }
        this.coordBuffer.rewind();
        Box box = Box.computeBoundingBox(new BufferWrapper.FloatBufferWrapper(this.coordBuffer), 3);
        Matrix matrix = this.computeRenderMatrix(drawContext);
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        for (Vec4 vec4 : vec4Array = box.getCorners()) {
            arrayList.add(vec4.transformBy4(matrix));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return Box.computeBoundingBox(arrayList);
    }

    protected void createVertexCoords(DrawContext drawContext) {
        int n;
        this.normalBufferPosition = n = this.shapeCount * this.vertsPerShape * 3;
        if (this.mustApplyLighting(drawContext, null)) {
            n += this.shapeCount * this.vertsPerShape * 3;
        }
        this.texCoordBufferPosition = n;
        if (this.mustApplyTexture(drawContext)) {
            n += this.shapeCount * this.vertsPerShape * 2;
        }
        if (this.coordBuffer != null && this.coordBuffer.capacity() >= n) {
            this.coordBuffer.clear();
        } else {
            this.coordBuffer = BufferUtil.newFloatBuffer((int)n);
        }
        for (Geometry geometry : this.geometries) {
            geometry.offset = this.coordBuffer.position() / this.vertsPerShape;
            geometry.colladaGeometry.getVertices(this.coordBuffer);
        }
    }

    protected void createNormals() {
        this.coordBuffer.position(this.normalBufferPosition);
        this.normalBuffer = this.coordBuffer.slice();
        for (Geometry geometry : this.geometries) {
            if (geometry.colladaGeometry.getNormalAccessor() != null) {
                geometry.colladaGeometry.getNormals(this.normalBuffer);
                continue;
            }
            int n = geometry.colladaGeometry.getCount() * this.vertsPerShape * 3;
            this.normalBuffer.position(this.normalBuffer.position() + n);
        }
    }

    protected void createTexCoords() {
        this.coordBuffer.position(this.texCoordBufferPosition);
        this.textureCoordsBuffer = this.coordBuffer.slice();
        for (Geometry geometry : this.geometries) {
            if (this.mustApplyTexture(geometry)) {
                String string = this.getTexCoordSemantic(geometry);
                geometry.colladaGeometry.getTextureCoordinates(this.textureCoordsBuffer, string);
                continue;
            }
            int n = geometry.colladaGeometry.getCount() * this.vertsPerShape * 2;
            this.textureCoordsBuffer.position(this.textureCoordsBuffer.position() + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillVBO(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        ShapeData shapeData = (ShapeData)this.getCurrentData();
        int[] nArray = this.getVboIds(drawContext);
        if (nArray == null) {
            int n = this.coordBuffer.limit() * 4;
            nArray = new int[1];
            gL.glGenBuffers(nArray.length, nArray, 0);
            drawContext.getGpuResourceCache().put(shapeData.getVboCacheKey(), nArray, "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers", n);
        }
        try {
            FloatBuffer floatBuffer = this.coordBuffer;
            gL.glBindBuffer(34962, nArray[0]);
            gL.glBufferData(34962, floatBuffer.limit() * 4, floatBuffer.rewind(), 35044);
        }
        finally {
            gL.glBindBuffer(34962, 0);
        }
    }

    protected Vec4 computeReferenceCenter(DrawContext drawContext) {
        Position position = this.getReferencePosition();
        if (position == null) {
            return null;
        }
        return this.computePoint(drawContext.getTerrain(), position);
    }

    protected double computeEyeDistance(DrawContext drawContext) {
        Vec4 vec4 = drawContext.getView().getEyePoint();
        Vec4 vec42 = this.computePoint(drawContext.getTerrain(), this.getModelPosition());
        if (vec42 != null) {
            return vec42.distanceTo3(vec4);
        }
        return 0.0;
    }

    protected Matrix computeRenderMatrix(DrawContext drawContext) {
        ShapeData shapeData = (ShapeData)this.getCurrent();
        if (shapeData.referenceCenter == null || shapeData.isExpired(drawContext)) {
            shapeData.referenceCenter = this.computeReferenceCenter(drawContext);
            Position position = drawContext.getGlobe().computePositionFromPoint(shapeData.referenceCenter);
            shapeData.surfaceOrientationMatrix = drawContext.getGlobe().computeSurfaceOrientationAtPosition(position);
        }
        return shapeData.surfaceOrientationMatrix.multiply(shapeData.renderMatrix);
    }

    @Override
    protected boolean mustApplyTexture(DrawContext drawContext) {
        for (Geometry geometry : this.geometries) {
            if (!this.mustApplyTexture(geometry)) continue;
            return true;
        }
        return false;
    }

    protected boolean mustApplyTexture(Geometry geometry) {
        String string = this.getTexCoordSemantic(geometry);
        return geometry.colladaGeometry.getTexCoordAccessor(string) != null && this.getTexture(geometry) != null;
    }

    protected WWTexture getTexture(Geometry geometry) {
        Object object;
        if (geometry.texture != null) {
            return geometry.texture;
        }
        String string = this.getTextureSource(geometry.colladaGeometry);
        if (string != null && (object = geometry.colladaGeometry.getRoot().resolveReference(string)) != null) {
            geometry.texture = new LazilyLoadedTexture(object);
        }
        return geometry.texture;
    }

    protected void applyMaterial(DrawContext drawContext, Material material) {
        GL gL = drawContext.getGL();
        ShapeAttributes shapeAttributes = this.getActiveAttributes();
        double d = shapeAttributes.getInteriorOpacity();
        if (this.mustApplyLighting(drawContext, shapeAttributes)) {
            material.apply(gL, 1032, (float)d);
        } else {
            Color color = material.getDiffuse();
            gL.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)(d < 1.0 ? (int)(d * 255.0 + 0.5) : 255));
        }
    }

    protected Material getMaterial(Geometry geometry) {
        ColladaInstanceMaterial colladaInstanceMaterial = this.getInstanceMaterial(geometry);
        if (colladaInstanceMaterial == null) {
            return DEFAULT_INTERIOR_MATERIAL;
        }
        ColladaMaterial colladaMaterial = (ColladaMaterial)colladaInstanceMaterial.get();
        if (colladaMaterial == null) {
            return DEFAULT_INTERIOR_MATERIAL;
        }
        ColladaInstanceEffect colladaInstanceEffect = colladaMaterial.getInstanceEffect();
        if (colladaInstanceEffect == null) {
            return DEFAULT_INTERIOR_MATERIAL;
        }
        ColladaEffect colladaEffect = (ColladaEffect)colladaInstanceEffect.get();
        if (colladaEffect == null) {
            return DEFAULT_INTERIOR_MATERIAL;
        }
        return colladaEffect.getMaterial();
    }

    protected ColladaInstanceMaterial getInstanceMaterial(Geometry geometry) {
        if (this.bindMaterial == null) {
            return null;
        }
        ColladaTechniqueCommon colladaTechniqueCommon = this.bindMaterial.getTechniqueCommon();
        if (colladaTechniqueCommon == null) {
            return null;
        }
        String string = geometry.colladaGeometry.getMaterial();
        if (string == null) {
            return null;
        }
        for (ColladaInstanceMaterial colladaInstanceMaterial : colladaTechniqueCommon.getMaterials()) {
            if (!string.equals(colladaInstanceMaterial.getSymbol())) continue;
            return colladaInstanceMaterial;
        }
        return null;
    }

    protected String getTexCoordSemantic(Geometry geometry) {
        ColladaEffect colladaEffect = this.getEffect(geometry.colladaGeometry);
        if (colladaEffect == null) {
            return null;
        }
        ColladaTexture colladaTexture = colladaEffect.getTexture();
        if (colladaTexture == null) {
            return null;
        }
        String string = colladaTexture.getTexCoord();
        if (string == null) {
            return null;
        }
        ColladaInstanceMaterial colladaInstanceMaterial = this.getInstanceMaterial(geometry);
        String string2 = null;
        for (ColladaBindVertexInput colladaBindVertexInput : colladaInstanceMaterial.getBindVertexInputs()) {
            if (!string.equals(colladaBindVertexInput.getSemantic())) continue;
            string2 = colladaBindVertexInput.getInputSemantic();
        }
        return string2;
    }

    protected String getTextureSource(ColladaAbstractGeometry colladaAbstractGeometry) {
        Object object;
        ColladaTechniqueCommon colladaTechniqueCommon = this.bindMaterial.getTechniqueCommon();
        if (colladaTechniqueCommon == null) {
            return null;
        }
        String string = colladaAbstractGeometry.getMaterial();
        if (string == null) {
            return null;
        }
        ColladaAbstractInstance colladaAbstractInstance2 = null;
        for (ColladaInstanceMaterial colladaAbstractInstance3 : colladaTechniqueCommon.getMaterials()) {
            if (!string.equals(colladaAbstractInstance3.getSymbol())) continue;
            colladaAbstractInstance2 = colladaAbstractInstance3;
            break;
        }
        if (colladaAbstractInstance2 == null) {
            return null;
        }
        ColladaMaterial colladaMaterial = (ColladaMaterial)colladaAbstractInstance2.get();
        if (colladaMaterial == null) {
            return null;
        }
        ColladaInstanceEffect colladaInstanceEffect = colladaMaterial.getInstanceEffect();
        if (colladaInstanceEffect == null) {
            return null;
        }
        ColladaEffect colladaEffect = (ColladaEffect)colladaInstanceEffect.get();
        if (colladaEffect == null) {
            return null;
        }
        ColladaTexture colladaTexture = colladaEffect.getTexture();
        if (colladaTexture == null) {
            return null;
        }
        String string2 = this.getImageRef(colladaEffect, colladaTexture);
        if (string2 == null) {
            return null;
        }
        if (!string2.contains("#")) {
            string2 = "#" + string2;
        }
        if ((object = colladaAbstractGeometry.getRoot().resolveReference(string2)) instanceof ColladaImage) {
            return ((ColladaImage)object).getInitFrom();
        }
        return null;
    }

    protected String getImageRef(ColladaEffect colladaEffect, ColladaTexture colladaTexture) {
        String string = colladaTexture.getTexture();
        ColladaNewParam colladaNewParam = colladaEffect.getParam(string);
        if (colladaNewParam == null) {
            return null;
        }
        ColladaSampler2D colladaSampler2D = colladaNewParam.getSampler2D();
        if (colladaSampler2D == null) {
            return null;
        }
        ColladaSource colladaSource = colladaSampler2D.getSource();
        if (colladaSource == null) {
            return null;
        }
        string = colladaSource.getCharacters();
        if (string == null) {
            return null;
        }
        colladaNewParam = colladaEffect.getParam(string);
        if (colladaNewParam == null) {
            return null;
        }
        ColladaSurface colladaSurface = colladaNewParam.getSurface();
        if (colladaSurface != null) {
            return colladaSurface.getInitFrom();
        }
        return null;
    }

    protected ColladaEffect getEffect(ColladaAbstractGeometry colladaAbstractGeometry) {
        ColladaTechniqueCommon colladaTechniqueCommon = this.bindMaterial.getTechniqueCommon();
        if (colladaTechniqueCommon == null) {
            return null;
        }
        String string = colladaAbstractGeometry.getMaterial();
        if (string == null) {
            return null;
        }
        ColladaAbstractInstance colladaAbstractInstance2 = null;
        for (ColladaInstanceMaterial colladaAbstractInstance3 : colladaTechniqueCommon.getMaterials()) {
            if (!string.equals(colladaAbstractInstance3.getSymbol())) continue;
            colladaAbstractInstance2 = colladaAbstractInstance3;
            break;
        }
        if (colladaAbstractInstance2 == null) {
            return null;
        }
        ColladaMaterial colladaMaterial = (ColladaMaterial)colladaAbstractInstance2.get();
        if (colladaMaterial == null) {
            return null;
        }
        ColladaInstanceEffect colladaInstanceEffect = colladaMaterial.getInstanceEffect();
        if (colladaInstanceEffect == null) {
            return null;
        }
        return (ColladaEffect)colladaInstanceEffect.get();
    }

    protected boolean isDoubleSided(ColladaAbstractGeometry colladaAbstractGeometry) {
        ColladaEffect colladaEffect = this.getEffect(colladaAbstractGeometry);
        if (colladaEffect == null) {
            return false;
        }
        ColladaProfileCommon colladaProfileCommon = colladaEffect.getProfileCommon();
        if (colladaProfileCommon == null) {
            return false;
        }
        ColladaExtra colladaExtra = colladaProfileCommon.getExtra();
        if (colladaExtra == null) {
            return false;
        }
        ColladaTechnique colladaTechnique = (ColladaTechnique)colladaExtra.getField("technique");
        if (colladaTechnique == null || !"GOOGLEEARTH".equals(colladaTechnique.getProfile())) {
            return false;
        }
        Integer n = (Integer)colladaTechnique.getField("double_sided");
        return n != null && n == 1;
    }

    protected static class Geometry {
        protected ColladaAbstractGeometry colladaGeometry;
        protected int offset = -1;
        protected WWTexture texture;
        protected Material material;
        protected boolean doubleSided;

        public Geometry(ColladaAbstractGeometry colladaAbstractGeometry) {
            this.colladaGeometry = colladaAbstractGeometry;
        }
    }

    protected static class ShapeData
    extends AbstractGeneralShape.ShapeData {
        protected Matrix surfaceOrientationMatrix;
        protected Matrix renderMatrix;
        protected Vec4 referenceCenter;

        public ShapeData(DrawContext drawContext, AbstractGeneralShape abstractGeneralShape) {
            super(drawContext, abstractGeneralShape);
        }
    }

    public static class OrderedMeshShape
    implements OrderedRenderable {
        protected ColladaMeshShape mesh;
        protected double eyeDistance;
        protected Matrix renderMatrix;

        public OrderedMeshShape(ColladaMeshShape colladaMeshShape, Matrix matrix, double d) {
            this.mesh = colladaMeshShape;
            this.eyeDistance = d;
            this.renderMatrix = matrix;
        }

        @Override
        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
            this.mesh.pick(drawContext, point, this.renderMatrix);
        }

        @Override
        public void render(DrawContext drawContext) {
            this.mesh.render(drawContext, this.renderMatrix);
        }
    }
}

