/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada;

import gov.nasa.worldwind.ogc.collada.ColladaAbstractObject;
import gov.nasa.worldwind.ogc.collada.ColladaAccessor;
import gov.nasa.worldwind.ogc.collada.ColladaAsset;
import gov.nasa.worldwind.ogc.collada.ColladaBind;
import gov.nasa.worldwind.ogc.collada.ColladaBindMaterial;
import gov.nasa.worldwind.ogc.collada.ColladaBindVertexInput;
import gov.nasa.worldwind.ogc.collada.ColladaColor;
import gov.nasa.worldwind.ogc.collada.ColladaContributor;
import gov.nasa.worldwind.ogc.collada.ColladaEffect;
import gov.nasa.worldwind.ogc.collada.ColladaExtra;
import gov.nasa.worldwind.ogc.collada.ColladaFloatArray;
import gov.nasa.worldwind.ogc.collada.ColladaFloatOrParam;
import gov.nasa.worldwind.ogc.collada.ColladaFormat;
import gov.nasa.worldwind.ogc.collada.ColladaGeometry;
import gov.nasa.worldwind.ogc.collada.ColladaImage;
import gov.nasa.worldwind.ogc.collada.ColladaInput;
import gov.nasa.worldwind.ogc.collada.ColladaInstanceEffect;
import gov.nasa.worldwind.ogc.collada.ColladaInstanceGeometry;
import gov.nasa.worldwind.ogc.collada.ColladaInstanceMaterial;
import gov.nasa.worldwind.ogc.collada.ColladaInstanceNode;
import gov.nasa.worldwind.ogc.collada.ColladaInstanceVisualScene;
import gov.nasa.worldwind.ogc.collada.ColladaLambert;
import gov.nasa.worldwind.ogc.collada.ColladaLibrary;
import gov.nasa.worldwind.ogc.collada.ColladaLines;
import gov.nasa.worldwind.ogc.collada.ColladaMaterial;
import gov.nasa.worldwind.ogc.collada.ColladaMatrix;
import gov.nasa.worldwind.ogc.collada.ColladaMesh;
import gov.nasa.worldwind.ogc.collada.ColladaNewParam;
import gov.nasa.worldwind.ogc.collada.ColladaNode;
import gov.nasa.worldwind.ogc.collada.ColladaP;
import gov.nasa.worldwind.ogc.collada.ColladaParam;
import gov.nasa.worldwind.ogc.collada.ColladaPhong;
import gov.nasa.worldwind.ogc.collada.ColladaProfileCommon;
import gov.nasa.worldwind.ogc.collada.ColladaSampler2D;
import gov.nasa.worldwind.ogc.collada.ColladaScene;
import gov.nasa.worldwind.ogc.collada.ColladaSource;
import gov.nasa.worldwind.ogc.collada.ColladaSurface;
import gov.nasa.worldwind.ogc.collada.ColladaTechnique;
import gov.nasa.worldwind.ogc.collada.ColladaTechniqueCommon;
import gov.nasa.worldwind.ogc.collada.ColladaTexture;
import gov.nasa.worldwind.ogc.collada.ColladaTextureOrColor;
import gov.nasa.worldwind.ogc.collada.ColladaTriangles;
import gov.nasa.worldwind.ogc.collada.ColladaUnit;
import gov.nasa.worldwind.ogc.collada.ColladaUnsupported;
import gov.nasa.worldwind.ogc.collada.ColladaVertices;
import gov.nasa.worldwind.ogc.collada.ColladaVisualScene;
import gov.nasa.worldwind.util.xml.BasicXMLEventParserContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;

public class ColladaParserContext
extends BasicXMLEventParserContext {
    protected static QName COORDINATES = new QName("Coordinates");
    protected static final String[] StringFields = new String[]{"author", "name", "authoring_tool", "source_data", "init_from", "created", "modified", "up_axis"};
    protected static final String[] DoubleFields = new String[]{"revision", "float"};
    protected static final String[] IntegerFields = new String[]{"drawOrder", "meter", "double_sided"};
    protected static final String[] BooleanFields = new String[]{"extrude"};

    public ColladaParserContext(XMLEventReader xMLEventReader, String string) {
        super(xMLEventReader, string != null ? string : "http://www.collada.org/2005/11/COLLADASchema");
    }

    public ColladaParserContext(String string) {
        this(null, string);
    }

    public ColladaParserContext(ColladaParserContext colladaParserContext) {
        super(colladaParserContext);
    }

    @Override
    protected void initializeParsers() {
        super.initializeParsers();
        this.initializeParsers("http://www.collada.org/2005/11/COLLADASchema");
    }

    protected void initializeParsers(String string) {
        this.parsers.put(new QName(string, "unit"), new ColladaUnit(string));
        this.parsers.put(new QName(string, "material"), new ColladaMaterial(string));
        this.parsers.put(new QName(string, "technique"), new ColladaTechnique(string));
        this.parsers.put(new QName(string, "surface"), new ColladaSurface(string));
        this.parsers.put(new QName(string, "format"), new ColladaFormat(string));
        this.parsers.put(new QName(string, "sampler2D"), new ColladaSampler2D(string));
        this.parsers.put(new QName(string, "source"), new ColladaSource(string));
        this.parsers.put(new QName(string, "param"), new ColladaParam(string));
        this.parsers.put(new QName(string, "float_array"), new ColladaFloatArray(string));
        this.parsers.put(new QName(string, "input"), new ColladaInput(string));
        this.parsers.put(new QName(string, "effect"), new ColladaEffect(string));
        this.parsers.put(new QName(string, "profile_COMMON"), new ColladaProfileCommon(string));
        this.parsers.put(new QName(string, "newparam"), new ColladaNewParam(string));
        this.parsers.put(new QName(string, "phong"), new ColladaPhong(string));
        this.parsers.put(new QName(string, "lambert"), new ColladaLambert(string));
        this.parsers.put(new QName(string, "mesh"), new ColladaMesh(string));
        this.parsers.put(new QName(string, "technique_COMMON"), new ColladaTechniqueCommon(string));
        this.parsers.put(new QName(string, "technique_common"), new ColladaTechniqueCommon(string));
        this.parsers.put(new QName(string, "accessor"), new ColladaAccessor(string));
        this.parsers.put(new QName(string, "p"), new ColladaP(string));
        this.parsers.put(new QName(string, "texture"), new ColladaTexture(string));
        this.parsers.put(new QName(string, "color"), new ColladaColor(string));
        this.parsers.put(new QName(string, "geometry"), new ColladaGeometry(string));
        this.parsers.put(new QName(string, "vertices"), new ColladaVertices(string));
        this.parsers.put(new QName(string, "bind"), new ColladaBind(string));
        this.parsers.put(new QName(string, "node"), new ColladaNode(string));
        this.parsers.put(new QName(string, "matrix"), new ColladaMatrix(string));
        this.parsers.put(new QName(string, "bind_material"), new ColladaBindMaterial(string));
        this.parsers.put(new QName(string, "bind_vertex_input"), new ColladaBindVertexInput(string));
        this.parsers.put(new QName(string, "scene"), new ColladaScene(string));
        ColladaAbstractObject colladaAbstractObject = new ColladaTextureOrColor(string);
        this.parsers.put(new QName(string, "emission"), colladaAbstractObject);
        this.parsers.put(new QName(string, "ambient"), colladaAbstractObject);
        this.parsers.put(new QName(string, "diffuse"), colladaAbstractObject);
        this.parsers.put(new QName(string, "specular"), colladaAbstractObject);
        this.parsers.put(new QName(string, "transparent"), colladaAbstractObject);
        colladaAbstractObject = new ColladaFloatOrParam(string);
        this.parsers.put(new QName(string, "shininess"), colladaAbstractObject);
        this.parsers.put(new QName(string, "reflectivity"), colladaAbstractObject);
        this.parsers.put(new QName(string, "transparency"), colladaAbstractObject);
        this.parsers.put(new QName(string, "index_of_refraction"), colladaAbstractObject);
        this.parsers.put(new QName(string, "image"), new ColladaImage(string));
        this.parsers.put(new QName(string, "asset"), new ColladaAsset(string));
        this.parsers.put(new QName(string, "contributor"), new ColladaContributor(string));
        this.parsers.put(new QName(string, "library_geometries"), new ColladaLibrary(string));
        this.parsers.put(new QName(string, "library_effects"), new ColladaLibrary(string));
        this.parsers.put(new QName(string, "library_images"), new ColladaLibrary(string));
        this.parsers.put(new QName(string, "library_materials"), new ColladaLibrary(string));
        this.parsers.put(new QName(string, "library_visual_scenes"), new ColladaLibrary(string));
        this.parsers.put(new QName(string, "library_nodes"), new ColladaLibrary(string));
        this.parsers.put(new QName(string, "instance_visual_scene"), new ColladaInstanceVisualScene(string));
        this.parsers.put(new QName(string, "instance_geometry"), new ColladaInstanceGeometry(string));
        this.parsers.put(new QName(string, "instance_material"), new ColladaInstanceMaterial(string));
        this.parsers.put(new QName(string, "instance_effect"), new ColladaInstanceEffect(string));
        this.parsers.put(new QName(string, "instance_node"), new ColladaInstanceNode(string));
        this.parsers.put(new QName(string, "visual_scene"), new ColladaVisualScene(string));
        this.parsers.put(new QName(string, "triangles"), new ColladaTriangles(string));
        this.parsers.put(new QName(string, "lines"), new ColladaLines(string));
        this.parsers.put(new QName(string, "extra"), new ColladaExtra(string));
        colladaAbstractObject = new ColladaUnsupported(string);
        this.parsers.put(new QName(string, "library_cameras"), colladaAbstractObject);
        this.parsers.put(new QName(string, "instance_camera"), colladaAbstractObject);
        this.parsers.put(new QName(string, "camera"), colladaAbstractObject);
        this.parsers.put(new QName(string, "lookat"), colladaAbstractObject);
        this.parsers.put(new QName(string, "optics"), colladaAbstractObject);
        this.parsers.put(new QName(string, "perspective"), colladaAbstractObject);
        this.parsers.put(new QName(string, "orthographic"), colladaAbstractObject);
        this.parsers.put(new QName(string, "znear"), colladaAbstractObject);
        this.parsers.put(new QName(string, "zfar"), colladaAbstractObject);
        this.parsers.put(new QName(string, "xfov"), colladaAbstractObject);
        this.parsers.put(new QName(string, "yfov"), colladaAbstractObject);
        this.parsers.put(new QName(string, "aspect_ratio"), colladaAbstractObject);
        this.addStringParsers(string, StringFields);
        this.addDoubleParsers(string, DoubleFields);
        this.addIntegerParsers(string, IntegerFields);
        this.addBooleanParsers(string, BooleanFields);
    }
}

