/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AbstractGraticuleLayer;
import gov.nasa.worldwind.layers.GraticuleRenderingParams;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.UserFacingText;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class LatLonGraticuleLayer
extends AbstractGraticuleLayer {
    public static final String GRATICULE_LATLON_LEVEL_0 = "Graticule.LatLonLevel0";
    public static final String GRATICULE_LATLON_LEVEL_1 = "Graticule.LatLonLevel1";
    public static final String GRATICULE_LATLON_LEVEL_2 = "Graticule.LatLonLevel2";
    public static final String GRATICULE_LATLON_LEVEL_3 = "Graticule.LatLonLevel3";
    public static final String GRATICULE_LATLON_LEVEL_4 = "Graticule.LatLonLevel4";
    public static final String GRATICULE_LATLON_LEVEL_5 = "Graticule.LatLonLevel5";
    protected static final int MIN_CELL_SIZE_PIXELS = 40;
    protected GraticuleTile[][] gridTiles = new GraticuleTile[18][36];
    protected ArrayList<Double> latitudeLabels = new ArrayList();
    protected ArrayList<Double> longitudeLabels = new ArrayList();
    private String angleFormat = "gov.nasa.worldwind.Geom.AngleDMS";

    public LatLonGraticuleLayer() {
        this.initRenderingParams();
        this.setPickEnabled(false);
        this.setName(Logging.getMessage("layers.LatLonGraticule.Name"));
    }

    public String getAngleFormat() {
        return this.angleFormat;
    }

    public void setAngleFormat(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.angleFormat.equals(string)) {
            return;
        }
        this.angleFormat = string;
        this.clearTiles();
        this.lastEyePoint = null;
    }

    protected void initRenderingParams() {
        GraticuleRenderingParams graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.WHITE);
        graticuleRenderingParams.setValue("LabelColor", Color.WHITE);
        graticuleRenderingParams.setValue("LabelFont", Font.decode("Arial-Bold-16"));
        this.setRenderingParams(GRATICULE_LATLON_LEVEL_0, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.GREEN);
        graticuleRenderingParams.setValue("LabelColor", Color.GREEN);
        graticuleRenderingParams.setValue("LabelFont", Font.decode("Arial-Bold-14"));
        this.setRenderingParams(GRATICULE_LATLON_LEVEL_1, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(0, 102, 255));
        graticuleRenderingParams.setValue("LabelColor", new Color(0, 102, 255));
        this.setRenderingParams(GRATICULE_LATLON_LEVEL_2, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.CYAN);
        graticuleRenderingParams.setValue("LabelColor", Color.CYAN);
        this.setRenderingParams(GRATICULE_LATLON_LEVEL_3, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(0, 153, 153));
        graticuleRenderingParams.setValue("LabelColor", new Color(0, 153, 153));
        this.setRenderingParams(GRATICULE_LATLON_LEVEL_4, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(102, 255, 204));
        graticuleRenderingParams.setValue("LabelColor", new Color(102, 255, 204));
        this.setRenderingParams(GRATICULE_LATLON_LEVEL_5, graticuleRenderingParams);
    }

    protected String[] getOrderedTypes() {
        return new String[]{GRATICULE_LATLON_LEVEL_0, GRATICULE_LATLON_LEVEL_1, GRATICULE_LATLON_LEVEL_2, GRATICULE_LATLON_LEVEL_3, GRATICULE_LATLON_LEVEL_4, GRATICULE_LATLON_LEVEL_5};
    }

    protected String getTypeFor(double d) {
        if (d >= 10.0) {
            return GRATICULE_LATLON_LEVEL_0;
        }
        if (d >= 1.0) {
            return GRATICULE_LATLON_LEVEL_1;
        }
        if (d >= 0.1) {
            return GRATICULE_LATLON_LEVEL_2;
        }
        if (d >= 0.01) {
            return GRATICULE_LATLON_LEVEL_3;
        }
        if (d >= 0.001) {
            return GRATICULE_LATLON_LEVEL_4;
        }
        if (d >= 1.0E-4) {
            return GRATICULE_LATLON_LEVEL_5;
        }
        return null;
    }

    @Override
    protected void clear(DrawContext drawContext) {
        super.clear(drawContext);
        this.latitudeLabels.clear();
        this.longitudeLabels.clear();
        this.applyTerrainConformance();
    }

    private void applyTerrainConformance() {
        String[] stringArray;
        for (String string : stringArray = this.getOrderedTypes()) {
            this.getRenderingParams(string).setValue("GraticuleLineConformance", this.polylineTerrainConformance);
        }
    }

    @Override
    protected void selectRenderables(DrawContext drawContext) {
        ArrayList<GraticuleTile> arrayList = this.getVisibleTiles(drawContext);
        if (arrayList.size() > 0) {
            for (GraticuleTile graticuleTile : arrayList) {
                graticuleTile.selectRenderables(drawContext);
            }
        }
    }

    protected ArrayList<GraticuleTile> getVisibleTiles(DrawContext drawContext) {
        Rectangle2D rectangle2D;
        ArrayList<GraticuleTile> arrayList = new ArrayList<GraticuleTile>();
        Sector sector = drawContext.getVisibleSector();
        if (sector != null && (rectangle2D = this.getGridRectangleForSector(sector)) != null) {
            int n = (int)rectangle2D.getY();
            while ((double)n <= rectangle2D.getY() + rectangle2D.getHeight()) {
                int n2 = (int)rectangle2D.getX();
                while ((double)n2 <= rectangle2D.getX() + rectangle2D.getWidth()) {
                    if (this.gridTiles[n][n2] == null) {
                        this.gridTiles[n][n2] = new GraticuleTile(this.getGridSector(n, n2), 10, 0);
                    }
                    if (this.gridTiles[n][n2].isInView(drawContext)) {
                        arrayList.add(this.gridTiles[n][n2]);
                    } else {
                        this.gridTiles[n][n2].clearRenderables();
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return arrayList;
    }

    private Rectangle2D getGridRectangleForSector(Sector sector) {
        int n = this.getGridColumn(sector.getMinLongitude().degrees);
        int n2 = this.getGridColumn(sector.getMaxLongitude().degrees);
        int n3 = this.getGridRow(sector.getMinLatitude().degrees);
        int n4 = this.getGridRow(sector.getMaxLatitude().degrees);
        return new Rectangle(n, n3, n2 - n, n4 - n3);
    }

    private Sector getGridSector(int n, int n2) {
        int n3 = -90 + n * 10;
        int n4 = n3 + 10;
        int n5 = -180 + n2 * 10;
        int n6 = n5 + 10;
        return Sector.fromDegrees(n3, n4, n5, n6);
    }

    private int getGridColumn(Double d) {
        int n = (int)Math.floor((d + 180.0) / 10.0);
        return Math.min(n, 35);
    }

    private int getGridRow(Double d) {
        int n = (int)Math.floor((d + 90.0) / 10.0);
        return Math.min(n, 17);
    }

    protected void clearTiles() {
        for (int i = 0; i < 18; ++i) {
            for (int j = 0; j < 36; ++j) {
                if (this.gridTiles[i][j] == null) continue;
                this.gridTiles[i][j].clearRenderables();
                this.gridTiles[i][j] = null;
            }
        }
    }

    protected String makeAngleLabel(Angle angle, double d) {
        double[] dArray;
        double d2 = 1.0E-9;
        String string = this.getAngleFormat().equals("gov.nasa.worldwind.Geom.AngleDMS") ? (d >= 1.0 ? angle.toDecimalDegreesString(0) : ((dArray = angle.toDMS())[1] < d2 && dArray[2] < d2 ? String.format("%4d\u00b0", (int)dArray[0]) : (dArray[2] < d2 ? String.format("%4d\u00b0 %2d\u2019", (int)dArray[0], (int)dArray[1]) : angle.toDMSString()))) : (d >= 1.0 ? angle.toDecimalDegreesString(0) : (d >= 0.1 ? angle.toDecimalDegreesString(1) : (d >= 0.01 ? angle.toDecimalDegreesString(2) : (d >= 0.001 ? angle.toDecimalDegreesString(3) : angle.toDecimalDegreesString(4)))));
        return string;
    }

    protected void addLabel(double d, String string, String string2, double d2, LatLon latLon) {
        if (string.equals("GridElement_LatitudeLabel")) {
            if (!this.latitudeLabels.contains(d)) {
                this.latitudeLabels.add(d);
                String string3 = this.makeAngleLabel(Angle.fromDegrees(d), d2);
                UserFacingText userFacingText = new UserFacingText(string3, Position.fromDegrees(d, latLon.getLongitude().degrees, 0.0));
                userFacingText.setPriority(d2 * 1000000.0);
                this.addRenderable(userFacingText, string2);
            }
        } else if (string.equals("GridElement_LongitudeLabel") && !this.longitudeLabels.contains(d)) {
            this.longitudeLabels.add(d);
            String string4 = this.makeAngleLabel(Angle.fromDegrees(d), d2);
            UserFacingText userFacingText = new UserFacingText(string4, Position.fromDegrees(latLon.getLatitude().degrees, d, 0.0));
            userFacingText.setPriority(d2 * 1000000.0);
            this.addRenderable(userFacingText, string2);
        }
    }

    protected class GraticuleTile {
        private Sector sector;
        private int divisions;
        private int level;
        private ArrayList<AbstractGraticuleLayer.GridElement> gridElements;
        private ArrayList<GraticuleTile> subTiles;

        public GraticuleTile(Sector sector, int n, int n2) {
            this.sector = sector;
            this.divisions = n;
            this.level = n2;
        }

        public Extent getExtent(Globe globe, double d) {
            return Sector.computeBoundingCylinder(globe, d, this.sector);
        }

        public boolean isInView(DrawContext drawContext) {
            if (!LatLonGraticuleLayer.this.viewFrustum.intersects(this.getExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration()))) {
                return false;
            }
            return this.level == 0 || !(this.getSizeInPixels(drawContext) / (double)this.divisions < 40.0);
        }

        public double getSizeInPixels(DrawContext drawContext) {
            View view = drawContext.getView();
            Vec4 vec4 = LatLonGraticuleLayer.this.getSurfacePoint(drawContext, this.sector.getCentroid().getLatitude(), this.sector.getCentroid().getLongitude());
            double d = view.getEyePoint().distanceTo3(vec4);
            double d2 = this.sector.getDeltaLatRadians() * drawContext.getGlobe().getRadius();
            return d2 / view.computePixelSizeAtDistance(d);
        }

        public void selectRenderables(DrawContext drawContext) {
            if (this.gridElements == null) {
                this.createRenderables();
            }
            LatLon latLon = LatLonGraticuleLayer.this.computeLabelOffset(drawContext);
            String string = LatLonGraticuleLayer.this.getTypeFor(this.sector.getDeltaLatDegrees());
            if (this.level == 0) {
                for (AbstractGraticuleLayer.GridElement gridElement : this.gridElements) {
                    if (!gridElement.isInView(drawContext) || !gridElement.type.equals("GridElement_LineSouth") && !gridElement.type.equals("GridElement_LineWest")) continue;
                    LatLonGraticuleLayer.this.addRenderable(gridElement.renderable, string);
                    Iterator<GraticuleTile> iterator = gridElement.type.equals("GridElement_LineSouth") ? "GridElement_LatitudeLabel" : "GridElement_LongitudeLabel";
                    LatLonGraticuleLayer.this.addLabel(gridElement.value, (String)((Object)iterator), string, this.sector.getDeltaLatDegrees(), latLon);
                }
                if (this.getSizeInPixels(drawContext) / (double)this.divisions < 40.0) {
                    return;
                }
            }
            double d = this.sector.getDeltaLatDegrees() / (double)this.divisions;
            string = LatLonGraticuleLayer.this.getTypeFor(d);
            for (AbstractGraticuleLayer.GridElement object : this.gridElements) {
                if (!object.isInView(drawContext) || !object.type.equals("GridElement_Line")) continue;
                LatLonGraticuleLayer.this.addRenderable(object.renderable, string);
                String string2 = object.sector.getDeltaLatDegrees() == 0.0 ? "GridElement_LatitudeLabel" : "GridElement_LongitudeLabel";
                LatLonGraticuleLayer.this.addLabel(object.value, string2, string, d, latLon);
            }
            if (this.getSizeInPixels(drawContext) / (double)this.divisions < 80.0) {
                return;
            }
            if (this.subTiles == null) {
                this.createSubTiles();
            }
            for (GraticuleTile graticuleTile : this.subTiles) {
                if (graticuleTile.isInView(drawContext)) {
                    graticuleTile.selectRenderables(drawContext);
                    continue;
                }
                graticuleTile.clearRenderables();
            }
        }

        public void clearRenderables() {
            if (this.gridElements != null) {
                this.gridElements.clear();
                this.gridElements = null;
            }
            if (this.subTiles != null) {
                for (GraticuleTile graticuleTile : this.subTiles) {
                    graticuleTile.clearRenderables();
                }
                this.subTiles.clear();
                this.subTiles = null;
            }
        }

        private void createSubTiles() {
            this.subTiles = new ArrayList();
            Sector[] sectorArray = this.sector.subdivide(this.divisions);
            int n = 10;
            if (LatLonGraticuleLayer.this.getAngleFormat().equals("gov.nasa.worldwind.Geom.AngleDMS") && (this.level == 0 || this.level == 2)) {
                n = 6;
            }
            for (Sector sector : sectorArray) {
                this.subTiles.add(new GraticuleTile(sector, n, this.level + 1));
            }
        }

        private void createRenderables() {
            Object object;
            Object object2;
            Comparable<Angle> comparable;
            this.gridElements = new ArrayList();
            ArrayList<Position> arrayList = new ArrayList<Position>();
            double d = this.sector.getDeltaLatDegrees() / (double)this.divisions;
            for (double d2 = this.sector.getMinLongitude().degrees + (this.level == 0 ? 0.0 : d); d2 < this.sector.getMaxLongitude().degrees - d / 2.0; d2 += d) {
                Angle angle = Angle.fromDegrees(d2);
                arrayList.clear();
                arrayList.add(new Position(this.sector.getMinLatitude(), angle, 0.0));
                arrayList.add(new Position(this.sector.getMaxLatitude(), angle, 0.0));
                Object object3 = LatLonGraticuleLayer.this.createLineRenderable(arrayList, 1);
                comparable = Sector.fromDegrees(this.sector.getMinLatitude().degrees, this.sector.getMaxLatitude().degrees, d2, d2);
                object2 = d2 == this.sector.getMinLongitude().degrees ? "GridElement_LineWest" : "GridElement_Line";
                object = new AbstractGraticuleLayer.GridElement((Sector)comparable, object3, (String)object2);
                ((AbstractGraticuleLayer.GridElement)object).value = d2;
                this.gridElements.add((AbstractGraticuleLayer.GridElement)object);
            }
            for (double d3 = this.sector.getMinLatitude().degrees + (this.level == 0 ? 0.0 : d); d3 < this.sector.getMaxLatitude().degrees - d / 2.0; d3 += d) {
                comparable = Angle.fromDegrees(d3);
                arrayList.clear();
                arrayList.add(new Position((Angle)comparable, this.sector.getMinLongitude(), 0.0));
                arrayList.add(new Position((Angle)comparable, this.sector.getMaxLongitude(), 0.0));
                object2 = LatLonGraticuleLayer.this.createLineRenderable(arrayList, 1);
                object = Sector.fromDegrees(d3, d3, this.sector.getMinLongitude().degrees, this.sector.getMaxLongitude().degrees);
                String string = d3 == this.sector.getMinLatitude().degrees ? "GridElement_LineSouth" : "GridElement_Line";
                AbstractGraticuleLayer.GridElement gridElement = new AbstractGraticuleLayer.GridElement((Sector)object, object2, string);
                gridElement.value = d3;
                this.gridElements.add(gridElement);
            }
        }
    }
}

