/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicExtent;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.BasicQuadTree;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Point;
import java.util.Collection;
import java.util.logging.Level;

public class CachedRenderableLayer
extends AbstractLayer {
    protected static final int DEFAULT_DEPTH = 4;
    protected BasicQuadTree<Renderable> extentTree;
    protected PickSupport pickSupport = new PickSupport();

    public CachedRenderableLayer(Sector sector) {
        this.extentTree = new BasicQuadTree(4, sector, null);
    }

    public CachedRenderableLayer(Sector sector, int n) {
        this.extentTree = new BasicQuadTree(n, sector, null);
    }

    public boolean hasItems() {
        return this.extentTree.hasItems();
    }

    public void add(Renderable renderable) {
        this.add(renderable, null);
    }

    public void add(Renderable renderable, String string) {
        if (!(renderable instanceof GeographicExtent)) {
            String string2 = Logging.getMessage("GeographicTree.NotGeometricExtent");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.extentTree.add(renderable, ((GeographicExtent)renderable).getSector().asDegreesArray(), string);
    }

    public void remove(Renderable renderable) {
        this.extentTree.remove(renderable);
    }

    public void removeByName(String string) {
        this.extentTree.removeByName(string);
    }

    public Collection<? extends Renderable> getRenderables(LatLon latLon) {
        return this.extentTree.getItemsAtLocation(latLon, null);
    }

    public Collection<? extends Renderable> getRenderables(Sector sector) {
        return this.extentTree.getItemsInRegion(sector, null);
    }

    public Iterable<? extends Renderable> getAllRenderables() {
        return this.extentTree;
    }

    public Renderable getByName(String string) {
        return this.extentTree.getByName(string);
    }

    @Override
    public void setOpacity(double d) {
        super.setOpacity(d);
    }

    @Override
    public double getOpacity() {
        return super.getOpacity();
    }

    @Override
    public void dispose() {
        this.disposeRenderables();
    }

    protected void disposeRenderables() {
        for (Renderable renderable : this.getAllRenderables()) {
            try {
                if (!(renderable instanceof Disposable)) continue;
                ((Disposable)((Object)renderable)).dispose();
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionAttemptingToDisposeRenderable");
                Logging.logger().severe(string);
            }
        }
        this.extentTree.clear();
    }

    @Override
    protected void doPreRender(DrawContext drawContext) {
        this.doPreRender(drawContext, this.getAllRenderables());
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        this.doPick(drawContext, this.getAllRenderables(), point);
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        this.doRender(drawContext, this.getAllRenderables());
    }

    protected void doPreRender(DrawContext drawContext, Iterable<? extends Renderable> iterable) {
        for (Renderable renderable : iterable) {
            try {
                if (renderable == null || !(renderable instanceof PreRenderable)) continue;
                ((PreRenderable)((Object)renderable)).preRender(drawContext);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionWhilePrerenderingRenderable");
                Logging.logger().severe(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPick(DrawContext drawContext, Iterable<? extends Renderable> iterable, Point point) {
        this.pickSupport.clearPickList();
        this.pickSupport.beginPicking(drawContext);
        try {
            for (Renderable renderable : iterable) {
                if (renderable == null) continue;
                float[] fArray = new float[4];
                drawContext.getGL().glGetFloatv(2816, fArray, 0);
                Color color = drawContext.getUniquePickColor();
                drawContext.getGL().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                try {
                    renderable.render(drawContext);
                }
                catch (Exception exception) {
                    String string = Logging.getMessage("generic.ExceptionWhilePickingRenderable");
                    Logging.logger().severe(string);
                    continue;
                }
                drawContext.getGL().glColor4fv(fArray, 0);
                if (renderable instanceof Locatable) {
                    this.pickSupport.addPickableObject(color.getRGB(), renderable, ((Locatable)((Object)renderable)).getPosition(), false);
                    continue;
                }
                this.pickSupport.addPickableObject(color.getRGB(), renderable);
            }
            this.pickSupport.resolvePick(drawContext, point, this);
        }
        finally {
            this.pickSupport.endPicking(drawContext);
        }
    }

    protected void doRender(DrawContext drawContext, Iterable<? extends Renderable> iterable) {
        for (Renderable renderable : iterable) {
            try {
                if (renderable == null) continue;
                renderable.render(drawContext);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionWhileRenderingRenderable");
                Logging.logger().log(Level.SEVERE, string, exception);
            }
        }
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.CachedRenderableLayer.Name");
    }
}

