/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import java.util.ArrayList;
import java.util.List;

public class Position
extends LatLon {
    public static final Position ZERO = new Position(Angle.ZERO, Angle.ZERO, 0.0);
    public final double elevation;

    public static Position fromRadians(double d, double d2, double d3) {
        return new Position(Angle.fromRadians(d), Angle.fromRadians(d2), d3);
    }

    public static Position fromDegrees(double d, double d2, double d3) {
        return new Position(Angle.fromDegrees(d), Angle.fromDegrees(d2), d3);
    }

    public static Position fromDegrees(double d, double d2) {
        return new Position(Angle.fromDegrees(d), Angle.fromDegrees(d2), 0.0);
    }

    public Position(Angle angle, Angle angle2, double d) {
        super(angle, angle2);
        this.elevation = d;
    }

    public Position(LatLon latLon, double d) {
        super(latLon);
        this.elevation = d;
    }

    public double getElevation() {
        return this.elevation;
    }

    public double getAltitude() {
        return this.elevation;
    }

    @Override
    public Position add(Position position) {
        Angle angle = Angle.normalizedLatitude(this.latitude.add(position.latitude));
        Angle angle2 = Angle.normalizedLongitude(this.longitude.add(position.longitude));
        return new Position(angle, angle2, this.elevation + position.elevation);
    }

    @Override
    public Position subtract(Position position) {
        Angle angle = Angle.normalizedLatitude(this.latitude.subtract(position.latitude));
        Angle angle2 = Angle.normalizedLongitude(this.longitude.subtract(position.longitude));
        return new Position(angle, angle2, this.elevation - position.elevation);
    }

    public static Position interpolate(double d, Position position, Position position2) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            return position;
        }
        if (d > 1.0) {
            return position2;
        }
        LatLon latLon = LatLon.interpolate(d, position, position2);
        double d2 = WWMath.mix(d, position.getElevation(), position2.getElevation());
        return new Position(latLon, d2);
    }

    public static Position interpolateGreatCircle(double d, Position position, Position position2) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = LatLon.interpolateGreatCircle(d, position, position2);
        double d2 = WWMath.mix(d, position.getElevation(), position2.getElevation());
        return new Position(latLon, d2);
    }

    public static Position interpolateRhumb(double d, Position position, Position position2) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = LatLon.interpolateRhumb(d, position, position2);
        double d2 = WWMath.mix(d, position.getElevation(), position2.getElevation());
        return new Position(latLon, d2);
    }

    public static boolean positionsCrossDateLine(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = null;
        for (Position position : iterable) {
            double d;
            if (latLon != null && Math.signum(latLon.getLongitude().degrees) != Math.signum(position.getLongitude().degrees) && (d = Math.abs(latLon.getLongitude().degrees - position.getLongitude().degrees)) > 180.0 && d < 360.0) {
                return true;
            }
            latLon = position;
        }
        return false;
    }

    public static List<Position> computeShiftedPositions(Position position, Position position2, Iterable<? extends Position> iterable) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Position> arrayList = new ArrayList<Position>();
        double d = position2.getElevation() - position.getElevation();
        for (Position position3 : iterable) {
            Angle angle = LatLon.greatCircleDistance(position, position3);
            Angle angle2 = LatLon.greatCircleAzimuth(position, position3);
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position2, angle2, angle);
            double d2 = position3.getElevation() + d;
            arrayList.add(new Position(latLon, d2));
        }
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Position position = (Position)object;
        return Double.compare(position.elevation, this.elevation) == 0;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        long l = this.elevation != 0.0 ? Double.doubleToLongBits(this.elevation) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    @Override
    public String toString() {
        return "(" + this.latitude.toString() + ", " + this.longitude.toString() + ", " + this.elevation + ")";
    }

    public static class PositionList {
        public List<? extends Position> list;

        public PositionList(List<? extends Position> list) {
            this.list = list;
        }
    }
}

