/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;

public class BilinearInterpolator {
    private Vec4 ll;
    private Vec4 lr;
    private Vec4 ur;
    private Vec4 ul;

    public BilinearInterpolator(Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44) {
        if (vec4 == null || vec42 == null || vec43 == null || vec44 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.ll = vec4;
        this.lr = vec42;
        this.ur = vec43;
        this.ul = vec44;
    }

    public Vec4[] getCorners() {
        return new Vec4[]{this.ll, this.lr, this.ur, this.ul};
    }

    public void interpolate(double d, double d2, double[] dArray) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length < 1) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", dArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d3 = (1.0 - d) * (1.0 - d2);
        double d4 = d * (1.0 - d2);
        double d5 = d * d2;
        double d6 = (1.0 - d) * d2;
        dArray[0] = d3 * this.ll.x + d4 * this.lr.x + d5 * this.ur.x + d6 * this.ul.x;
        dArray[1] = d3 * this.ll.y + d4 * this.lr.y + d5 * this.ur.y + d6 * this.ul.y;
        dArray[2] = d3 * this.ll.z + d4 * this.lr.z + d5 * this.ur.z + d6 * this.ul.z;
        dArray[3] = d3 * this.ll.w + d4 * this.lr.w + d5 * this.ur.w + d6 * this.ul.w;
    }

    public Vec4 interpolateAsPoint(double d, double d2) {
        double[] dArray = new double[4];
        this.interpolate(d, d2, dArray);
        return Vec4.fromArray4(dArray, 0);
    }
}

