/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Quaternion;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Angle
implements Comparable<Angle> {
    public static final String ANGLE_FORMAT_DD = "gov.nasa.worldwind.Geom.AngleDD";
    public static final String ANGLE_FORMAT_DMS = "gov.nasa.worldwind.Geom.AngleDMS";
    public static final Angle ZERO = Angle.fromDegrees(0.0);
    public static final Angle POS90 = Angle.fromDegrees(90.0);
    public static final Angle NEG90 = Angle.fromDegrees(-90.0);
    public static final Angle POS180 = Angle.fromDegrees(180.0);
    public static final Angle NEG180 = Angle.fromDegrees(-180.0);
    public static final Angle POS360 = Angle.fromDegrees(360.0);
    public static final Angle NEG360 = Angle.fromDegrees(-360.0);
    public static final Angle MINUTE = Angle.fromDegrees(0.016666666666666666);
    public static final Angle SECOND = Angle.fromDegrees(2.777777777777778E-4);
    private static final double DEGREES_TO_RADIANS = Math.PI / 180;
    private static final double RADIANS_TO_DEGREES = 57.29577951308232;
    private static final double PIOver2 = 1.5707963267948966;
    public final double degrees;
    public final double radians;

    public static Angle fromDegrees(double d) {
        return new Angle(d, Math.PI / 180 * d);
    }

    public static Angle fromRadians(double d) {
        return new Angle(57.29577951308232 * d, d);
    }

    public static Angle fromDegreesLatitude(double d) {
        d = d < -90.0 ? -90.0 : (d > 90.0 ? 90.0 : d);
        double d2 = Math.PI / 180 * d;
        d2 = d2 < -1.5707963267948966 ? -1.5707963267948966 : (d2 > 1.5707963267948966 ? 1.5707963267948966 : d2);
        return new Angle(d, d2);
    }

    public static Angle fromRadiansLatitude(double d) {
        d = d < -1.5707963267948966 ? -1.5707963267948966 : (d > 1.5707963267948966 ? 1.5707963267948966 : d);
        double d2 = 57.29577951308232 * d;
        d2 = d2 < -90.0 ? -90.0 : (d2 > 90.0 ? 90.0 : d2);
        return new Angle(d2, d);
    }

    public static Angle fromDegreesLongitude(double d) {
        d = d < -180.0 ? -180.0 : (d > 180.0 ? 180.0 : d);
        double d2 = Math.PI / 180 * d;
        d2 = d2 < -Math.PI ? -Math.PI : (d2 > Math.PI ? Math.PI : d2);
        return new Angle(d, d2);
    }

    public static Angle fromRadiansLongitude(double d) {
        d = d < -Math.PI ? -Math.PI : (d > Math.PI ? Math.PI : d);
        double d2 = 57.29577951308232 * d;
        d2 = d2 < -180.0 ? -180.0 : (d2 > 180.0 ? 180.0 : d2);
        return new Angle(d2, d);
    }

    public static Angle fromXY(double d, double d2) {
        double d3 = Math.atan2(d2, d);
        return new Angle(57.29577951308232 * d3, d3);
    }

    public static Angle fromDMS(int n, int n2, int n3) {
        if (n2 < 0 || n2 >= 60) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n3 < 0 || n3 >= 60) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees((double)Math.signum(n) * ((double)Math.abs(n) + (double)n2 / 60.0 + (double)n3 / 3600.0));
    }

    public static Angle fromDMdS(int n, double d) {
        if (d < 0.0 || d >= 60.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees((double)Math.signum(n) * ((double)Math.abs(n) + d / 60.0));
    }

    public static Angle fromDMS(String string) {
        char c;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = "([-|\\+]?\\d{1,3}[d|D|\u00b0|\\s](\\s*\\d{1,2}['|\u2019|\\s])?(\\s*\\d{1,2}[\"|\u201d|\\s])?\\s*([N|n|S|s|E|e|W|w])?\\s?)";
        Pattern pattern = Pattern.compile(string3);
        Matcher matcher = pattern.matcher(string + " ");
        if (!matcher.matches()) {
            String string4 = Logging.getMessage("generic.ArgumentOutOfRange", string);
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        string = string.replaceAll("[D|d|\u00b0|'|\u2019|\"|\u201d]", " ");
        string = string.replaceAll("\\s+", " ");
        string = string.trim();
        int n = 1;
        char c2 = string.toUpperCase().charAt(string.length() - 1);
        if (!Character.isDigit(c2)) {
            n = c2 == 'S' || c2 == 'W' ? -1 : 1;
            string = string.substring(0, string.length() - 1);
            string = string.trim();
        }
        if (!Character.isDigit(c = string.charAt(0))) {
            n *= c == '-' ? -1 : 1;
            string = string.substring(1, string.length());
        }
        String[] stringArray = string.split(" ");
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 0;
        int n4 = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 0;
        return Angle.fromDMS(n2, n3, n4).multiply(n);
    }

    public Angle(Angle angle) {
        this.degrees = angle.degrees;
        this.radians = angle.radians;
    }

    private Angle(double d, double d2) {
        this.degrees = d;
        this.radians = d2;
    }

    public final double getDegrees() {
        return this.degrees;
    }

    public final double getRadians() {
        return this.radians;
    }

    public final Angle add(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees(this.degrees + angle.degrees);
    }

    public final Angle subtract(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees(this.degrees - angle.degrees);
    }

    public final Angle multiply(double d) {
        return Angle.fromDegrees(this.degrees * d);
    }

    public final double divide(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.getDegrees() == 0.0) {
            String string = Logging.getMessage("generic.DivideByZero");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.degrees / angle.degrees;
    }

    public final Angle addDegrees(double d) {
        return Angle.fromDegrees(this.degrees + d);
    }

    public final Angle subtractDegrees(double d) {
        return Angle.fromDegrees(this.degrees - d);
    }

    public final Angle divide(double d) {
        return Angle.fromDegrees(this.degrees / d);
    }

    public final Angle addRadians(double d) {
        return Angle.fromRadians(this.radians + d);
    }

    public final Angle subtractRadians(double d) {
        return Angle.fromRadians(this.radians - d);
    }

    public Angle angularDistanceTo(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.subtract((Angle)this).degrees;
        if (d < -180.0) {
            d += 360.0;
        } else if (d > 180.0) {
            d -= 360.0;
        }
        double d2 = Math.abs(d);
        return Angle.fromDegrees(d2);
    }

    public final double sin() {
        return Math.sin(this.radians);
    }

    public final double sinHalfAngle() {
        return Math.sin(0.5 * this.radians);
    }

    public static Angle asin(double d) {
        return Angle.fromRadians(Math.asin(d));
    }

    public final double cos() {
        return Math.cos(this.radians);
    }

    public final double cosHalfAngle() {
        return Math.cos(0.5 * this.radians);
    }

    public static Angle acos(double d) {
        return Angle.fromRadians(Math.acos(d));
    }

    public final double tanHalfAngle() {
        return Math.tan(0.5 * this.radians);
    }

    public static Angle atan(double d) {
        return Angle.fromRadians(Math.atan(d));
    }

    public static Angle midAngle(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees(0.5 * (angle.degrees + angle2.degrees));
    }

    public static Angle average(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees(0.5 * (angle.degrees + angle2.degrees));
    }

    public static Angle average(Angle angle, Angle angle2, Angle angle3) {
        if (angle == null || angle2 == null || angle3 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees((angle.degrees + angle2.degrees + angle3.degrees) / 3.0);
    }

    public static Angle mix(double d, Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            return angle;
        }
        if (d > 1.0) {
            return angle2;
        }
        Quaternion quaternion = Quaternion.slerp(d, Quaternion.fromAxisAngle(angle, Vec4.UNIT_X), Quaternion.fromAxisAngle(angle2, Vec4.UNIT_X));
        Angle angle3 = quaternion.getRotationX();
        if (Double.isNaN(angle3.degrees)) {
            return null;
        }
        return angle3;
    }

    @Override
    public final int compareTo(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.degrees < angle.degrees) {
            return -1;
        }
        if (this.degrees > angle.degrees) {
            return 1;
        }
        return 0;
    }

    private static double normalizedDegreesLatitude(double d) {
        double d2 = d % 180.0;
        return d2 > 90.0 ? 180.0 - d2 : (d2 < -90.0 ? -180.0 - d2 : d2);
    }

    private static double normalizedDegreesLongitude(double d) {
        double d2 = d % 360.0;
        return d2 > 180.0 ? d2 - 360.0 : (d2 < -180.0 ? 360.0 + d2 : d2);
    }

    public static Angle normalizedLatitude(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees(Angle.normalizedDegreesLatitude(angle.degrees));
    }

    public static Angle normalizedLongitude(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees(Angle.normalizedDegreesLongitude(angle.degrees));
    }

    public Angle normalizedLatitude() {
        return Angle.normalizedLatitude(this);
    }

    public Angle normalizedLongitude() {
        return Angle.normalizedLongitude(this);
    }

    public static boolean crossesLongitudeBoundary(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Math.signum(angle.degrees) != Math.signum(angle2.degrees) && Math.abs(angle.degrees - angle2.degrees) > 180.0;
    }

    public static boolean isValidLatitude(double d) {
        return d >= -90.0 && d <= 90.0;
    }

    public static boolean isValidLongitude(double d) {
        return d >= -180.0 && d <= 180.0;
    }

    public static Angle max(Angle angle, Angle angle2) {
        return angle.degrees >= angle2.degrees ? angle : angle2;
    }

    public static Angle min(Angle angle, Angle angle2) {
        return angle.degrees <= angle2.degrees ? angle : angle2;
    }

    public final String toString() {
        return Double.toString(this.degrees) + '\u00b0';
    }

    public final String toDecimalDegreesString(int n) {
        if (n < 0 || n > 15) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return String.format("%." + n + "f\u00b0", this.degrees);
    }

    public final String toDMSString() {
        double d = this.degrees;
        int n = (int)Math.signum(d);
        int n2 = (int)Math.floor(d *= (double)n);
        d = (d - (double)n2) * 60.0;
        int n3 = (int)Math.floor(d);
        int n4 = (int)Math.round(d = (d - (double)n3) * 60.0);
        if (n4 == 60) {
            ++n3;
            n4 = 0;
        }
        if (n3 == 60) {
            ++n2;
            n3 = 0;
        }
        return (n == -1 ? "-" : "") + n2 + '\u00b0' + ' ' + n3 + '\u2019' + ' ' + n4 + '\u201d';
    }

    public final String toFormattedDMSString() {
        double d = this.degrees;
        int n = (int)Math.signum(d);
        int n2 = (int)Math.floor(d *= (double)n);
        d = (d - (double)n2) * 60.0;
        int n3 = (int)Math.floor(d);
        double d2 = Math.rint((d = (d - (double)n3) * 60.0) * 100.0) / 100.0;
        if (d2 == 60.0) {
            ++n3;
            d2 = 0.0;
        }
        if (n3 == 60) {
            ++n2;
            n3 = 0;
        }
        return String.format("%4d\u00b0 %2d\u2019 %5.2f\u201d", n * n2, n3, d2);
    }

    public final double[] toDMS() {
        double d = this.degrees;
        int n = (int)Math.signum(d);
        int n2 = (int)Math.floor(d *= (double)n);
        d = (d - (double)n2) * 60.0;
        int n3 = (int)Math.floor(d);
        double d2 = Math.rint((d = (d - (double)n3) * 60.0) * 100.0) / 100.0;
        if (d2 == 60.0) {
            ++n3;
            d2 = 0.0;
        }
        if (n3 == 60) {
            ++n2;
            n3 = 0;
        }
        return new double[]{n * n2, n3, d2};
    }

    public long getSizeInBytes() {
        return 8L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Angle angle = (Angle)object;
        return angle.degrees == this.degrees;
    }

    public int hashCode() {
        long l = this.degrees != 0.0 ? Double.doubleToLongBits(this.degrees) : 0L;
        return (int)(l ^ l >>> 32);
    }
}

