/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.VPFFeatureType;
import gov.nasa.worldwind.formats.vpf.VPFSymbolKey;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;

public class VPFSymbolAttributes
extends BasicShapeAttributes {
    private static final Font defaultFont = Font.decode("Arial-PLAIN-12");
    private static final Color defaultColor = Color.WHITE;
    private static final Color defaultBackgroundColor = Color.BLACK;
    private VPFFeatureType featureType;
    private VPFSymbolKey symbolKey;
    private Object iconImageSource;
    private double iconImageScale;
    private boolean mipMapIconImage;
    private LabelAttributes[] labelAttributes;
    private double displayPriority;
    private String orientationAttributeName;
    private String description;

    public VPFSymbolAttributes() {
    }

    public VPFSymbolAttributes(VPFFeatureType vPFFeatureType, VPFSymbolKey vPFSymbolKey) {
        this.featureType = vPFFeatureType;
        this.symbolKey = vPFSymbolKey;
        this.iconImageSource = null;
        this.iconImageScale = 1.0;
        this.mipMapIconImage = true;
        this.labelAttributes = null;
        this.displayPriority = 0.0;
        this.orientationAttributeName = null;
        this.description = null;
    }

    public VPFSymbolAttributes(VPFSymbolAttributes vPFSymbolAttributes) {
        super(vPFSymbolAttributes);
        this.featureType = vPFSymbolAttributes.getFeatureType();
        this.symbolKey = vPFSymbolAttributes.getSymbolKey();
        this.iconImageSource = vPFSymbolAttributes.getIconImageSource();
        this.iconImageScale = vPFSymbolAttributes.getIconImageScale();
        this.mipMapIconImage = vPFSymbolAttributes.isMipMapIconImage();
        this.displayPriority = vPFSymbolAttributes.getDisplayPriority();
        this.orientationAttributeName = vPFSymbolAttributes.getOrientationAttributeName();
        this.description = vPFSymbolAttributes.getDescription();
        if (vPFSymbolAttributes.getLabelAttributes() != null) {
            LabelAttributes[] labelAttributesArray = vPFSymbolAttributes.getLabelAttributes();
            int n = labelAttributesArray.length;
            this.labelAttributes = new LabelAttributes[n];
            for (int i = 0; i < n; ++i) {
                this.labelAttributes[i] = labelAttributesArray[i] != null ? labelAttributesArray[i].copy() : null;
            }
        }
    }

    @Override
    public ShapeAttributes copy() {
        return new VPFSymbolAttributes(this);
    }

    @Override
    public void copy(ShapeAttributes shapeAttributes) {
        super.copy(shapeAttributes);
        if (shapeAttributes instanceof VPFSymbolAttributes) {
            VPFSymbolAttributes vPFSymbolAttributes = (VPFSymbolAttributes)shapeAttributes;
            this.featureType = vPFSymbolAttributes.getFeatureType();
            this.symbolKey = vPFSymbolAttributes.getSymbolKey();
            this.iconImageSource = vPFSymbolAttributes.getIconImageSource();
            this.iconImageScale = vPFSymbolAttributes.getIconImageScale();
            this.mipMapIconImage = vPFSymbolAttributes.isMipMapIconImage();
            this.displayPriority = vPFSymbolAttributes.getDisplayPriority();
            this.orientationAttributeName = vPFSymbolAttributes.getOrientationAttributeName();
            this.description = vPFSymbolAttributes.getDescription();
            if (vPFSymbolAttributes.getLabelAttributes() != null) {
                LabelAttributes[] labelAttributesArray = vPFSymbolAttributes.getLabelAttributes();
                int n = labelAttributesArray.length;
                this.labelAttributes = new LabelAttributes[n];
                for (int i = 0; i < n; ++i) {
                    this.labelAttributes[i] = labelAttributesArray[i] != null ? labelAttributesArray[i].copy() : null;
                }
            }
        }
    }

    public VPFFeatureType getFeatureType() {
        return this.featureType;
    }

    public VPFSymbolKey getSymbolKey() {
        return this.symbolKey;
    }

    public Object getIconImageSource() {
        return this.iconImageSource;
    }

    public void setIconImageSource(Object object) {
        this.iconImageSource = object;
    }

    public double getIconImageScale() {
        return this.iconImageScale;
    }

    public void setIconImageScale(double d) {
        this.iconImageScale = d;
    }

    public boolean isMipMapIconImage() {
        return this.mipMapIconImage;
    }

    public void setMipMapIconImage(boolean bl) {
        this.mipMapIconImage = bl;
    }

    public LabelAttributes[] getLabelAttributes() {
        return this.labelAttributes;
    }

    public void setLabelAttributes(LabelAttributes[] labelAttributesArray) {
        this.labelAttributes = labelAttributesArray;
    }

    public double getDisplayPriority() {
        return this.displayPriority;
    }

    public void setDisplayPriority(double d) {
        this.displayPriority = d;
    }

    public String getOrientationAttributeName() {
        return this.orientationAttributeName;
    }

    public void setOrientationAttributeName(String string) {
        this.orientationAttributeName = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        VPFSymbolAttributes vPFSymbolAttributes = (VPFSymbolAttributes)object;
        if (Double.compare(this.displayPriority, vPFSymbolAttributes.displayPriority) != 0) {
            return false;
        }
        if (Double.compare(this.iconImageScale, vPFSymbolAttributes.iconImageScale) != 0) {
            return false;
        }
        if (this.mipMapIconImage != vPFSymbolAttributes.mipMapIconImage) {
            return false;
        }
        if (this.description != null ? !this.description.equals(vPFSymbolAttributes.description) : vPFSymbolAttributes.description != null) {
            return false;
        }
        if (this.featureType != vPFSymbolAttributes.featureType) {
            return false;
        }
        if (this.iconImageSource != null ? !this.iconImageSource.equals(vPFSymbolAttributes.iconImageSource) : vPFSymbolAttributes.iconImageSource != null) {
            return false;
        }
        if (!Arrays.equals(this.labelAttributes, vPFSymbolAttributes.labelAttributes)) {
            return false;
        }
        if (this.orientationAttributeName != null ? !this.orientationAttributeName.equals(vPFSymbolAttributes.orientationAttributeName) : vPFSymbolAttributes.orientationAttributeName != null) {
            return false;
        }
        return !(this.symbolKey != null ? !this.symbolKey.equals(vPFSymbolAttributes.symbolKey) : vPFSymbolAttributes.symbolKey != null);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.featureType != null ? this.featureType.hashCode() : 0);
        n = 31 * n + (this.symbolKey != null ? this.symbolKey.hashCode() : 0);
        n = 31 * n + (this.iconImageSource != null ? this.iconImageSource.hashCode() : 0);
        long l = this.iconImageScale != 0.0 ? Double.doubleToLongBits(this.iconImageScale) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.mipMapIconImage ? 1 : 0);
        n = 31 * n + (this.labelAttributes != null ? Arrays.hashCode(this.labelAttributes) : 0);
        l = this.displayPriority != 0.0 ? Double.doubleToLongBits(this.displayPriority) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.orientationAttributeName != null ? this.orientationAttributeName.hashCode() : 0);
        n = 31 * n + (this.description != null ? this.description.hashCode() : 0);
        return n;
    }

    public static class LabelAttributes {
        private Font font;
        private Color color;
        private Color backgroundColor;
        private double offset;
        private Angle offsetAngle;
        private String prepend;
        private String append;
        private String attributeName;
        private int abbreviationTableId;

        public LabelAttributes() {
            this.font = defaultFont;
            this.color = defaultColor;
            this.backgroundColor = defaultBackgroundColor;
        }

        public LabelAttributes(LabelAttributes labelAttributes) {
            if (labelAttributes == null) {
                String string = Logging.getMessage("nullValue.AttributesIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.font = labelAttributes.getFont();
            this.color = labelAttributes.getColor();
            this.backgroundColor = labelAttributes.getBackgroundColor();
            this.offset = labelAttributes.getOffset();
            this.offsetAngle = labelAttributes.getOffsetAngle();
            this.prepend = labelAttributes.getPrepend();
            this.append = labelAttributes.getAppend();
            this.attributeName = labelAttributes.getAttributeName();
            this.abbreviationTableId = labelAttributes.getAbbreviationTableId();
        }

        public LabelAttributes copy() {
            return new LabelAttributes(this);
        }

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Color getBackgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundColor(Color color) {
            this.backgroundColor = color;
        }

        public double getOffset() {
            return this.offset;
        }

        public void setOffset(double d) {
            this.offset = d;
        }

        public Angle getOffsetAngle() {
            return this.offsetAngle;
        }

        public void setOffsetAngle(Angle angle) {
            this.offsetAngle = angle;
        }

        public String getPrepend() {
            return this.prepend;
        }

        public void setPrepend(String string) {
            this.prepend = string;
        }

        public String getAppend() {
            return this.append;
        }

        public void setAppend(String string) {
            this.append = string;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setAttributeName(String string) {
            this.attributeName = string;
        }

        public int getAbbreviationTableId() {
            return this.abbreviationTableId;
        }

        public void setAbbreviationTableId(int n) {
            this.abbreviationTableId = n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LabelAttributes labelAttributes = (LabelAttributes)object;
            if (this.abbreviationTableId != labelAttributes.abbreviationTableId) {
                return false;
            }
            if (Double.compare(this.offset, labelAttributes.offset) != 0) {
                return false;
            }
            if (this.append != null ? !this.append.equals(labelAttributes.append) : labelAttributes.append != null) {
                return false;
            }
            if (this.attributeName != null ? !this.attributeName.equals(labelAttributes.attributeName) : labelAttributes.attributeName != null) {
                return false;
            }
            if (this.backgroundColor != null ? !this.backgroundColor.equals(labelAttributes.backgroundColor) : labelAttributes.backgroundColor != null) {
                return false;
            }
            if (this.color != null ? !this.color.equals(labelAttributes.color) : labelAttributes.color != null) {
                return false;
            }
            if (this.font != null ? !this.font.equals(labelAttributes.font) : labelAttributes.font != null) {
                return false;
            }
            if (this.offsetAngle != null ? !this.offsetAngle.equals(labelAttributes.offsetAngle) : labelAttributes.offsetAngle != null) {
                return false;
            }
            return !(this.prepend != null ? !this.prepend.equals(labelAttributes.prepend) : labelAttributes.prepend != null);
        }

        public int hashCode() {
            int n = this.font != null ? this.font.hashCode() : 0;
            n = 31 * n + (this.color != null ? this.color.hashCode() : 0);
            n = 31 * n + (this.backgroundColor != null ? this.backgroundColor.hashCode() : 0);
            long l = this.offset != 0.0 ? Double.doubleToLongBits(this.offset) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            n = 31 * n + (this.offsetAngle != null ? this.offsetAngle.hashCode() : 0);
            n = 31 * n + (this.prepend != null ? this.prepend.hashCode() : 0);
            n = 31 * n + (this.append != null ? this.append.hashCode() : 0);
            n = 31 * n + (this.attributeName != null ? this.attributeName.hashCode() : 0);
            n = 31 * n + this.abbreviationTableId;
            return n;
        }
    }
}

