/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.VPFDataBuffer;
import gov.nasa.worldwind.formats.vpf.VPFDataBufferFactory;
import gov.nasa.worldwind.formats.vpf.VPFTripletId;
import gov.nasa.worldwind.util.BufferFactory;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.CompoundStringBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.VecBuffer;
import gov.nasa.worldwind.util.VecBufferSequence;
import gov.nasa.worldwind.util.WWBufferUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public abstract class VPFBasicDataBufferFactory
implements VPFDataBufferFactory {
    public static final short NO_VALUE_SHORT = Short.MIN_VALUE;
    public static final int NO_VALUE_INT = Integer.MIN_VALUE;

    public static boolean isNoValueShort(short s) {
        return s == Short.MIN_VALUE;
    }

    public static boolean isNoValueInt(int n) {
        return n == Integer.MIN_VALUE;
    }

    public static boolean isNoValueFloat(float f) {
        return Float.isNaN(f);
    }

    public static boolean isNoValueDouble(double d) {
        return Double.isNaN(d);
    }

    public static boolean isNoValueText(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        switch (string.length()) {
            case 1: {
                return string.equals("-");
            }
            case 2: {
                return string.equals("--");
            }
        }
        return string.equalsIgnoreCase("N/A");
    }

    protected static class VecDataBuffer
    implements VPFDataBuffer {
        protected VecReader reader;
        protected VecBufferSequence buffer;

        public VecDataBuffer(VecReader vecReader, int n, BufferFactory bufferFactory, int n2, int n3) {
            int n4 = Math.max(1, n3);
            BufferWrapper bufferWrapper = bufferFactory.newBuffer((1 + n2) * n * n4);
            this.reader = vecReader;
            this.buffer = new VecBufferSequence(new VecBuffer(n, bufferWrapper), 1 + n2);
            this.buffer.append(VecBuffer.emptyVecBuffer(n));
        }

        @Override
        public Object get(int n) {
            return this.buffer.subBuffer(n);
        }

        @Override
        public Object getBackingData() {
            return this.buffer;
        }

        @Override
        public boolean hasValue(int n) {
            return this.buffer.subBufferSize(n) > 0;
        }

        @Override
        public void read(ByteBuffer byteBuffer) {
            int n = byteBuffer.getInt();
            this.read(byteBuffer, n);
        }

        @Override
        public void read(ByteBuffer byteBuffer, int n) {
            VecBuffer vecBuffer = this.reader.read(byteBuffer, n);
            if (vecBuffer != null) {
                this.buffer.append(vecBuffer);
            } else {
                this.buffer.append(VecBuffer.emptyVecBuffer(this.buffer.getCoordsPerVec()));
            }
        }
    }

    protected static class DoubleVecReader
    extends AbstractVecReader {
        private double[] tmpBuffer;

        public DoubleVecReader(int n) {
            super(n, 8);
        }

        @Override
        protected BufferWrapper doRead(ByteBuffer byteBuffer) {
            DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
            if (this.replaceNaN(doubleBuffer, 0.0) <= 0) {
                return null;
            }
            return new BufferWrapper.DoubleBufferWrapper(doubleBuffer);
        }

        protected int replaceNaN(DoubleBuffer doubleBuffer, double d) {
            int n = doubleBuffer.remaining();
            int n2 = 0;
            if (this.tmpBuffer == null || this.tmpBuffer.length < doubleBuffer.remaining()) {
                this.tmpBuffer = new double[n];
            }
            doubleBuffer.get(this.tmpBuffer, 0, n);
            doubleBuffer.flip();
            for (int i = 0; i < n; ++i) {
                if (VPFBasicDataBufferFactory.isNoValueDouble(this.tmpBuffer[i])) {
                    this.tmpBuffer[i] = d;
                    continue;
                }
                ++n2;
            }
            doubleBuffer.put(this.tmpBuffer, 0, n);
            doubleBuffer.flip();
            return n2;
        }
    }

    protected static class FloatVecReader
    extends AbstractVecReader {
        private float[] tmpBuffer;

        public FloatVecReader(int n) {
            super(n, 4);
        }

        @Override
        protected BufferWrapper doRead(ByteBuffer byteBuffer) {
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            if (this.replaceNaN(floatBuffer, 0.0f) <= 0) {
                return null;
            }
            return new BufferWrapper.FloatBufferWrapper(floatBuffer);
        }

        protected int replaceNaN(FloatBuffer floatBuffer, float f) {
            int n = floatBuffer.remaining();
            int n2 = 0;
            if (this.tmpBuffer == null || this.tmpBuffer.length < floatBuffer.remaining()) {
                this.tmpBuffer = new float[n];
            }
            floatBuffer.get(this.tmpBuffer, 0, n);
            floatBuffer.flip();
            for (int i = 0; i < n; ++i) {
                if (VPFBasicDataBufferFactory.isNoValueFloat(this.tmpBuffer[i])) {
                    this.tmpBuffer[i] = f;
                    continue;
                }
                ++n2;
            }
            floatBuffer.put(this.tmpBuffer, 0, n);
            floatBuffer.flip();
            return n2;
        }
    }

    protected static class IntVecReader
    extends AbstractVecReader {
        private int[] tmpBuffer;

        public IntVecReader(int n) {
            super(n, 4);
        }

        @Override
        protected BufferWrapper doRead(ByteBuffer byteBuffer) {
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            if (this.replaceNaN(intBuffer, 0) <= 0) {
                return null;
            }
            return new BufferWrapper.IntBufferWrapper(intBuffer);
        }

        protected int replaceNaN(IntBuffer intBuffer, int n) {
            int n2 = intBuffer.remaining();
            int n3 = 0;
            if (this.tmpBuffer == null || this.tmpBuffer.length < intBuffer.remaining()) {
                this.tmpBuffer = new int[n2];
            }
            intBuffer.get(this.tmpBuffer, 0, n2);
            intBuffer.flip();
            for (int i = 0; i < n2; ++i) {
                if (VPFBasicDataBufferFactory.isNoValueInt(this.tmpBuffer[i])) {
                    this.tmpBuffer[i] = n;
                    continue;
                }
                ++n3;
            }
            intBuffer.put(this.tmpBuffer, 0, n2);
            intBuffer.flip();
            return n3;
        }
    }

    protected static class ShortVecReader
    extends AbstractVecReader {
        private short[] tmpBuffer;

        public ShortVecReader(int n) {
            super(n, 2);
        }

        @Override
        protected BufferWrapper doRead(ByteBuffer byteBuffer) {
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            if (this.replaceNaN(shortBuffer, (short)0) <= 0) {
                return null;
            }
            return new BufferWrapper.ShortBufferWrapper(shortBuffer);
        }

        protected int replaceNaN(ShortBuffer shortBuffer, short s) {
            int n = shortBuffer.remaining();
            int n2 = 0;
            if (this.tmpBuffer == null || this.tmpBuffer.length < shortBuffer.remaining()) {
                this.tmpBuffer = new short[n];
            }
            shortBuffer.get(this.tmpBuffer, 0, n);
            shortBuffer.flip();
            for (int i = 0; i < n; ++i) {
                if (VPFBasicDataBufferFactory.isNoValueShort(this.tmpBuffer[i])) {
                    this.tmpBuffer[i] = s;
                    continue;
                }
                ++n2;
            }
            shortBuffer.put(this.tmpBuffer, 0, n);
            shortBuffer.flip();
            return n2;
        }
    }

    protected static abstract class AbstractVecReader
    implements VecReader {
        protected int coordsPerElem;
        protected int bytesPerCoord;

        public AbstractVecReader(int n, int n2) {
            this.coordsPerElem = n;
            this.bytesPerCoord = n2;
        }

        @Override
        public int getCoordsPerElem() {
            return this.coordsPerElem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VecBuffer read(ByteBuffer byteBuffer, int n) {
            VecBuffer vecBuffer = null;
            int n2 = byteBuffer.limit();
            int n3 = byteBuffer.position() + this.coordsPerElem * this.bytesPerCoord * n;
            try {
                byteBuffer.limit(n3);
                BufferWrapper bufferWrapper = this.doRead(byteBuffer);
                vecBuffer = new VecBuffer(this.coordsPerElem, bufferWrapper);
            }
            finally {
                byteBuffer.limit(n2);
                byteBuffer.position(n3);
            }
            return vecBuffer;
        }

        protected abstract BufferWrapper doRead(ByteBuffer var1);
    }

    protected static interface VecReader {
        public int getCoordsPerElem();

        public VecBuffer read(ByteBuffer var1, int var2);
    }

    protected static class ScalarDataBuffer
    implements VPFDataBuffer {
        protected ScalarReader reader;
        protected ScalarAccessor accessor;
        protected BufferWrapper buffer;
        protected int position;

        public ScalarDataBuffer(ScalarReader scalarReader, ScalarAccessor scalarAccessor, BufferFactory bufferFactory, int n) {
            this.reader = scalarReader;
            this.accessor = scalarAccessor;
            this.buffer = bufferFactory.newBuffer(1 + n);
            this.position = 1;
        }

        @Override
        public Object get(int n) {
            return this.accessor.get(this.buffer, n);
        }

        @Override
        public Object getBackingData() {
            return this.buffer;
        }

        @Override
        public boolean hasValue(int n) {
            return this.accessor.hasValue(this.buffer, n);
        }

        @Override
        public void read(ByteBuffer byteBuffer) {
            double d = this.reader.read(byteBuffer);
            this.buffer.putDouble(this.position, d);
            ++this.position;
        }

        @Override
        public void read(ByteBuffer byteBuffer, int n) {
            this.read(byteBuffer);
        }
    }

    protected static class DoubleAccessor
    implements ScalarAccessor {
        protected DoubleAccessor() {
        }

        @Override
        public Object get(BufferWrapper bufferWrapper, int n) {
            return bufferWrapper.getDouble(n);
        }

        @Override
        public boolean hasValue(BufferWrapper bufferWrapper, int n) {
            return !VPFBasicDataBufferFactory.isNoValueDouble(bufferWrapper.getDouble(n));
        }
    }

    protected static class FloatAccessor
    extends DoubleAccessor {
        protected FloatAccessor() {
        }

        @Override
        public boolean hasValue(BufferWrapper bufferWrapper, int n) {
            return !VPFBasicDataBufferFactory.isNoValueFloat((float)bufferWrapper.getDouble(n));
        }
    }

    protected static class IntAccessor
    implements ScalarAccessor {
        protected IntAccessor() {
        }

        @Override
        public Object get(BufferWrapper bufferWrapper, int n) {
            return bufferWrapper.getInt(n);
        }

        @Override
        public boolean hasValue(BufferWrapper bufferWrapper, int n) {
            return !VPFBasicDataBufferFactory.isNoValueInt(bufferWrapper.getInt(n));
        }
    }

    protected static class ShortAccessor
    extends IntAccessor {
        protected ShortAccessor() {
        }

        @Override
        public boolean hasValue(BufferWrapper bufferWrapper, int n) {
            return !VPFBasicDataBufferFactory.isNoValueShort((short)bufferWrapper.getInt(n));
        }
    }

    protected static class DoubleReader
    implements ScalarReader {
        protected DoubleReader() {
        }

        @Override
        public double read(ByteBuffer byteBuffer) {
            return byteBuffer.getDouble();
        }
    }

    protected static class FloatReader
    implements ScalarReader {
        protected FloatReader() {
        }

        @Override
        public double read(ByteBuffer byteBuffer) {
            return byteBuffer.getFloat();
        }
    }

    protected static class IntReader
    implements ScalarReader {
        protected IntReader() {
        }

        @Override
        public double read(ByteBuffer byteBuffer) {
            return byteBuffer.getInt();
        }
    }

    protected static class ShortReader
    implements ScalarReader {
        protected ShortReader() {
        }

        @Override
        public double read(ByteBuffer byteBuffer) {
            return byteBuffer.getShort();
        }
    }

    protected static interface ScalarAccessor {
        public Object get(BufferWrapper var1, int var2);

        public boolean hasValue(BufferWrapper var1, int var2);
    }

    protected static interface ScalarReader {
        public double read(ByteBuffer var1);
    }

    protected static class TextDataBuffer
    implements VPFDataBuffer {
        protected int elementsPerRow;
        protected TextReader reader;
        protected CompoundStringBuilder buffer;
        protected CharBuffer tmpBuffer;

        public TextDataBuffer(String string, int n, int n2) {
            int n3 = Math.max(1, n2);
            this.elementsPerRow = n2;
            this.reader = new TextReader(string);
            this.buffer = new CompoundStringBuilder(new StringBuilder((1 + n) * n3), 1 + n);
            this.buffer.append("");
        }

        @Override
        public Object get(int n) {
            String string = this.buffer.substring(n);
            return string != null ? string.trim() : null;
        }

        @Override
        public Object getBackingData() {
            return this.buffer;
        }

        @Override
        public boolean hasValue(int n) {
            if (this.elementsPerRow < 0) {
                return this.buffer.substringLength(n) > 0;
            }
            return !VPFBasicDataBufferFactory.isNoValueText(this.buffer.substring(n).trim());
        }

        @Override
        public void read(ByteBuffer byteBuffer) {
            int n = byteBuffer.getInt();
            this.read(byteBuffer, n);
        }

        @Override
        public void read(ByteBuffer byteBuffer, int n) {
            if (this.tmpBuffer == null || this.tmpBuffer.capacity() < n) {
                this.tmpBuffer = WWBufferUtil.newCharBuffer(n, true);
            }
            this.tmpBuffer.clear();
            this.tmpBuffer.limit(n);
            this.reader.read(byteBuffer, n, this.tmpBuffer);
            this.buffer.append(this.tmpBuffer);
        }
    }

    protected static class TextReader {
        protected CharsetDecoder decoder;

        public TextReader(String string) {
            try {
                Charset charset = Charset.forName(string);
                this.decoder = charset.newDecoder();
                this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
                this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                String string2 = Logging.getMessage("generic.InvalidCharsetName", string);
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                String string3 = Logging.getMessage("generic.InvalidCharsetName", string);
                Logging.logger().severe(string3);
                throw new IllegalArgumentException(string3);
            }
        }

        public void read(ByteBuffer byteBuffer, int n, CharBuffer charBuffer) {
            int n2 = byteBuffer.position() + n;
            int n3 = byteBuffer.limit();
            byteBuffer.limit(n2);
            this.decoder.reset();
            this.decoder.decode(byteBuffer, charBuffer, true);
            this.decoder.flush(charBuffer);
            byteBuffer.position(n2);
            byteBuffer.limit(n3);
            charBuffer.flip();
        }

        public CharBuffer read(ByteBuffer byteBuffer, int n) {
            CharBuffer charBuffer = CharBuffer.allocate(n);
            this.read(byteBuffer, n, charBuffer);
            return charBuffer;
        }
    }

    protected static class TripletIdReader
    implements GenericReader {
        protected TripletIdReader() {
        }

        @Override
        public Object read(ByteBuffer byteBuffer) {
            byte by = byteBuffer.get();
            if (by == 0) {
                return null;
            }
            int n = TripletIdReader.readId(byteBuffer, by >> 6);
            int n2 = TripletIdReader.readId(byteBuffer, by >> 4);
            int n3 = TripletIdReader.readId(byteBuffer, by >> 2);
            return new VPFTripletId(n, n2, n3);
        }

        protected static int readId(ByteBuffer byteBuffer, int n) {
            switch (n & 3) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return 0xFF & byteBuffer.get();
                }
                case 2: {
                    return 0xFFFF & byteBuffer.getShort();
                }
                case 3: {
                    return byteBuffer.getInt();
                }
            }
            return -1;
        }
    }

    protected static class DateTimeReader
    implements GenericReader {
        protected TextReader textReader = new TextReader("US-ASCII");

        protected DateTimeReader() {
        }

        @Override
        public Object read(ByteBuffer byteBuffer) {
            CharBuffer charBuffer = this.textReader.read(byteBuffer, 20);
            if (charBuffer.length() == 0) {
                return null;
            }
            return null;
        }

        protected static String makeDatePattern(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.length();
            stringBuilder.append("yyyy");
            if (n > 4) {
                stringBuilder.append("MM");
            }
            if (n > 6) {
                stringBuilder.append("dd");
            }
            if (n > 8) {
                stringBuilder.append("HHmmss");
            }
            if (n > 14) {
                stringBuilder.append(string, 14, 15);
            }
            if (n > 16) {
                stringBuilder.append("ZZZZ");
            } else if (n == 16) {
                stringBuilder.append("Z");
            }
            return stringBuilder.toString();
        }
    }

    protected static class GenericDataBuffer
    implements VPFDataBuffer {
        protected GenericReader reader;
        protected Object[] array;
        protected int position;

        public GenericDataBuffer(GenericReader genericReader, int n) {
            this.reader = genericReader;
            this.array = new Object[1 + n];
            this.position = 1;
        }

        @Override
        public Object get(int n) {
            return this.array[n];
        }

        @Override
        public Object getBackingData() {
            return this.array;
        }

        @Override
        public boolean hasValue(int n) {
            return this.get(n) != null;
        }

        @Override
        public void read(ByteBuffer byteBuffer) {
            Object object;
            this.array[this.position] = object = this.reader.read(byteBuffer);
            ++this.position;
        }

        @Override
        public void read(ByteBuffer byteBuffer, int n) {
            this.read(byteBuffer);
        }
    }

    protected static interface GenericReader {
        public Object read(ByteBuffer var1);
    }

    protected static class NullDataBuffer
    implements VPFDataBuffer {
        protected NullDataBuffer() {
        }

        @Override
        public Object get(int n) {
            return null;
        }

        @Override
        public Object getBackingData() {
            return null;
        }

        @Override
        public boolean hasValue(int n) {
            return false;
        }

        @Override
        public void read(ByteBuffer byteBuffer) {
        }

        @Override
        public void read(ByteBuffer byteBuffer, int n) {
        }
    }

    public static class DoubleVecDataFactory
    extends VecDataFactory {
        public DoubleVecDataFactory(int n) {
            super(n);
        }

        @Override
        public VPFDataBuffer newDataBuffer(int n, int n2) {
            return new VecDataBuffer(new DoubleVecReader(this.coordsPerElem), this.coordsPerElem, new BufferFactory.DoubleBufferFactory(), n, n2);
        }
    }

    public static class FloatVecDataFactory
    extends VecDataFactory {
        public FloatVecDataFactory(int n) {
            super(n);
        }

        @Override
        public VPFDataBuffer newDataBuffer(int n, int n2) {
            return new VecDataBuffer(new FloatVecReader(this.coordsPerElem), this.coordsPerElem, new BufferFactory.FloatBufferFactory(), n, n2);
        }
    }

    public static class IntVecDataFactory
    extends VecDataFactory {
        public IntVecDataFactory(int n) {
            super(n);
        }

        @Override
        public VPFDataBuffer newDataBuffer(int n, int n2) {
            return new VecDataBuffer(new IntVecReader(this.coordsPerElem), this.coordsPerElem, new BufferFactory.IntBufferFactory(), n, n2);
        }
    }

    public static class ShortVecDataFactory
    extends VecDataFactory {
        public ShortVecDataFactory(int n) {
            super(n);
        }

        @Override
        public VPFDataBuffer newDataBuffer(int n, int n2) {
            return new VecDataBuffer(new ShortVecReader(this.coordsPerElem), this.coordsPerElem, new BufferFactory.ShortBufferFactory(), n, n2);
        }
    }

    public static abstract class VecDataFactory
    extends VPFBasicDataBufferFactory {
        protected int coordsPerElem;

        public VecDataFactory(int n) {
            this.coordsPerElem = n;
        }
    }

    public static class DoubleDataFactory
    extends VPFBasicDataBufferFactory {
        @Override
        public VPFDataBuffer newDataBuffer(int n, int n2) {
            return new ScalarDataBuffer(new DoubleReader(), new DoubleAccessor(), new BufferFactory.DoubleBufferFactory(), n);
        }
    }

    public static class FloatDataFactory
    extends VPFBasicDataBufferFactory {
        @Override
        public VPFDataBuffer newDataBuffer(int n, int n2) {
            return new ScalarDataBuffer(new FloatReader(), new DoubleAccessor(), new BufferFactory.FloatBufferFactory(), n);
        }
    }

    public static class IntDataFactory
    extends VPFBasicDataBufferFactory {
        @Override
        public VPFDataBuffer newDataBuffer(int n, int n2) {
            return new ScalarDataBuffer(new IntReader(), new IntAccessor(), new BufferFactory.IntBufferFactory(), n);
        }
    }

    public static class ShortDataFactory
    extends VPFBasicDataBufferFactory {
        @Override
        public VPFDataBuffer newDataBuffer(int n, int n2) {
            return new ScalarDataBuffer(new ShortReader(), new IntAccessor(), new BufferFactory.ShortBufferFactory(), n);
        }
    }

    public static class TextDataFactory
    extends VPFBasicDataBufferFactory {
        protected String charsetName;

        public TextDataFactory(String string) {
            this.charsetName = string;
        }

        @Override
        public VPFDataBuffer newDataBuffer(int n, int n2) {
            return new TextDataBuffer(this.charsetName, n, n2);
        }
    }

    public static class TripledIdDataFactory
    extends VPFBasicDataBufferFactory {
        @Override
        public VPFDataBuffer newDataBuffer(int n, int n2) {
            return new GenericDataBuffer(new TripletIdReader(), n);
        }
    }

    public static class DateTimeDataFactory
    extends VPFBasicDataBufferFactory {
        @Override
        public VPFDataBuffer newDataBuffer(int n, int n2) {
            return new GenericDataBuffer(new DateTimeReader(), n);
        }
    }

    public static class NullDataFactory
    extends VPFBasicDataBufferFactory {
        @Override
        public VPFDataBuffer newDataBuffer(int n, int n2) {
            return new NullDataBuffer();
        }
    }
}

