/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

import gov.nasa.worldwind.Version;
import gov.nasa.worldwind.formats.tiff.GeotiffImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class GeotiffImageReaderSpi
extends ImageReaderSpi {
    private static GeotiffImageReaderSpi theInstance = null;
    private static final String vendorName = Version.getVersionName();
    private static final String version = Version.getVersionNumber();
    private static final String[] names = new String[]{"tiff", "GTiff", "geotiff"};
    private static final String[] suffixes = new String[]{"tif", "tiff", "gtif"};
    private static final String[] mimeTypes = new String[]{"image/tiff", "image/geotiff"};
    private static final String readerClassname = "gov.nasa.worldwind.servers.wms.utilities.TiffImageReader";

    public static GeotiffImageReaderSpi inst() {
        if (theInstance == null) {
            theInstance = new GeotiffImageReaderSpi();
        }
        return theInstance;
    }

    private GeotiffImageReaderSpi() {
        super(vendorName, version, names, suffixes, mimeTypes, readerClassname, new Class[]{ImageInputStream.class}, null, false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        if (object == null || !(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        byte[] byArray = new byte[8];
        try {
            imageInputStream.mark();
            imageInputStream.readFully(byArray);
            imageInputStream.reset();
        }
        catch (IOException iOException) {
            return false;
        }
        return byArray[0] == 77 && byArray[1] == 77 && byArray[2] == 0 && byArray[3] == 42 || byArray[0] == 73 && byArray[1] == 73 && byArray[2] == 42 && byArray[3] == 0;
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IOException {
        return new GeotiffImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "NASA WorldWind Geotiff Image Reader";
    }
}

