/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.exception.WWUnrecognizedException;
import gov.nasa.worldwind.formats.shapefile.DBaseField;
import gov.nasa.worldwind.formats.shapefile.DBaseRecord;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;

public class DBaseFile
extends AVListImpl {
    protected static final int FIXED_HEADER_LENGTH = 32;
    protected static final int FIELD_DESCRIPTOR_LENGTH = 32;
    protected static String[] DBASE_CONTENT_TYPES = new String[]{"application/dbase", "application/dbf", "application/octet-stream"};
    protected Header header;
    protected DBaseField[] fields;
    protected ReadableByteChannel channel;
    protected boolean open;
    protected int numRecordsRead;
    protected ByteBuffer recordBuffer;

    public DBaseFile(Object object) {
        block7: {
            if (object == null || WWUtil.isEmpty(object)) {
                String string = Logging.getMessage("nullValue.SourceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            try {
                this.setValue("gov.nasa.worldwind.avkey.DisplayName", object.toString());
                if (object instanceof File) {
                    this.initializeFromFile((File)object);
                    break block7;
                }
                if (object instanceof URL) {
                    this.initializeFromURL((URL)object);
                    break block7;
                }
                if (object instanceof InputStream) {
                    this.initializeFromStream((InputStream)object);
                    break block7;
                }
                if (object instanceof String) {
                    this.initializeFromPath((String)object);
                    break block7;
                }
                String string = Logging.getMessage("generic.UnrecognizedSourceType", object);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("SHP.ExceptionAttemptingToReadDBase", this.getValue("gov.nasa.worldwind.avkey.DisplayName"));
                Logging.logger().log(Level.SEVERE, string, exception);
                throw new WWRuntimeException(string, exception);
            }
        }
    }

    public DBaseFile(InputStream inputStream) {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            this.setValue("gov.nasa.worldwind.avkey.DisplayName", inputStream.toString());
            this.initializeFromStream(inputStream);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("SHP.ExceptionAttemptingToReadDBase", this.getValue("gov.nasa.worldwind.avkey.DisplayName"));
            Logging.logger().log(Level.SEVERE, string, exception);
            throw new WWRuntimeException(string, exception);
        }
    }

    public Date getLastModificationDate() {
        return this.header.lastModificationDate;
    }

    public int getNumberOfRecords() {
        return this.header.numberOfRecords;
    }

    public int getHeaderLength() {
        return this.header.headerLength;
    }

    public int getRecordLength() {
        return this.header.recordLength;
    }

    public int getNumberOfFields() {
        return (this.header.headerLength - 1 - 32) / 32;
    }

    public DBaseField[] getFields() {
        return this.fields;
    }

    public boolean hasNext() {
        return this.open && this.numRecordsRead < this.header.numberOfRecords;
    }

    public DBaseRecord nextRecord() {
        if (!this.open) {
            String string = Logging.getMessage("SHP.DBaseFileClosed", this.getValue("gov.nasa.worldwind.avkey.DisplayName"));
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (this.getNumberOfRecords() <= 0 || this.numRecordsRead >= this.getNumberOfRecords()) {
            String string = Logging.getMessage("SHP.NoRecords", this.getValue("gov.nasa.worldwind.avkey.DisplayName"));
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        try {
            return this.readNextRecord();
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("SHP.ExceptionAttemptingToReadDBaseRecord", this.getValue("gov.nasa.worldwind.avkey.DisplayName"));
            Logging.logger().log(Level.SEVERE, string, iOException);
            throw new WWRuntimeException(string, iOException);
        }
    }

    public void close() {
        if (this.channel != null) {
            WWIO.closeStream(this.channel, null);
            this.channel = null;
        }
        this.open = false;
        this.recordBuffer = null;
    }

    protected void initializeFromFile(File file) throws IOException {
        if (!file.exists()) {
            String string = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string);
            throw new FileNotFoundException(string);
        }
        this.channel = Channels.newChannel(WWIO.getBufferedInputStream(new FileInputStream(file)));
        this.initialize();
    }

    protected void initializeFromURL(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        String string = this.validateURLConnection(uRLConnection, DBASE_CONTENT_TYPES);
        if (string != null) {
            throw new IOException(string);
        }
        this.channel = Channels.newChannel(WWIO.getBufferedInputStream(uRLConnection.getInputStream()));
        this.initialize();
    }

    protected void initializeFromStream(InputStream inputStream) throws IOException {
        this.channel = Channels.newChannel(WWIO.getBufferedInputStream(inputStream));
        this.initialize();
    }

    protected void initializeFromPath(String string) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            this.initializeFromFile(file);
            return;
        }
        URL uRL = WWIO.makeURL(string);
        if (uRL != null) {
            this.initializeFromURL(uRL);
            return;
        }
        String string2 = Logging.getMessage("generic.UnrecognizedSourceType", string);
        Logging.logger().severe(string2);
        throw new IllegalArgumentException(string2);
    }

    protected void initialize() throws IOException {
        this.header = this.readHeader();
        this.fields = this.readFields();
        this.open = true;
    }

    protected String validateURLConnection(URLConnection uRLConnection, String[] stringArray) {
        try {
            if (uRLConnection instanceof HttpURLConnection && ((HttpURLConnection)uRLConnection).getResponseCode() != 200) {
                return Logging.getMessage("HTTP.ResponseCode", ((HttpURLConnection)uRLConnection).getResponseCode(), uRLConnection.getURL());
            }
        }
        catch (Exception exception) {
            return Logging.getMessage("URLRetriever.ErrorOpeningConnection", uRLConnection.getURL());
        }
        String string = uRLConnection.getContentType();
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        for (String string2 : stringArray) {
            if (!string.trim().toLowerCase().startsWith(string2)) continue;
            return null;
        }
        return Logging.getMessage("HTTP.UnexpectedContentType", string, Arrays.toString(stringArray));
    }

    protected Header readHeader() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(32);
        WWIO.readChannelToBuffer(this.channel, byteBuffer);
        if (byteBuffer.remaining() < 32) {
            throw new WWRuntimeException(Logging.getMessage("generic.InvalidFileLength", byteBuffer.remaining()));
        }
        return this.readHeaderFromBuffer(byteBuffer);
    }

    protected Header readHeaderFromBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte by = byteBuffer.get();
        if (by > 5) {
            throw new WWUnrecognizedException(Logging.getMessage("SHP.UnrecognizedDBaseFile", by));
        }
        int n2 = 0xFF & byteBuffer.get();
        byte by2 = byteBuffer.get();
        byte by3 = byteBuffer.get();
        int n3 = byteBuffer.getInt();
        short s = byteBuffer.getShort();
        short s2 = byteBuffer.getShort();
        Header header = new Header();
        header.fileCode = by;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1900 + n2, by2 - 1, by3);
        header.lastModificationDate = calendar.getTime();
        header.numberOfRecords = n3;
        header.headerLength = s;
        header.recordLength = s2;
        byteBuffer.position(n + 32);
        return header;
    }

    protected DBaseField[] readFields() throws IOException {
        int n = this.header.headerLength - 32;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        WWIO.readChannelToBuffer(this.channel, byteBuffer);
        return this.readFieldsFromBuffer(byteBuffer, this.getNumberOfFields());
    }

    protected DBaseField[] readFieldsFromBuffer(ByteBuffer byteBuffer, int n) {
        int n2;
        int n3 = byteBuffer.position();
        DBaseField[] dBaseFieldArray = new DBaseField[n];
        for (n2 = 0; n2 < n; ++n2) {
            dBaseFieldArray[n2] = new DBaseField(this, byteBuffer);
        }
        n2 = this.header.headerLength - 32;
        byteBuffer.position(n3 + n2);
        return dBaseFieldArray;
    }

    protected DBaseRecord readNextRecord() throws IOException {
        if (this.recordBuffer == null) {
            this.recordBuffer = ByteBuffer.allocate(this.getRecordLength());
        }
        this.recordBuffer.limit(this.getRecordLength());
        this.recordBuffer.rewind();
        WWIO.readChannelToBuffer(this.channel, this.recordBuffer);
        return this.readRecordFromBuffer(this.recordBuffer, ++this.numRecordsRead);
    }

    protected DBaseRecord readRecordFromBuffer(ByteBuffer byteBuffer, int n) {
        return new DBaseRecord(this, byteBuffer, n);
    }

    protected int readZeroTerminatedString(ByteBuffer byteBuffer, byte[] byArray, int n) {
        int n2;
        if (n <= 0) {
            return 0;
        }
        byteBuffer.get(byArray, 0, n);
        for (n2 = 0; n2 < n && byArray[n2] != 0; ++n2) {
        }
        return n2;
    }

    protected String decodeString(byte[] byArray, int n) {
        if (n <= 0) {
            return null;
        }
        try {
            return new String(byArray, 0, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, 0, n);
        }
    }

    protected boolean isStringEmpty(byte[] byArray, int n) {
        return n <= 0 || DBaseFile.isArrayFilled(byArray, n, (byte)32) || DBaseFile.isArrayFilled(byArray, n, (byte)42);
    }

    protected static boolean isArrayFilled(byte[] byArray, int n, byte by) {
        if (n <= 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == by) continue;
            return false;
        }
        return true;
    }

    protected static class Header {
        public int fileCode;
        public Date lastModificationDate;
        public int numberOfRecords;
        public int headerLength;
        public int recordLength;

        protected Header() {
        }
    }
}

