/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.Version;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.data.AbstractDataRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;
import java.util.Calendar;
import java.util.logging.Level;

public class BufferedImageRaster
extends AbstractDataRaster
implements Cacheable,
Disposable {
    private BufferedImage bufferedImage;
    private Graphics2D g2d;

    public BufferedImageRaster(Sector sector, BufferedImage bufferedImage) {
        this(sector, bufferedImage, null);
    }

    public BufferedImageRaster(Sector sector, BufferedImage bufferedImage, AVList aVList) {
        super(null != bufferedImage ? bufferedImage.getWidth() : 0, null != bufferedImage ? bufferedImage.getHeight() : 0, sector, aVList);
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.bufferedImage = bufferedImage;
    }

    public BufferedImageRaster(int n, int n2, int n3, Sector sector) {
        super(n, n2, sector);
        if (n < 1) {
            String string = Logging.getMessage("generic.InvalidWidth", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("generic.InvalidHeight", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.bufferedImage = ImageUtil.createCompatibleImage(n, n2, n3);
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public Graphics2D getGraphics() {
        if (this.g2d == null) {
            this.g2d = this.bufferedImage.createGraphics();
            this.g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        return this.g2d;
    }

    @Override
    public void drawOnTo(DataRaster dataRaster) {
        if (dataRaster == null) {
            String string = Logging.getMessage("nullValue.DestinationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!(dataRaster instanceof BufferedImageRaster)) {
            String string = Logging.getMessage("DataRaster.IncompatibleRaster", dataRaster);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doDrawOnTo((BufferedImageRaster)dataRaster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Graphics2D graphics2D = this.getGraphics();
        Color color2 = graphics2D.getColor();
        try {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        finally {
            graphics2D.setColor(color2);
        }
    }

    @Override
    public long getSizeInBytes() {
        DataBuffer dataBuffer;
        long l = 0L;
        WritableRaster writableRaster = this.bufferedImage.getRaster();
        if (writableRaster != null && (dataBuffer = writableRaster.getDataBuffer()) != null) {
            l = BufferedImageRaster.sizeOfDataBuffer(dataBuffer);
        }
        return l;
    }

    @Override
    public void dispose() {
        if (this.g2d != null) {
            this.g2d.dispose();
            this.g2d = null;
        }
        if (this.bufferedImage != null) {
            this.bufferedImage.flush();
            this.bufferedImage = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doDrawOnTo(BufferedImageRaster bufferedImageRaster) {
        block32: {
            AffineTransform affineTransform;
            Object object;
            Object object2;
            Composite composite;
            Shape shape;
            Graphics graphics;
            block31: {
                Sector sector = this.getSector();
                if (null == sector) {
                    String string = Logging.getMessage("nullValue.SectorIsNull");
                    Logging.logger().severe(string);
                    throw new IllegalArgumentException(string);
                }
                if (!sector.intersects(bufferedImageRaster.getSector())) {
                    return;
                }
                graphics = null;
                shape = null;
                composite = null;
                object2 = null;
                object = null;
                int n = bufferedImageRaster.getWidth();
                int n2 = bufferedImageRaster.getHeight();
                affineTransform = this.computeSourceToDestTransform(this.getWidth(), this.getHeight(), this.getSector(), n, n2, bufferedImageRaster.getSector());
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
                Rectangle2D rectangle2D = affineTransformOp.getBounds2D(this.getBufferedImage());
                int n3 = (int)Math.ceil(rectangle2D.getMaxX() >= (double)n ? (double)n : rectangle2D.getMaxX());
                int n4 = (int)Math.ceil(rectangle2D.getMaxY() >= (double)n2 ? (double)n2 : rectangle2D.getMaxY());
                if (n3 > 0 && n4 > 0) break block31;
                try {
                    if (null != graphics) {
                        if (null != shape) {
                            graphics.setClip(shape);
                        }
                        if (null != composite) {
                            ((Graphics2D)graphics).setComposite(composite);
                        }
                        if (null != object2) {
                            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, object2);
                        }
                        if (null != object) {
                            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Logging.logger().log(Level.FINEST, WWUtil.extractExceptionReason(throwable), throwable);
                }
                return;
            }
            graphics = bufferedImageRaster.getGraphics();
            shape = graphics.getClip();
            composite = ((Graphics2D)graphics).getComposite();
            object2 = ((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            object = ((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            ((Graphics2D)graphics).setComposite(AlphaComposite.SrcOver);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)graphics).drawImage(this.getBufferedImage(), affineTransform, null);
            try {
                if (null != graphics) {
                    if (null != shape) {
                        graphics.setClip(shape);
                    }
                    if (null != composite) {
                        ((Graphics2D)graphics).setComposite(composite);
                    }
                    if (null != object2) {
                        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, object2);
                    }
                    if (null != object) {
                        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
                    }
                }
                break block32;
            }
            catch (Throwable throwable) {
                Logging.logger().log(Level.FINEST, WWUtil.extractExceptionReason(throwable), throwable);
            }
            break block32;
            catch (Throwable throwable) {
                try {
                    String string = WWUtil.extractExceptionReason(throwable);
                    Logging.logger().log(Level.SEVERE, string, throwable);
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    try {
                        if (null != graphics) {
                            if (null != shape) {
                                graphics.setClip(shape);
                            }
                            if (null != composite) {
                                ((Graphics2D)graphics).setComposite(composite);
                            }
                            if (null != object2) {
                                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, object2);
                            }
                            if (null != object) {
                                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        Logging.logger().log(Level.FINEST, WWUtil.extractExceptionReason(throwable3), throwable3);
                    }
                }
            }
        }
    }

    private static long sizeOfDataBuffer(DataBuffer dataBuffer) {
        return BufferedImageRaster.sizeOfElement(dataBuffer.getDataType()) * (long)dataBuffer.getSize();
    }

    private static long sizeOfElement(int n) {
        switch (n) {
            case 0: {
                return 1L;
            }
            case 5: {
                return 8L;
            }
            case 4: {
                return 4L;
            }
            case 3: {
                return 4L;
            }
            case 1: 
            case 2: {
                return 2L;
            }
        }
        return 0L;
    }

    public static DataRaster wrap(BufferedImage bufferedImage, AVList aVList) {
        Object object;
        int n;
        if (null == bufferedImage) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (null == aVList) {
            String string = Logging.getMessage("nullValue.AVListIsNull");
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList.hasKey("gov.nasa.worldwind.avkey.Width")) {
            n = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Width");
            if (n != bufferedImage.getWidth()) {
                String string = Logging.getMessage("generic.InvalidWidth", "" + n + "!=" + bufferedImage.getWidth());
                Logging.logger().finest(string);
                throw new IllegalArgumentException(string);
            }
        } else {
            aVList.setValue("gov.nasa.worldwind.avkey.Width", bufferedImage.getWidth());
        }
        if (aVList.hasKey("gov.nasa.worldwind.avkey.Height")) {
            n = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Height");
            if (n != bufferedImage.getHeight()) {
                String string = Logging.getMessage("generic.InvalidHeight", "" + n + "!=" + bufferedImage.getHeight());
                Logging.logger().finest(string);
                throw new IllegalArgumentException(string);
            }
        } else {
            aVList.setValue("gov.nasa.worldwind.avkey.Height", bufferedImage.getHeight());
        }
        Sector sector = null;
        if (aVList.hasKey("gov.nasa.worldwind.avKey.Sector") && (object = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) instanceof Sector) {
            sector = (Sector)object;
        }
        return new BufferedImageRaster(sector, bufferedImage, aVList);
    }

    public static DataRaster wrapAsGeoreferencedRaster(BufferedImage bufferedImage, AVList aVList) {
        double d;
        int n;
        if (null == bufferedImage) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (null == aVList) {
            String string = Logging.getMessage("nullValue.AVListIsNull");
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList.hasKey("gov.nasa.worldwind.avkey.Width") && (n = ((Integer)aVList.getValue("gov.nasa.worldwind.avkey.Width")).intValue()) != bufferedImage.getWidth()) {
            String string = Logging.getMessage("generic.InvalidWidth", "" + n + "!=" + bufferedImage.getWidth());
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList.hasKey("gov.nasa.worldwind.avkey.Height") && (n = ((Integer)aVList.getValue("gov.nasa.worldwind.avkey.Height")).intValue()) != bufferedImage.getHeight()) {
            String string = Logging.getMessage("generic.InvalidHeight", "" + n + "!=" + bufferedImage.getHeight());
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avKey.Sector")) {
            String string = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avKey.Sector");
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        if (null == sector) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem")) {
            aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic");
        }
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.CoordinateSystem");
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Projection.EPSG.Code")) {
            if ("gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(string)) {
                aVList.setValue("gov.nasa.worldwind.avkey.Projection.EPSG.Code", 4326);
            } else {
                String string2 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.Projection.EPSG.Code");
                Logging.logger().finest(string2);
                throw new IllegalArgumentException(string2);
            }
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelWidth")) {
            if ("gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(string)) {
                d = sector.getDeltaLonDegrees() / (double)bufferedImage.getWidth();
                aVList.setValue("gov.nasa.worldwind.avkey.PixelWidth", d);
            } else {
                String string3 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.PixelWidth");
                Logging.logger().finest(string3);
                throw new IllegalArgumentException(string3);
            }
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelHeight")) {
            if ("gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(string)) {
                d = sector.getDeltaLatDegrees() / (double)bufferedImage.getHeight();
                aVList.setValue("gov.nasa.worldwind.avkey.PixelHeight", d);
            } else {
                String string4 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.PixelHeight");
                Logging.logger().finest(string4);
                throw new IllegalArgumentException(string4);
            }
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat")) {
            aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
        } else if (!"gov.nasa.worldwind.avkey.Image".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
            String string5 = Logging.getMessage("generic.UnknownValueForKey", aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"), "gov.nasa.worldwind.avkey.PixelFormat");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Origin") && "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(string)) {
            LatLon latLon = new LatLon(sector.getMaxLatitude(), sector.getMinLongitude());
            aVList.setValue("gov.nasa.worldwind.avkey.Origin", latLon);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.DateTime")) {
            String string6 = String.format("%1$tY:%1$tm:%1$td %tT\u0000", Calendar.getInstance());
            aVList.setValue("gov.nasa.worldwind.avkey.DateTime", string6);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Version")) {
            aVList.setValue("gov.nasa.worldwind.avkey.Version", Version.getVersion());
        }
        boolean bl = null != bufferedImage.getColorModel() && bufferedImage.getColorModel().hasAlpha();
        aVList.setValue("gov.nasa.worldwind.avkey.RasterHasAlpha", bl);
        return new BufferedImageRaster(sector, bufferedImage, aVList);
    }

    @Override
    DataRaster doGetSubRaster(int n, int n2, Sector sector, AVList aVList) {
        int n3 = 3;
        BufferedImageRaster bufferedImageRaster = new BufferedImageRaster(n, n2, n3, sector);
        this.drawOnTo(bufferedImageRaster);
        return bufferedImageRaster;
    }
}

