/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.tree;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.tree.FrameAttributes;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;

public class BasicFrameAttributes
implements FrameAttributes {
    protected double backgroundOpacity;
    protected Color frameColor1;
    protected Color frameColor2;
    protected Color titleBarColor1;
    protected Color titleBarColor2;
    protected Color scrollBarColor1;
    protected Color scrollBarColor2;
    protected Color minimizeButtonColor;
    protected double foregroundOpacity;
    protected Color foregroundColor;
    protected Color textColor;
    protected Font font;
    protected Dimension iconSize;
    protected int iconSpace;
    protected int cornerRadius;

    public BasicFrameAttributes() {
        this.backgroundOpacity = 0.8;
        this.frameColor1 = Color.WHITE;
        this.frameColor2 = new Color(13161182);
        this.titleBarColor1 = new Color(29, 78, 169);
        this.titleBarColor2 = new Color(93, 158, 223);
        this.scrollBarColor1 = new Color(29, 78, 169);
        this.scrollBarColor2 = new Color(93, 158, 223);
        this.minimizeButtonColor = new Color(15440804);
        this.foregroundOpacity = 1.0;
        this.foregroundColor = Color.BLACK;
        this.font = Font.decode("Arial-BOLD-14");
        this.textColor = Color.WHITE;
        this.iconSize = new Dimension(16, 16);
        this.iconSpace = 5;
        this.cornerRadius = 5;
    }

    public BasicFrameAttributes(BasicFrameAttributes basicFrameAttributes) {
        if (basicFrameAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.copy(basicFrameAttributes);
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public void setForegroundColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.foregroundColor = color;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.font = font;
    }

    @Override
    public Color getTextColor() {
        return this.textColor;
    }

    @Override
    public void setTextColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.textColor = color;
    }

    @Override
    public Dimension getIconSize() {
        return this.iconSize;
    }

    @Override
    public void setIconSize(Dimension dimension) {
        if (dimension == null) {
            String string = Logging.getMessage("nullValue.SizeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.iconSize = dimension;
    }

    @Override
    public int getIconSpace() {
        return this.iconSpace;
    }

    @Override
    public void setIconSpace(int n) {
        this.iconSpace = n;
    }

    @Override
    public double getForegroundOpacity() {
        return this.foregroundOpacity;
    }

    @Override
    public void setForegroundOpacity(double d) {
        this.foregroundOpacity = d;
    }

    @Override
    public double getBackgroundOpacity() {
        return this.backgroundOpacity;
    }

    @Override
    public void setBackgroundOpacity(double d) {
        this.backgroundOpacity = d;
    }

    @Override
    public Color[] getBackgroundColor() {
        return new Color[]{this.frameColor1, this.frameColor2};
    }

    @Override
    public void setTitleBarColor(Color color, Color color2) {
        if (color == null || color2 == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.titleBarColor1 = color;
        this.titleBarColor2 = color2;
    }

    @Override
    public Color[] getTitleBarColor() {
        return new Color[]{this.titleBarColor1, this.titleBarColor2};
    }

    @Override
    public Color[] getScrollBarColor() {
        return new Color[]{this.scrollBarColor1, this.scrollBarColor2};
    }

    @Override
    public void setScrollBarColor(Color color, Color color2) {
        if (color == null || color2 == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.scrollBarColor1 = color;
        this.scrollBarColor2 = color2;
    }

    @Override
    public Color getMinimizeButtonColor() {
        return this.minimizeButtonColor;
    }

    @Override
    public void setMinimizeButtonColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minimizeButtonColor = color;
    }

    @Override
    public void setBackgroundColor(Color color, Color color2) {
        if (color == null || color2 == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.frameColor1 = color;
        this.frameColor2 = color2;
    }

    @Override
    public int getCornerRadius() {
        return this.cornerRadius;
    }

    @Override
    public void setCornerRadius(int n) {
        this.cornerRadius = n;
    }

    @Override
    public BasicFrameAttributes copy() {
        return new BasicFrameAttributes(this);
    }

    @Override
    public void copy(FrameAttributes frameAttributes) {
        if (frameAttributes != null) {
            this.backgroundOpacity = frameAttributes.getBackgroundOpacity();
            Color[] colorArray = frameAttributes.getBackgroundColor();
            this.frameColor1 = colorArray[0];
            this.frameColor2 = colorArray[1];
            colorArray = frameAttributes.getTitleBarColor();
            this.titleBarColor1 = colorArray[0];
            this.titleBarColor2 = colorArray[1];
            colorArray = frameAttributes.getTitleBarColor();
            this.scrollBarColor1 = colorArray[0];
            this.scrollBarColor2 = colorArray[1];
            this.minimizeButtonColor = frameAttributes.getMinimizeButtonColor();
            this.foregroundOpacity = frameAttributes.getForegroundOpacity();
            this.foregroundColor = frameAttributes.getForegroundColor();
            this.font = frameAttributes.getFont();
            this.textColor = frameAttributes.getTextColor();
            this.iconSize = frameAttributes.getIconSize();
            this.iconSpace = frameAttributes.getIconSpace();
            this.cornerRadius = frameAttributes.getCornerRadius();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BasicFrameAttributes basicFrameAttributes = (BasicFrameAttributes)object;
        if (this.backgroundOpacity != basicFrameAttributes.backgroundOpacity) {
            return false;
        }
        if (this.frameColor1 != null ? !this.frameColor1.equals(basicFrameAttributes.frameColor1) : basicFrameAttributes.frameColor1 != null) {
            return false;
        }
        if (this.frameColor2 != null ? !this.frameColor2.equals(basicFrameAttributes.frameColor2) : basicFrameAttributes.frameColor2 != null) {
            return false;
        }
        if (this.titleBarColor1 != null ? !this.titleBarColor1.equals(basicFrameAttributes.titleBarColor1) : basicFrameAttributes.titleBarColor1 != null) {
            return false;
        }
        if (this.titleBarColor2 != null ? !this.titleBarColor2.equals(basicFrameAttributes.titleBarColor2) : basicFrameAttributes.titleBarColor2 != null) {
            return false;
        }
        if (this.scrollBarColor1 != null ? !this.scrollBarColor1.equals(basicFrameAttributes.scrollBarColor1) : basicFrameAttributes.scrollBarColor1 != null) {
            return false;
        }
        if (this.scrollBarColor2 != null ? !this.scrollBarColor2.equals(basicFrameAttributes.scrollBarColor2) : basicFrameAttributes.scrollBarColor2 != null) {
            return false;
        }
        if (this.minimizeButtonColor != null ? !this.minimizeButtonColor.equals(basicFrameAttributes.minimizeButtonColor) : basicFrameAttributes.minimizeButtonColor != null) {
            return false;
        }
        if (this.foregroundOpacity != basicFrameAttributes.foregroundOpacity) {
            return false;
        }
        if (this.foregroundColor != null ? !this.foregroundColor.equals(basicFrameAttributes.foregroundColor) : basicFrameAttributes.foregroundColor != null) {
            return false;
        }
        if (this.font != null ? !this.font.equals(basicFrameAttributes.font) : basicFrameAttributes.font != null) {
            return false;
        }
        if (this.textColor != null ? !this.textColor.equals(basicFrameAttributes.textColor) : basicFrameAttributes.textColor != null) {
            return false;
        }
        if (this.iconSpace != basicFrameAttributes.iconSpace) {
            return false;
        }
        if (this.iconSize != null ? !this.iconSize.equals(basicFrameAttributes.iconSize) : basicFrameAttributes.iconSize != null) {
            return false;
        }
        return this.cornerRadius == basicFrameAttributes.cornerRadius;
    }

    public int hashCode() {
        int n = 12;
        long l = this.backgroundOpacity != 0.0 ? Double.doubleToLongBits(this.backgroundOpacity) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.frameColor1 != null ? this.frameColor1.hashCode() : 0);
        n = 31 * n + (this.frameColor2 != null ? this.frameColor2.hashCode() : 0);
        n = 31 * n + (this.titleBarColor1 != null ? this.titleBarColor1.hashCode() : 0);
        n = 31 * n + (this.titleBarColor2 != null ? this.titleBarColor2.hashCode() : 0);
        n = 31 * n + (this.scrollBarColor1 != null ? this.scrollBarColor1.hashCode() : 0);
        n = 31 * n + (this.scrollBarColor2 != null ? this.scrollBarColor2.hashCode() : 0);
        n = 31 * n + (this.minimizeButtonColor != null ? this.minimizeButtonColor.hashCode() : 0);
        l = this.foregroundOpacity != 0.0 ? Double.doubleToLongBits(this.foregroundOpacity) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.foregroundColor != null ? this.foregroundColor.hashCode() : 0);
        n = 31 * n + (this.font != null ? this.font.hashCode() : 0);
        n = 31 * n + (this.textColor != null ? this.textColor.hashCode() : 0);
        n = 31 * n + this.iconSpace;
        n = 31 * n + (this.iconSize != null ? this.iconSize.hashCode() : 0);
        n = 31 * n + this.cornerRadius;
        return n;
    }
}

